/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AbstractPermissions;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.PermissionChecker;
import org.thingsboard.server.service.security.permission.Resource;

@Component(value="tenantAdminPermissions")
public class TenantAdminPermissions
extends AbstractPermissions {
    public static final PermissionChecker tenantEntityPermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker tenantPermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            return user.getTenantId().equals((Object)entityId);
        }
    };
    private static final PermissionChecker userPermissionChecker = new PermissionChecker<UserId, User>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, UserId userId, User userEntity) {
            if (Authority.SYS_ADMIN.equals((Object)userEntity.getAuthority())) {
                return false;
            }
            return user.getTenantId().equals((Object)userEntity.getTenantId());
        }
    };
    private static final PermissionChecker widgetsPermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return operation == Operation.READ;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker tbResourcePermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return operation == Operation.READ;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker queuePermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return operation == Operation.READ;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker<AiModelId, AiModel> aiModelPermissionChecker = new PermissionChecker<AiModelId, AiModel>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation) {
            return true;
        }

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, AiModelId entityId, AiModel entity) {
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };

    public TenantAdminPermissions() {
        this.put(Resource.ADMIN_SETTINGS, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.ALARM, tenantEntityPermissionChecker);
        this.put(Resource.ASSET, tenantEntityPermissionChecker);
        this.put(Resource.DEVICE, tenantEntityPermissionChecker);
        this.put(Resource.CUSTOMER, tenantEntityPermissionChecker);
        this.put(Resource.DASHBOARD, tenantEntityPermissionChecker);
        this.put(Resource.ENTITY_VIEW, tenantEntityPermissionChecker);
        this.put(Resource.TENANT, tenantPermissionChecker);
        this.put(Resource.RULE_CHAIN, tenantEntityPermissionChecker);
        this.put(Resource.USER, userPermissionChecker);
        this.put(Resource.WIDGETS_BUNDLE, widgetsPermissionChecker);
        this.put(Resource.WIDGET_TYPE, widgetsPermissionChecker);
        this.put(Resource.DEVICE_PROFILE, tenantEntityPermissionChecker);
        this.put(Resource.ASSET_PROFILE, tenantEntityPermissionChecker);
        this.put(Resource.API_USAGE_STATE, tenantEntityPermissionChecker);
        this.put(Resource.TB_RESOURCE, tbResourcePermissionChecker);
        this.put(Resource.OTA_PACKAGE, tenantEntityPermissionChecker);
        this.put(Resource.EDGE, tenantEntityPermissionChecker);
        this.put(Resource.RPC, tenantEntityPermissionChecker);
        this.put(Resource.QUEUE, queuePermissionChecker);
        this.put(Resource.VERSION_CONTROL, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.NOTIFICATION, tenantEntityPermissionChecker);
        this.put(Resource.MOBILE_APP_SETTINGS, new PermissionChecker.GenericPermissionChecker(Operation.READ));
        this.put(Resource.OAUTH2_CLIENT, tenantEntityPermissionChecker);
        this.put(Resource.OAUTH2_CONFIGURATION_TEMPLATE, new PermissionChecker.GenericPermissionChecker(Operation.READ));
        this.put(Resource.MOBILE_APP, tenantEntityPermissionChecker);
        this.put(Resource.MOBILE_APP_BUNDLE, tenantEntityPermissionChecker);
        this.put(Resource.JOB, tenantEntityPermissionChecker);
        this.put(Resource.AI_MODEL, aiModelPermissionChecker);
    }
}

