/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AbstractPermissions;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.PermissionChecker;
import org.thingsboard.server.service.security.permission.Resource;

@Component(value="sysAdminPermissions")
public class SysAdminPermissions
extends AbstractPermissions {
    private static final PermissionChecker systemEntityPermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            return entity.getTenantId() == null || entity.getTenantId().isNullUid();
        }
    };
    private static final PermissionChecker userPermissionChecker = new PermissionChecker<UserId, User>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, UserId userId, User userEntity) {
            return !Authority.CUSTOMER_USER.equals((Object)userEntity.getAuthority());
        }
    };

    public SysAdminPermissions() {
        this.put(Resource.ADMIN_SETTINGS, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.DASHBOARD, new PermissionChecker.GenericPermissionChecker(Operation.READ));
        this.put(Resource.TENANT, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.RULE_CHAIN, systemEntityPermissionChecker);
        this.put(Resource.USER, userPermissionChecker);
        this.put(Resource.WIDGETS_BUNDLE, systemEntityPermissionChecker);
        this.put(Resource.WIDGET_TYPE, systemEntityPermissionChecker);
        this.put(Resource.OAUTH2_CLIENT, systemEntityPermissionChecker);
        this.put(Resource.MOBILE_APP, systemEntityPermissionChecker);
        this.put(Resource.MOBILE_APP_BUNDLE, systemEntityPermissionChecker);
        this.put(Resource.DOMAIN, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.OAUTH2_CONFIGURATION_TEMPLATE, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.TENANT_PROFILE, PermissionChecker.allowAllPermissionChecker);
        this.put(Resource.TB_RESOURCE, systemEntityPermissionChecker);
        this.put(Resource.QUEUE, systemEntityPermissionChecker);
        this.put(Resource.NOTIFICATION, systemEntityPermissionChecker);
        this.put(Resource.MOBILE_APP_SETTINGS, PermissionChecker.allowAllPermissionChecker);
    }
}

