/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AbstractPermissions;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.PermissionChecker;
import org.thingsboard.server.service.security.permission.Resource;

@Component(value="customerUserPermissions")
public class CustomerUserPermissions
extends AbstractPermissions {
    private static final PermissionChecker customerAlarmPermissionChecker = new PermissionChecker(){

        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!user.getTenantId().equals((Object)entity.getTenantId())) {
                return false;
            }
            if (!(entity instanceof HasCustomerId)) {
                return false;
            }
            return user.getCustomerId().equals((Object)((HasCustomerId)entity).getCustomerId());
        }
    };
    private static final PermissionChecker customerEntityPermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ, Operation.READ_CREDENTIALS, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.RPC_CALL, Operation.CLAIM_DEVICES, Operation.WRITE, Operation.WRITE_ATTRIBUTES, Operation.WRITE_TELEMETRY}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            if (!user.getTenantId().equals((Object)entity.getTenantId())) {
                return false;
            }
            if (!(entity instanceof HasCustomerId)) {
                return false;
            }
            return operation.equals((Object)Operation.CLAIM_DEVICES) || user.getCustomerId().equals((Object)((HasCustomerId)entity).getCustomerId());
        }
    };
    private static final PermissionChecker customerPermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            return user.getCustomerId().equals((Object)entityId);
        }
    };
    private static final PermissionChecker customerResourcePermissionChecker = new PermissionChecker<TbResourceId, TbResourceInfo>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, TbResourceId resourceId, TbResourceInfo resource) {
            if (operation != Operation.READ) {
                return false;
            }
            if (resource.getResourceType() == null || !resource.getResourceType().isCustomerAccess()) {
                return false;
            }
            if (resource.getTenantId() == null || resource.getTenantId().isNullUid()) {
                return true;
            }
            return user.getTenantId().equals((Object)resource.getTenantId());
        }
    };
    private static final PermissionChecker customerDashboardPermissionChecker = new PermissionChecker.GenericPermissionChecker<DashboardId, DashboardInfo>(new Operation[]{Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, DashboardId dashboardId, DashboardInfo dashboard) {
            if (!super.hasPermission(user, operation, dashboardId, dashboard)) {
                return false;
            }
            if (!user.getTenantId().equals((Object)dashboard.getTenantId())) {
                return false;
            }
            return dashboard.isAssignedToCustomer(user.getCustomerId());
        }
    };
    private static final PermissionChecker userPermissionChecker = new PermissionChecker<UserId, User>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, UserId userId, User userEntity) {
            if (!Authority.CUSTOMER_USER.equals((Object)userEntity.getAuthority())) {
                return false;
            }
            if (!user.getCustomerId().equals((Object)userEntity.getCustomerId())) {
                return false;
            }
            if (Operation.READ.equals((Object)operation)) {
                return true;
            }
            return user.getId().equals((Object)userId);
        }
    };
    private static final PermissionChecker widgetsPermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return true;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker rpcPermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return true;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };
    private static final PermissionChecker profilePermissionChecker = new PermissionChecker.GenericPermissionChecker(new Operation[]{Operation.READ}){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            if (!super.hasPermission(user, operation, entityId, entity)) {
                return false;
            }
            if (entity.getTenantId() == null || entity.getTenantId().isNullUid()) {
                return true;
            }
            return user.getTenantId().equals((Object)entity.getTenantId());
        }
    };

    public CustomerUserPermissions() {
        this.put(Resource.ALARM, customerAlarmPermissionChecker);
        this.put(Resource.ASSET, customerEntityPermissionChecker);
        this.put(Resource.DEVICE, customerEntityPermissionChecker);
        this.put(Resource.CUSTOMER, customerPermissionChecker);
        this.put(Resource.DASHBOARD, customerDashboardPermissionChecker);
        this.put(Resource.ENTITY_VIEW, customerEntityPermissionChecker);
        this.put(Resource.USER, userPermissionChecker);
        this.put(Resource.WIDGETS_BUNDLE, widgetsPermissionChecker);
        this.put(Resource.WIDGET_TYPE, widgetsPermissionChecker);
        this.put(Resource.EDGE, customerEntityPermissionChecker);
        this.put(Resource.RPC, rpcPermissionChecker);
        this.put(Resource.DEVICE_PROFILE, profilePermissionChecker);
        this.put(Resource.ASSET_PROFILE, profilePermissionChecker);
        this.put(Resource.TB_RESOURCE, customerResourcePermissionChecker);
        this.put(Resource.MOBILE_APP_SETTINGS, new PermissionChecker.GenericPermissionChecker(Operation.READ));
    }
}

