/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.device;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsFilter;
import org.thingsboard.server.common.transport.auth.DeviceAuthResult;
import org.thingsboard.server.common.transport.auth.DeviceAuthService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@Service
@TbCoreComponent
public class DefaultDeviceAuthService
implements DeviceAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceAuthService.class);
    private final DeviceService deviceService;
    private final DeviceCredentialsService deviceCredentialsService;

    public DefaultDeviceAuthService(DeviceService deviceService, DeviceCredentialsService deviceCredentialsService) {
        this.deviceService = deviceService;
        this.deviceCredentialsService = deviceCredentialsService;
    }

    public DeviceAuthResult process(DeviceCredentialsFilter credentialsFilter) {
        log.trace("Lookup device credentials using filter {}", (Object)credentialsFilter);
        DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(credentialsFilter.getCredentialsId());
        if (credentials != null) {
            log.trace("Credentials found {}", (Object)credentials);
            if (credentials.getCredentialsType() == credentialsFilter.getCredentialsType()) {
                switch (credentials.getCredentialsType()) {
                    case ACCESS_TOKEN: {
                        return DeviceAuthResult.of((DeviceId)credentials.getDeviceId());
                    }
                    case X509_CERTIFICATE: {
                        return DeviceAuthResult.of((DeviceId)credentials.getDeviceId());
                    }
                    case LWM2M_CREDENTIALS: {
                        return DeviceAuthResult.of((DeviceId)credentials.getDeviceId());
                    }
                }
                return DeviceAuthResult.of((String)"Credentials Type is not supported yet!");
            }
            return DeviceAuthResult.of((String)"Credentials Type mismatch!");
        }
        log.trace("Credentials not found!");
        return DeviceAuthResult.of((String)"Credentials Not Found!");
    }
}

