/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import lombok.Generated;
import ua_parser.Client;
import ua_parser.Parser;

public class RestAuthenticationDetails
implements Serializable {
    private final String clientAddress;
    private final Client userAgent;

    public RestAuthenticationDetails(HttpServletRequest request) {
        this.clientAddress = RestAuthenticationDetails.getClientIP(request);
        this.userAgent = RestAuthenticationDetails.getUserAgent(request);
    }

    private static String getClientIP(HttpServletRequest request) {
        String xfHeader = request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }

    private static Client getUserAgent(HttpServletRequest request) {
        Parser uaParser = new Parser();
        return uaParser.parse(request.getHeader("User-Agent"));
    }

    @Generated
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Generated
    public Client getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAuthenticationDetails)) {
            return false;
        }
        RestAuthenticationDetails other = (RestAuthenticationDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientAddress = this.getClientAddress();
        String other$clientAddress = other.getClientAddress();
        if (this$clientAddress == null ? other$clientAddress != null : !this$clientAddress.equals(other$clientAddress)) {
            return false;
        }
        Client this$userAgent = this.getUserAgent();
        Client other$userAgent = other.getUserAgent();
        return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestAuthenticationDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientAddress = this.getClientAddress();
        result = result * 59 + ($clientAddress == null ? 43 : $clientAddress.hashCode());
        Client $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestAuthenticationDetails(clientAddress=" + this.getClientAddress() + ", userAgent=" + String.valueOf(this.getUserAgent()) + ")";
    }
}

