/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.AbstractOAuth2ClientMapper;
import org.thingsboard.server.service.security.auth.oauth2.BasicMapperUtils;
import org.thingsboard.server.service.security.auth.oauth2.OAuth2ClientMapper;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service(value="appleOAuth2ClientMapper")
@TbCoreComponent
public class AppleOAuth2ClientMapper
extends AbstractOAuth2ClientMapper
implements OAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppleOAuth2ClientMapper.class);
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String EMAIL = "email";

    @Override
    public SecurityUser getOrCreateUserByClientPrincipal(HttpServletRequest request, OAuth2AuthenticationToken token, String providerAccessToken, OAuth2Client oAuth2Client) {
        OAuth2MapperConfig config = oAuth2Client.getMapperConfig();
        Map<String, Object> attributes = AppleOAuth2ClientMapper.updateAttributesFromRequestParams(request, token.getPrincipal().getAttributes());
        String email = BasicMapperUtils.getStringAttributeByKey(attributes, config.getBasic().getEmailAttributeKey());
        OAuth2User oauth2User = BasicMapperUtils.getOAuth2User(email, attributes, config);
        return this.getOrCreateSecurityUserFromOAuth2User(oauth2User, oAuth2Client);
    }

    private static Map<String, Object> updateAttributesFromRequestParams(HttpServletRequest request, Map<String, Object> attributes) {
        Map<String, Object> updated = attributes;
        MultiValueMap<String, String> params = AppleOAuth2ClientMapper.toMultiMap(request.getParameterMap());
        String userValue = (String)params.getFirst((Object)USER);
        if (StringUtils.hasText((String)userValue)) {
            JsonNode user = null;
            try {
                user = JacksonUtil.toJsonNode((String)userValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (user != null) {
                JsonNode email;
                JsonNode name;
                updated = new HashMap<String, Object>(attributes);
                if (user.has(NAME) && (name = user.get(NAME)).isObject()) {
                    JsonNode lastName;
                    JsonNode firstName = name.get(FIRST_NAME);
                    if (firstName != null && firstName.isTextual()) {
                        updated.put(FIRST_NAME, firstName.asText());
                    }
                    if ((lastName = name.get(LAST_NAME)) != null && lastName.isTextual()) {
                        updated.put(LAST_NAME, lastName.asText());
                    }
                }
                if (user.has(EMAIL) && (email = user.get(EMAIL)) != null && email.isTextual()) {
                    updated.put(EMAIL, email.asText());
                }
            }
        }
        return updated;
    }

    private static MultiValueMap<String, String> toMultiMap(Map<String, String[]> map) {
        LinkedMultiValueMap params = new LinkedMultiValueMap(map.size());
        map.forEach((arg_0, arg_1) -> AppleOAuth2ClientMapper.lambda$toMultiMap$0((MultiValueMap)params, arg_0, arg_1));
        return params;
    }

    private static /* synthetic */ void lambda$toMultiMap$0(MultiValueMap params, String key, String[] values) {
        if (values.length > 0) {
            for (String value : values) {
                params.add((Object)key, (Object)value);
            }
        }
    }
}

