/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.mfa.provider.impl;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.security.model.mfa.account.OtpBasedTwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.OtpBasedTwoFaProviderConfig;
import org.thingsboard.server.service.security.auth.mfa.provider.TwoFaProvider;
import org.thingsboard.server.service.security.model.SecurityUser;

public abstract class OtpBasedTwoFaProvider<C extends OtpBasedTwoFaProviderConfig, A extends OtpBasedTwoFaAccountConfig>
implements TwoFaProvider<C, A> {
    private final Cache verificationCodesCache;

    protected OtpBasedTwoFaProvider(CacheManager cacheManager) {
        this.verificationCodesCache = cacheManager.getCache("twoFaVerificationCodes");
    }

    @Override
    public final void prepareVerificationCode(SecurityUser user, C providerConfig, A accountConfig) throws ThingsboardException {
        String verificationCode = StringUtils.randomNumeric((int)6);
        this.sendVerificationCode(user, verificationCode, providerConfig, accountConfig);
        this.verificationCodesCache.put((Object)user.getId(), (Object)new Otp(System.currentTimeMillis(), verificationCode, (OtpBasedTwoFaAccountConfig)accountConfig));
    }

    protected abstract void sendVerificationCode(SecurityUser var1, String var2, C var3, A var4) throws ThingsboardException;

    @Override
    public final boolean checkVerificationCode(SecurityUser user, String code, C providerConfig, A accountConfig) {
        Otp correctVerificationCode = (Otp)this.verificationCodesCache.get((Object)user.getId(), Otp.class);
        if (correctVerificationCode != null) {
            if (System.currentTimeMillis() - correctVerificationCode.getTimestamp() > TimeUnit.SECONDS.toMillis(providerConfig.getVerificationCodeLifetime())) {
                this.verificationCodesCache.evict((Object)user.getId());
                return false;
            }
            if (code.equals(correctVerificationCode.getValue()) && accountConfig.equals((Object)correctVerificationCode.getAccountConfig())) {
                this.verificationCodesCache.evict((Object)user.getId());
                return true;
            }
        }
        return false;
    }

    public static class Otp
    implements Serializable {
        private final long timestamp;
        private final String value;
        private final OtpBasedTwoFaAccountConfig accountConfig;

        @ConstructorProperties(value={"timestamp", "value", "accountConfig"})
        @Generated
        public Otp(long timestamp, String value, OtpBasedTwoFaAccountConfig accountConfig) {
            this.timestamp = timestamp;
            this.value = value;
            this.accountConfig = accountConfig;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public OtpBasedTwoFaAccountConfig getAccountConfig() {
            return this.accountConfig;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Otp)) {
                return false;
            }
            Otp other = (Otp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            OtpBasedTwoFaAccountConfig this$accountConfig = this.getAccountConfig();
            OtpBasedTwoFaAccountConfig other$accountConfig = other.getAccountConfig();
            return !(this$accountConfig == null ? other$accountConfig != null : !this$accountConfig.equals(other$accountConfig));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Otp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            OtpBasedTwoFaAccountConfig $accountConfig = this.getAccountConfig();
            result = result * 59 + ($accountConfig == null ? 43 : $accountConfig.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OtpBasedTwoFaProvider.Otp(timestamp=" + this.getTimestamp() + ", value=" + this.getValue() + ", accountConfig=" + String.valueOf(this.getAccountConfig()) + ")";
        }
    }
}

