/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.mfa;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.TwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.auth.mfa.provider.TwoFaProvider;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Service
@TbCoreComponent
public class DefaultTwoFactorAuthService
implements TwoFactorAuthService {
    private final TwoFaConfigManager configManager;
    private final SystemSecurityService systemSecurityService;
    private final UserService userService;
    private final RateLimitService rateLimitService;
    private final Map<TwoFaProviderType, TwoFaProvider<TwoFaProviderConfig, TwoFaAccountConfig>> providers = new EnumMap<TwoFaProviderType, TwoFaProvider<TwoFaProviderConfig, TwoFaAccountConfig>>(TwoFaProviderType.class);
    private static final ThingsboardException ACCOUNT_NOT_CONFIGURED_ERROR = new ThingsboardException("2FA is not configured for account", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
    private static final ThingsboardException PROVIDER_NOT_CONFIGURED_ERROR = new ThingsboardException("2FA provider is not configured", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
    private static final ThingsboardException PROVIDER_NOT_AVAILABLE_ERROR = new ThingsboardException("2FA provider is not available", ThingsboardErrorCode.GENERAL);
    private static final ThingsboardException TOO_MANY_REQUESTS_ERROR = new ThingsboardException("Too many requests", ThingsboardErrorCode.TOO_MANY_REQUESTS);

    @Override
    public boolean isTwoFaEnabled(TenantId tenantId, UserId userId) {
        return this.configManager.getAccountTwoFaSettings(tenantId, userId).map(settings -> !settings.getConfigs().isEmpty()).orElse(false);
    }

    @Override
    public void checkProvider(TenantId tenantId, TwoFaProviderType providerType) throws ThingsboardException {
        this.getTwoFaProvider(providerType).check(tenantId);
    }

    @Override
    public void prepareVerificationCode(SecurityUser user, TwoFaProviderType providerType, boolean checkLimits) throws Exception {
        TwoFaAccountConfig accountConfig = this.configManager.getTwoFaAccountConfig(user.getTenantId(), user.getId(), providerType).orElseThrow(() -> ACCOUNT_NOT_CONFIGURED_ERROR);
        this.prepareVerificationCode(user, accountConfig, checkLimits);
    }

    @Override
    public void prepareVerificationCode(SecurityUser user, TwoFaAccountConfig accountConfig, boolean checkLimits) throws ThingsboardException {
        PlatformTwoFaSettings twoFaSettings = this.configManager.getPlatformTwoFaSettings(user.getTenantId(), true).orElseThrow(() -> PROVIDER_NOT_CONFIGURED_ERROR);
        if (checkLimits) {
            Integer minVerificationCodeSendPeriod = twoFaSettings.getMinVerificationCodeSendPeriod();
            String rateLimit = null;
            if (minVerificationCodeSendPeriod != null && minVerificationCodeSendPeriod > 4) {
                rateLimit = "1:" + minVerificationCodeSendPeriod;
            }
            if (!this.rateLimitService.checkRateLimit(LimitedApi.TWO_FA_VERIFICATION_CODE_SEND, (Object)Pair.of((Object)user.getId(), (Object)accountConfig.getProviderType()), rateLimit)) {
                throw TOO_MANY_REQUESTS_ERROR;
            }
        }
        TwoFaProviderConfig providerConfig = (TwoFaProviderConfig)twoFaSettings.getProviderConfig(accountConfig.getProviderType()).orElseThrow(() -> PROVIDER_NOT_CONFIGURED_ERROR);
        this.getTwoFaProvider(accountConfig.getProviderType()).prepareVerificationCode(user, providerConfig, accountConfig);
    }

    @Override
    public boolean checkVerificationCode(SecurityUser user, TwoFaProviderType providerType, String verificationCode, boolean checkLimits) throws ThingsboardException {
        TwoFaAccountConfig accountConfig = this.configManager.getTwoFaAccountConfig(user.getTenantId(), user.getId(), providerType).orElseThrow(() -> ACCOUNT_NOT_CONFIGURED_ERROR);
        return this.checkVerificationCode(user, verificationCode, accountConfig, checkLimits);
    }

    @Override
    public boolean checkVerificationCode(SecurityUser user, String verificationCode, TwoFaAccountConfig accountConfig, boolean checkLimits) throws ThingsboardException {
        if (!this.userService.findUserCredentialsByUserId(user.getTenantId(), user.getId()).isEnabled()) {
            throw new ThingsboardException("User is disabled", ThingsboardErrorCode.AUTHENTICATION);
        }
        PlatformTwoFaSettings twoFaSettings = this.configManager.getPlatformTwoFaSettings(user.getTenantId(), true).orElseThrow(() -> PROVIDER_NOT_CONFIGURED_ERROR);
        if (checkLimits && !this.rateLimitService.checkRateLimit(LimitedApi.TWO_FA_VERIFICATION_CODE_CHECK, (Object)Pair.of((Object)user.getId(), (Object)accountConfig.getProviderType()), twoFaSettings.getVerificationCodeCheckRateLimit())) {
            throw TOO_MANY_REQUESTS_ERROR;
        }
        TwoFaProviderConfig providerConfig = (TwoFaProviderConfig)twoFaSettings.getProviderConfig(accountConfig.getProviderType()).orElseThrow(() -> PROVIDER_NOT_CONFIGURED_ERROR);
        boolean verificationSuccess = false;
        if (StringUtils.isNotBlank((String)verificationCode) && (StringUtils.isNumeric((String)verificationCode) || accountConfig.getProviderType() == TwoFaProviderType.BACKUP_CODE)) {
            verificationSuccess = this.getTwoFaProvider(accountConfig.getProviderType()).checkVerificationCode(user, verificationCode, providerConfig, accountConfig);
        }
        if (checkLimits) {
            try {
                this.systemSecurityService.validateTwoFaVerification(user, verificationSuccess, twoFaSettings);
            }
            catch (LockedException e) {
                this.cleanUpRateLimits(user.getId());
                throw new ThingsboardException(e.getMessage(), ThingsboardErrorCode.AUTHENTICATION);
            }
            if (verificationSuccess) {
                this.cleanUpRateLimits(user.getId());
            }
        }
        return verificationSuccess;
    }

    @Override
    public TwoFaAccountConfig generateNewAccountConfig(User user, TwoFaProviderType providerType) throws ThingsboardException {
        TwoFaProviderConfig providerConfig = this.getTwoFaProviderConfig(user.getTenantId(), providerType);
        return this.getTwoFaProvider(providerType).generateNewAccountConfig(user, providerConfig);
    }

    private void cleanUpRateLimits(UserId userId) {
        for (TwoFaProviderType providerType : TwoFaProviderType.values()) {
            this.rateLimitService.cleanUp(LimitedApi.TWO_FA_VERIFICATION_CODE_SEND, (Object)Pair.of((Object)userId, (Object)providerType));
            this.rateLimitService.cleanUp(LimitedApi.TWO_FA_VERIFICATION_CODE_CHECK, (Object)Pair.of((Object)userId, (Object)providerType));
        }
    }

    private TwoFaProviderConfig getTwoFaProviderConfig(TenantId tenantId, TwoFaProviderType providerType) throws ThingsboardException {
        return (TwoFaProviderConfig)this.configManager.getPlatformTwoFaSettings(tenantId, true).flatMap(twoFaSettings -> twoFaSettings.getProviderConfig(providerType)).orElseThrow(() -> PROVIDER_NOT_CONFIGURED_ERROR);
    }

    private TwoFaProvider<TwoFaProviderConfig, TwoFaAccountConfig> getTwoFaProvider(TwoFaProviderType providerType) throws ThingsboardException {
        return Optional.ofNullable(this.providers.get(providerType)).orElseThrow(() -> PROVIDER_NOT_AVAILABLE_ERROR);
    }

    @Autowired
    private void setProviders(Collection<TwoFaProvider> providers) {
        providers.forEach(provider -> this.providers.put(provider.getType(), (TwoFaProvider<TwoFaProviderConfig, TwoFaAccountConfig>)provider));
    }

    @ConstructorProperties(value={"configManager", "systemSecurityService", "userService", "rateLimitService"})
    @Generated
    public DefaultTwoFactorAuthService(TwoFaConfigManager configManager, SystemSecurityService systemSecurityService, UserService userService, RateLimitService rateLimitService) {
        this.configManager = configManager;
        this.systemSecurityService = systemSecurityService;
        this.userService = userService;
        this.rateLimitService = rateLimitService;
    }
}

