/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.security.auth.RefreshAuthenticationToken;
import org.thingsboard.server.service.security.auth.TokenOutdatingService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.model.token.RawAccessJwtToken;

@Component
public class RefreshTokenAuthenticationProvider
implements AuthenticationProvider {
    private final JwtTokenFactory tokenFactory;
    private final UserService userService;
    private final CustomerService customerService;
    private final TokenOutdatingService tokenOutdatingService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        RawAccessJwtToken rawAccessToken = (RawAccessJwtToken)authentication.getCredentials();
        SecurityUser unsafeUser = this.tokenFactory.parseRefreshToken(rawAccessToken.getToken());
        UserPrincipal principal = unsafeUser.getUserPrincipal();
        SecurityUser securityUser = principal.getType() == UserPrincipal.Type.USER_NAME ? this.authenticateByUserId(unsafeUser.getId()) : this.authenticateByPublicId(principal.getValue());
        securityUser.setSessionId(unsafeUser.getSessionId());
        if (this.tokenOutdatingService.isOutdated(rawAccessToken.getToken(), securityUser.getId())) {
            throw new CredentialsExpiredException("Token is outdated");
        }
        return new RefreshAuthenticationToken(securityUser);
    }

    private SecurityUser authenticateByUserId(UserId userId) {
        TenantId systemId = TenantId.SYS_TENANT_ID;
        User user = this.userService.findUserById(systemId, userId);
        if (user == null) {
            throw new UsernameNotFoundException("User not found by refresh token");
        }
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(systemId, user.getId());
        if (userCredentials == null) {
            throw new UsernameNotFoundException("User credentials not found");
        }
        if (!userCredentials.isEnabled()) {
            throw new DisabledException("User is not active");
        }
        if (user.getAuthority() == null) {
            throw new InsufficientAuthenticationException("User has no authority assigned");
        }
        UserPrincipal userPrincipal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        SecurityUser securityUser = new SecurityUser(user, userCredentials.isEnabled(), userPrincipal);
        return securityUser;
    }

    private SecurityUser authenticateByPublicId(String publicId) {
        CustomerId customerId;
        TenantId systemId = TenantId.SYS_TENANT_ID;
        try {
            customerId = new CustomerId(UUID.fromString(publicId));
        }
        catch (Exception e) {
            throw new BadCredentialsException("Refresh token is not valid");
        }
        Customer publicCustomer = this.customerService.findCustomerById(systemId, customerId);
        if (publicCustomer == null) {
            throw new UsernameNotFoundException("Public entity not found by refresh token");
        }
        if (!publicCustomer.isPublic()) {
            throw new BadCredentialsException("Refresh token is not valid");
        }
        User user = new User(new UserId(EntityId.NULL_UUID));
        user.setTenantId(publicCustomer.getTenantId());
        user.setCustomerId(publicCustomer.getId());
        user.setEmail(publicId);
        user.setAuthority(Authority.CUSTOMER_USER);
        user.setFirstName("Public");
        user.setLastName("Public");
        UserPrincipal userPrincipal = new UserPrincipal(UserPrincipal.Type.PUBLIC_ID, publicId);
        SecurityUser securityUser = new SecurityUser(user, true, userPrincipal);
        return securityUser;
    }

    public boolean supports(Class<?> authentication) {
        return RefreshAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @ConstructorProperties(value={"tokenFactory", "userService", "customerService", "tokenOutdatingService"})
    @Generated
    public RefreshTokenAuthenticationProvider(JwtTokenFactory tokenFactory, UserService userService, CustomerService customerService, TokenOutdatingService tokenOutdatingService) {
        this.tokenFactory = tokenFactory;
        this.userService = userService;
        this.customerService = customerService;
        this.tokenOutdatingService = tokenOutdatingService;
    }
}

