/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth;

import io.jsonwebtoken.Claims;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.event.UserAuthDataChangedEvent;
import org.thingsboard.server.service.security.auth.TokenOutdatingService;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Service
public class DefaultTokenOutdatingService
implements TokenOutdatingService {
    private final TbTransactionalCache<String, Long> cache;
    private final JwtTokenFactory tokenFactory;

    public DefaultTokenOutdatingService(@Qualifier(value="UsersSessionInvalidation") TbTransactionalCache<String, Long> cache, JwtTokenFactory tokenFactory) {
        this.cache = cache;
        this.tokenFactory = tokenFactory;
    }

    @EventListener(classes={UserAuthDataChangedEvent.class})
    public void onUserAuthDataChanged(UserAuthDataChangedEvent event) {
        if (StringUtils.hasText((String)event.getId())) {
            this.cache.put((Serializable)((Object)event.getId()), (Serializable)Long.valueOf(event.getTs()));
        }
    }

    @Override
    public boolean isOutdated(String token, UserId userId) {
        Claims claims = (Claims)this.tokenFactory.parseTokenClaims(token).getBody();
        long issueTime = claims.getIssuedAt().getTime();
        String sessionId = (String)claims.get("sessionId", String.class);
        if (this.isTokenOutdated(issueTime, userId.toString()).booleanValue()) {
            return true;
        }
        return sessionId != null && this.isTokenOutdated(issueTime, sessionId) != false;
    }

    private Boolean isTokenOutdated(long issueTime, String sessionId) {
        return Optional.ofNullable(this.cache.get((Serializable)((Object)sessionId))).map(outdatageTime -> this.isTokenOutdated(issueTime, (Long)outdatageTime.get())).orElse(false);
    }

    private boolean isTokenOutdated(long issueTime, Long outdatageTime) {
        return TimeUnit.MILLISECONDS.toSeconds(issueTime) < TimeUnit.MILLISECONDS.toSeconds(outdatageTime);
    }
}

