/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.script;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class RuleNodeScriptEngine<T extends ScriptInvokeService, R>
implements ScriptEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleNodeScriptEngine.class);
    private final T scriptInvokeService;
    protected final UUID scriptId;
    private final TenantId tenantId;

    public RuleNodeScriptEngine(TenantId tenantId, T scriptInvokeService, String script, String ... argNames) {
        this.tenantId = tenantId;
        this.scriptInvokeService = scriptInvokeService;
        try {
            this.scriptId = (UUID)this.scriptInvokeService.eval(tenantId, ScriptType.RULE_NODE_SCRIPT, script, argNames).get();
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof ExecutionException) {
                t = e.getCause();
            }
            if (t instanceof TbScriptException) {
                TbScriptException scriptException = (TbScriptException)t;
                throw scriptException;
            }
            throw new RuntimeException("Unexpected error when creating script engine: " + t.getMessage(), t);
        }
    }

    protected abstract Object[] prepareArgs(TbMsg var1);

    public ListenableFuture<List<TbMsg>> executeUpdateAsync(TbMsg msg) {
        ListenableFuture<R> result = this.executeScriptAsync(msg);
        return Futures.transform(result, json -> this.executeUpdateTransform(msg, json), (Executor)MoreExecutors.directExecutor());
    }

    protected abstract List<TbMsg> executeUpdateTransform(TbMsg var1, R var2);

    public ListenableFuture<TbMsg> executeGenerateAsync(TbMsg prevMsg) {
        return Futures.transform(this.executeScriptAsync(prevMsg), result -> this.executeGenerateTransform(prevMsg, result), (Executor)MoreExecutors.directExecutor());
    }

    protected abstract TbMsg executeGenerateTransform(TbMsg var1, R var2);

    public ListenableFuture<Boolean> executeFilterAsync(TbMsg msg) {
        return Futures.transform(this.executeScriptAsync(msg), this::executeFilterTransform, (Executor)MoreExecutors.directExecutor());
    }

    protected abstract boolean executeFilterTransform(R var1);

    public ListenableFuture<Set<String>> executeSwitchAsync(TbMsg msg) {
        return Futures.transform(this.executeScriptAsync(msg), this::executeSwitchTransform, (Executor)MoreExecutors.directExecutor());
    }

    protected abstract Set<String> executeSwitchTransform(R var1);

    public ListenableFuture<String> executeToStringAsync(TbMsg msg) {
        return Futures.transform(this.executeScriptAsync(msg), this::executeToStringTransform, (Executor)MoreExecutors.directExecutor());
    }

    protected abstract String executeToStringTransform(R var1);

    ListenableFuture<R> executeScriptAsync(TbMsg msg) {
        log.trace("execute script async, msg {}", (Object)msg);
        Object[] inArgs = this.prepareArgs(msg);
        return this.executeScriptAsync(msg.getCustomerId(), inArgs[0], inArgs[1], inArgs[2]);
    }

    private ListenableFuture<R> executeScriptAsync(CustomerId customerId, Object ... args) {
        return Futures.transform((ListenableFuture)this.scriptInvokeService.invokeScript(this.tenantId, customerId, this.scriptId, args), this::convertResult, (Executor)MoreExecutors.directExecutor());
    }

    public void destroy() {
        this.scriptInvokeService.release(this.scriptId);
    }

    protected abstract R convertResult(Object var1);
}

