/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.script;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.service.script.RuleNodeScriptEngine;

public class RuleNodeJsScriptEngine
extends RuleNodeScriptEngine<JsInvokeService, JsonNode> {
    public RuleNodeJsScriptEngine(TenantId tenantId, JsInvokeService scriptInvokeService, String script, String ... argNames) {
        super(tenantId, scriptInvokeService, script, argNames);
    }

    @Override
    protected Object[] prepareArgs(TbMsg msg) {
        Object[] args = new String[]{msg.getData() != null ? msg.getData() : "", JacksonUtil.toString((Object)msg.getMetaData().getData()), msg.getType()};
        return args;
    }

    @Override
    protected List<TbMsg> executeUpdateTransform(TbMsg msg, JsonNode json) {
        if (json.isObject()) {
            return Collections.singletonList(RuleNodeJsScriptEngine.unbindMsg(json, msg));
        }
        if (json.isArray()) {
            ArrayList<TbMsg> res = new ArrayList<TbMsg>(json.size());
            json.forEach(jsonObject -> res.add(RuleNodeJsScriptEngine.unbindMsg(jsonObject, msg)));
            return res;
        }
        throw this.wrongResultType(json);
    }

    @Override
    protected TbMsg executeGenerateTransform(TbMsg prevMsg, JsonNode result) {
        if (!result.isObject()) {
            throw this.wrongResultType(result);
        }
        return RuleNodeJsScriptEngine.unbindMsg(result, prevMsg);
    }

    @Override
    protected boolean executeFilterTransform(JsonNode json) {
        if (json.isBoolean()) {
            return json.asBoolean();
        }
        throw this.wrongResultType(json);
    }

    @Override
    protected Set<String> executeSwitchTransform(JsonNode result) {
        if (result.isTextual()) {
            return Collections.singleton(result.asText());
        }
        if (result.isArray()) {
            HashSet<String> nextStates = new HashSet<String>();
            for (JsonNode val : result) {
                if (!val.isTextual()) {
                    throw this.wrongResultType(val);
                }
                nextStates.add(val.asText());
            }
            return nextStates;
        }
        throw this.wrongResultType(result);
    }

    public ListenableFuture<JsonNode> executeJsonAsync(TbMsg msg) {
        return this.executeScriptAsync(msg);
    }

    @Override
    protected String executeToStringTransform(JsonNode result) {
        if (result.isTextual()) {
            return result.asText();
        }
        throw this.wrongResultType(result);
    }

    @Override
    protected JsonNode convertResult(Object result) {
        return JacksonUtil.toJsonNode((String)(result != null ? result.toString() : null));
    }

    private static TbMsg unbindMsg(JsonNode msgData, TbMsg msg) {
        String data = null;
        Map metadata = null;
        String messageType = null;
        if (msgData.has("msg")) {
            JsonNode msgPayload = msgData.get("msg");
            data = JacksonUtil.toString((Object)msgPayload);
        }
        if (msgData.has("metadata")) {
            JsonNode msgMetadata = msgData.get("metadata");
            metadata = (Map)JacksonUtil.convertValue((Object)msgMetadata, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        if (msgData.has("msgType")) {
            messageType = msgData.get("msgType").asText();
        }
        String newData = data != null ? data : msg.getData();
        TbMsgMetaData newMetadata = metadata != null ? new TbMsgMetaData(metadata) : msg.getMetaData().copy();
        String newMessageType = StringUtils.isNotEmpty((String)messageType) ? messageType : msg.getType();
        return msg.transform().type(newMessageType).metaData(newMetadata).data(newData).build();
    }

    private TbScriptException wrongResultType(JsonNode result) {
        return new TbScriptException(this.scriptId, TbScriptException.ErrorCode.RUNTIME, null, (Exception)new ClassCastException("Wrong result type: " + String.valueOf(result.getNodeType())));
    }
}

