/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.service.queue.processing.BatchTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.BurstTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.SequentialByOriginatorIdTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.SequentialByTenantIdTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.SequentialTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.TbRuleEngineSubmitStrategy;

@Component
public class TbRuleEngineSubmitStrategyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineSubmitStrategyFactory.class);

    public TbRuleEngineSubmitStrategy newInstance(String name, SubmitStrategy submitStrategy) {
        switch (submitStrategy.getType()) {
            case BURST: {
                return new BurstTbRuleEngineSubmitStrategy(name);
            }
            case BATCH: {
                return new BatchTbRuleEngineSubmitStrategy(name, submitStrategy.getBatchSize());
            }
            case SEQUENTIAL_BY_ORIGINATOR: {
                return new SequentialByOriginatorIdTbRuleEngineSubmitStrategy(name);
            }
            case SEQUENTIAL_BY_TENANT: {
                return new SequentialByTenantIdTbRuleEngineSubmitStrategy(name);
            }
            case SEQUENTIAL: {
                return new SequentialTbRuleEngineSubmitStrategy(name);
            }
        }
        throw new RuntimeException("TbRuleEngineProcessingStrategy with type " + String.valueOf(submitStrategy.getType()) + " is not supported!");
    }
}

