/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.service.queue.processing.TbRuleEngineProcessingDecision;
import org.thingsboard.server.service.queue.processing.TbRuleEngineProcessingResult;
import org.thingsboard.server.service.queue.processing.TbRuleEngineProcessingStrategy;

@Component
public class TbRuleEngineProcessingStrategyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineProcessingStrategyFactory.class);

    public TbRuleEngineProcessingStrategy newInstance(String name, ProcessingStrategy processingStrategy) {
        switch (processingStrategy.getType()) {
            case SKIP_ALL_FAILURES: {
                return new SkipStrategy(name, false);
            }
            case SKIP_ALL_FAILURES_AND_TIMED_OUT: {
                return new SkipStrategy(name, true);
            }
            case RETRY_ALL: {
                return new RetryStrategy(name, true, true, true, processingStrategy);
            }
            case RETRY_FAILED: {
                return new RetryStrategy(name, false, true, false, processingStrategy);
            }
            case RETRY_TIMED_OUT: {
                return new RetryStrategy(name, false, false, true, processingStrategy);
            }
            case RETRY_FAILED_AND_TIMED_OUT: {
                return new RetryStrategy(name, false, true, true, processingStrategy);
            }
        }
        throw new RuntimeException("TbRuleEngineProcessingStrategy with type " + String.valueOf(processingStrategy.getType()) + " is not supported!");
    }

    private static class SkipStrategy
    implements TbRuleEngineProcessingStrategy {
        private final String queueName;
        private final boolean skipTimeoutMsgs;

        public SkipStrategy(String name, boolean skipTimeoutMsgs) {
            this.queueName = name;
            this.skipTimeoutMsgs = skipTimeoutMsgs;
        }

        @Override
        public boolean isSkipTimeoutMsgs() {
            return this.skipTimeoutMsgs;
        }

        @Override
        public TbRuleEngineProcessingDecision analyze(TbRuleEngineProcessingResult result) {
            if (!result.isSuccess()) {
                log.debug("[{}] Reprocessing skipped for {} failed and {} timeout messages", new Object[]{this.queueName, result.getFailedMap().size(), result.getPendingMap().size()});
            }
            if (log.isTraceEnabled()) {
                result.getFailedMap().forEach((id, msg) -> log.trace("Failed messages [{}]: {}", id, (Object)ProtoUtils.fromTbMsgProto((String)result.getQueueName(), (TransportProtos.ToRuleEngineMsg)((TransportProtos.ToRuleEngineMsg)msg.getValue()), (TbMsgCallback)TbMsgCallback.EMPTY)));
            }
            if (log.isTraceEnabled()) {
                result.getPendingMap().forEach((id, msg) -> log.trace("Timeout messages [{}]: {}", id, (Object)ProtoUtils.fromTbMsgProto((String)result.getQueueName(), (TransportProtos.ToRuleEngineMsg)((TransportProtos.ToRuleEngineMsg)msg.getValue()), (TbMsgCallback)TbMsgCallback.EMPTY)));
            }
            return new TbRuleEngineProcessingDecision(true, null);
        }
    }

    private static class RetryStrategy
    implements TbRuleEngineProcessingStrategy {
        private final String queueName;
        private final boolean retrySuccessful;
        private final boolean retryFailed;
        private final boolean retryTimeout;
        private final int maxRetries;
        private final double maxAllowedFailurePercentage;
        private final long maxPauseBetweenRetries;
        private long pauseBetweenRetries;
        private int initialTotalCount;
        private int retryCount;

        public RetryStrategy(String queueName, boolean retrySuccessful, boolean retryFailed, boolean retryTimeout, ProcessingStrategy processingStrategy) {
            this.queueName = queueName;
            this.retrySuccessful = retrySuccessful;
            this.retryFailed = retryFailed;
            this.retryTimeout = retryTimeout;
            this.maxRetries = processingStrategy.getRetries();
            this.maxAllowedFailurePercentage = processingStrategy.getFailurePercentage();
            this.pauseBetweenRetries = processingStrategy.getPauseBetweenRetries();
            this.maxPauseBetweenRetries = processingStrategy.getMaxPauseBetweenRetries();
        }

        @Override
        public boolean isSkipTimeoutMsgs() {
            return true;
        }

        @Override
        public TbRuleEngineProcessingDecision analyze(TbRuleEngineProcessingResult result) {
            if (result.isSuccess()) {
                log.trace("[{}] The result of the msg pack processing is successful, going to proceed with processing of the following msgs", (Object)this.queueName);
                return new TbRuleEngineProcessingDecision(true, null);
            }
            if (this.retryCount == 0) {
                this.initialTotalCount = result.getPendingMap().size() + result.getFailedMap().size() + result.getSuccessMap().size();
            }
            ++this.retryCount;
            double failedCount = result.getFailedMap().size() + result.getPendingMap().size();
            if (this.maxRetries > 0 && this.retryCount > this.maxRetries) {
                log.debug("[{}] Skip reprocess of the rule engine pack due to max retries", (Object)this.queueName);
                return new TbRuleEngineProcessingDecision(true, null);
            }
            if (this.maxAllowedFailurePercentage > 0.0 && failedCount / (double)this.initialTotalCount > this.maxAllowedFailurePercentage) {
                log.debug("[{}] Skip reprocess of the rule engine pack due to max allowed failure percentage", (Object)this.queueName);
                return new TbRuleEngineProcessingDecision(true, null);
            }
            log.debug("[{}] The result of msg pack processing is unsuccessful, checking unprocessed msgs and going to reprocess them", (Object)this.queueName);
            ConcurrentHashMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> toReprocess = new ConcurrentHashMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.initialTotalCount);
            if (this.retryFailed) {
                result.getFailedMap().forEach(toReprocess::put);
            } else if (log.isDebugEnabled() && !result.getFailedMap().isEmpty()) {
                log.debug("[{}] Skipped {} failed messages due to the processing strategy configuration", (Object)this.queueName, (Object)result.getFailedMap().size());
            }
            if (this.retryTimeout) {
                result.getPendingMap().forEach(toReprocess::put);
            } else if (log.isDebugEnabled() && !result.getPendingMap().isEmpty()) {
                log.debug("[{}] Skipped {} timedOut messages due to the processing strategy configuration", (Object)this.queueName, (Object)result.getPendingMap().size());
            }
            if (this.retrySuccessful) {
                result.getSuccessMap().forEach(toReprocess::put);
            } else if (log.isTraceEnabled() && !result.getSuccessMap().isEmpty()) {
                log.trace("[{}] Skipped {} successful messages due to the processing strategy configuration", (Object)this.queueName, (Object)result.getSuccessMap().size());
            }
            if (CollectionUtils.isEmpty(toReprocess)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Stopping the reprocessing logic due to reprocessing map is empty", (Object)this.queueName);
                }
                return new TbRuleEngineProcessingDecision(true, null);
            }
            log.debug("[{}] Going to reprocess {} messages", (Object)this.queueName, (Object)toReprocess.size());
            if (log.isTraceEnabled()) {
                toReprocess.forEach((id, msg) -> log.trace("Going to reprocess [{}]: {}", id, (Object)ProtoUtils.fromTbMsgProto((String)result.getQueueName(), (TransportProtos.ToRuleEngineMsg)((TransportProtos.ToRuleEngineMsg)msg.getValue()), (TbMsgCallback)TbMsgCallback.EMPTY)));
            }
            if (this.pauseBetweenRetries > 0L) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.pauseBetweenRetries));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.maxPauseBetweenRetries > this.pauseBetweenRetries) {
                    this.pauseBetweenRetries = Math.min(this.maxPauseBetweenRetries, this.pauseBetweenRetries * 2L);
                }
            }
            return new TbRuleEngineProcessingDecision(false, toReprocess);
        }
    }
}

