/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;

public class EdgeConsumerStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeConsumerStats.class);
    public static final String TOTAL_MSGS = "totalMsgs";
    public static final String EDGE_NOTIFICATIONS = "edgeNfs";
    public static final String TO_CORE_NF_EDGE_EVENT = "coreNfEdgeHPUpd";
    public static final String TO_CORE_NF_EDGE_EVENT_UPDATE = "coreNfEdgeUpd";
    public static final String TO_CORE_NF_EDGE_SYNC_REQUEST = "coreNfEdgeSyncReq";
    public static final String TO_CORE_NF_EDGE_SYNC_RESPONSE = "coreNfEdgeSyncResp";
    public static final String TO_CORE_NF_EDGE_COMPONENT_LIFECYCLE = "coreNfEdgeCompLfcl";
    private final StatsCounter totalCounter;
    private final StatsCounter edgeNotificationsCounter;
    private final StatsCounter edgeHighPriorityCounter;
    private final StatsCounter edgeEventUpdateCounter;
    private final StatsCounter edgeSyncRequestCounter;
    private final StatsCounter edgeSyncResponseCounter;
    private final StatsCounter edgeComponentLifecycle;
    private final List<StatsCounter> counters = new ArrayList<StatsCounter>(7);

    public EdgeConsumerStats(StatsFactory statsFactory) {
        String statsKey = StatsType.EDGE.getName();
        this.totalCounter = this.register(statsFactory.createStatsCounter(statsKey, TOTAL_MSGS, new String[0]));
        this.edgeNotificationsCounter = this.register(statsFactory.createStatsCounter(statsKey, EDGE_NOTIFICATIONS, new String[0]));
        this.edgeHighPriorityCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_EDGE_EVENT, new String[0]));
        this.edgeEventUpdateCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_EDGE_EVENT_UPDATE, new String[0]));
        this.edgeSyncRequestCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_EDGE_SYNC_REQUEST, new String[0]));
        this.edgeSyncResponseCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_EDGE_SYNC_RESPONSE, new String[0]));
        this.edgeComponentLifecycle = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_EDGE_COMPONENT_LIFECYCLE, new String[0]));
    }

    private StatsCounter register(StatsCounter counter) {
        this.counters.add(counter);
        return counter;
    }

    public void log(TransportProtos.ToEdgeNotificationMsg msg) {
        this.totalCounter.increment();
        if (msg.hasEdgeHighPriority()) {
            this.edgeHighPriorityCounter.increment();
        } else if (msg.hasEdgeEventUpdate()) {
            this.edgeEventUpdateCounter.increment();
        } else if (msg.hasToEdgeSyncRequest()) {
            this.edgeSyncRequestCounter.increment();
        } else if (msg.hasFromEdgeSyncResponse()) {
            this.edgeSyncResponseCounter.increment();
        } else if (msg.hasComponentLifecycle()) {
            this.edgeComponentLifecycle.increment();
        }
    }

    public void log(TransportProtos.ToEdgeMsg msg) {
        this.totalCounter.increment();
        this.edgeNotificationsCounter.increment();
    }

    public void printStats() {
        int total = this.totalCounter.get();
        if (total > 0) {
            StringBuilder stats = new StringBuilder();
            this.counters.forEach(counter -> stats.append(counter.getName()).append(" = [").append(counter.get()).append("] "));
            log.info("Edge Stats: {}", (Object)stats);
        }
    }

    public void reset() {
        this.counters.forEach(DefaultCounter::clear);
    }
}

