/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.ResourcesShortageNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.ResourcesShortageTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.notification.rule.trigger.config.ResourcesShortageNotificationRuleTriggerConfig;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class ResourcesShortageTriggerProcessor
implements NotificationRuleTriggerProcessor<ResourcesShortageTrigger, ResourcesShortageNotificationRuleTriggerConfig> {
    @Override
    public boolean matchesFilter(ResourcesShortageTrigger trigger, ResourcesShortageNotificationRuleTriggerConfig triggerConfig) {
        float usagePercent = (float)trigger.getUsage().longValue() / 100.0f;
        return switch (trigger.getResource()) {
            default -> throw new IncompatibleClassChangeError();
            case ResourcesShortageTrigger.Resource.CPU -> {
                if (usagePercent >= triggerConfig.getCpuThreshold()) {
                    yield true;
                }
                yield false;
            }
            case ResourcesShortageTrigger.Resource.RAM -> {
                if (usagePercent >= triggerConfig.getRamThreshold()) {
                    yield true;
                }
                yield false;
            }
            case ResourcesShortageTrigger.Resource.STORAGE -> usagePercent >= triggerConfig.getStorageThreshold();
        };
    }

    @Override
    public RuleOriginatedNotificationInfo constructNotificationInfo(ResourcesShortageTrigger trigger) {
        return ResourcesShortageNotificationInfo.builder().resource(trigger.getResource().name()).usage(trigger.getUsage()).serviceId(trigger.getServiceId()).serviceType(trigger.getServiceType()).build();
    }

    @Override
    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.RESOURCES_SHORTAGE;
    }

    @Generated
    public ResourcesShortageTriggerProcessor() {
    }
}

