/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.EntitiesLimitNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.EntitiesLimitTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EntitiesLimitNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.dao.entity.EntityCountService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class EntitiesLimitTriggerProcessor
implements NotificationRuleTriggerProcessor<EntitiesLimitTrigger, EntitiesLimitNotificationRuleTriggerConfig> {
    private final EntityCountService entityCountService;
    private final TbTenantProfileCache tenantProfileCache;
    private final TenantService tenantService;

    @Override
    public boolean matchesFilter(EntitiesLimitTrigger trigger, EntitiesLimitNotificationRuleTriggerConfig triggerConfig) {
        if (CollectionUtils.isNotEmpty((Collection)triggerConfig.getEntityTypes()) && !triggerConfig.getEntityTypes().contains(trigger.getEntityType())) {
            return false;
        }
        DefaultTenantProfileConfiguration profileConfiguration = this.tenantProfileCache.get(trigger.getTenantId()).getDefaultProfileConfiguration();
        long limit = profileConfiguration.getEntitiesLimit(trigger.getEntityType());
        if (limit <= 0L) {
            return false;
        }
        long currentCount = this.entityCountService.countByTenantIdAndEntityType(trigger.getTenantId(), trigger.getEntityType());
        if (currentCount == 0L) {
            return false;
        }
        trigger.setLimit(limit);
        trigger.setCurrentCount(currentCount);
        return (long)((int)((float)limit * triggerConfig.getThreshold())) == currentCount;
    }

    @Override
    public RuleOriginatedNotificationInfo constructNotificationInfo(EntitiesLimitTrigger trigger) {
        return EntitiesLimitNotificationInfo.builder().entityType(trigger.getEntityType()).currentCount(trigger.getCurrentCount()).limit(trigger.getLimit()).percents((int)((float)trigger.getCurrentCount() / (float)trigger.getLimit() * 100.0f)).tenantId(trigger.getTenantId()).tenantName(this.tenantService.findTenantById(trigger.getTenantId()).getName()).build();
    }

    @Override
    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ENTITIES_LIMIT;
    }

    @ConstructorProperties(value={"entityCountService", "tenantProfileCache", "tenantService"})
    @Generated
    public EntitiesLimitTriggerProcessor(EntityCountService entityCountService, TbTenantProfileCache tenantProfileCache, TenantService tenantService) {
        this.entityCountService = entityCountService;
        this.tenantProfileCache = tenantProfileCache;
        this.tenantService = tenantService;
    }
}

