/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmStatusFilter;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.notification.info.AlarmCommentNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmCommentTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.AlarmCommentNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class AlarmCommentTriggerProcessor
implements NotificationRuleTriggerProcessor<AlarmCommentTrigger, AlarmCommentNotificationRuleTriggerConfig> {
    private final EntityService entityService;

    @Override
    public boolean matchesFilter(AlarmCommentTrigger trigger, AlarmCommentNotificationRuleTriggerConfig triggerConfig) {
        if (trigger.getActionType() == ActionType.UPDATED_COMMENT && !triggerConfig.isNotifyOnCommentUpdate()) {
            return false;
        }
        if (triggerConfig.isOnlyUserComments() && trigger.getComment().getType() == AlarmCommentType.SYSTEM) {
            return false;
        }
        Alarm alarm = trigger.getAlarm();
        return CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmTypes(), (Object)alarm.getType()) && CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmSeverities(), (Object)alarm.getSeverity()) && (CollectionUtils.isEmpty((Collection)triggerConfig.getAlarmStatuses()) || AlarmStatusFilter.from((Collection)triggerConfig.getAlarmStatuses()).matches(alarm));
    }

    @Override
    public RuleOriginatedNotificationInfo constructNotificationInfo(AlarmCommentTrigger trigger) {
        Alarm alarm = trigger.getAlarm();
        String originatorName = alarm instanceof AlarmInfo ? ((AlarmInfo)alarm).getOriginatorName() : this.entityService.fetchEntityName(trigger.getTenantId(), alarm.getOriginator()).orElse("");
        return AlarmCommentNotificationInfo.builder().comment(trigger.getComment().getComment().get("text").asText()).action(trigger.getActionType() == ActionType.ADDED_COMMENT ? "added" : "updated").userEmail(trigger.getUser().getEmail()).userFirstName(trigger.getUser().getFirstName()).userLastName(trigger.getUser().getLastName()).alarmId(alarm.getUuidId()).alarmType(alarm.getType()).alarmOriginator(alarm.getOriginator()).alarmOriginatorName(originatorName).alarmSeverity(alarm.getSeverity()).alarmStatus(alarm.getStatus()).alarmCustomerId(alarm.getCustomerId()).dashboardId(alarm.getDashboardId()).build();
    }

    @Override
    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ALARM_COMMENT;
    }

    @ConstructorProperties(value={"entityService"})
    @Generated
    public AlarmCommentTriggerProcessor(EntityService entityService) {
        this.entityService = entityService;
    }
}

