/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStatus;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.notification.NotificationDeduplicationService;
import org.thingsboard.server.service.executors.NotificationExecutorService;
import org.thingsboard.server.service.notification.rule.cache.NotificationRulesCache;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class DefaultNotificationRuleProcessor
implements NotificationRuleProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationRuleProcessor.class);
    private final NotificationRulesCache notificationRulesCache;
    private final NotificationRequestService notificationRequestService;
    private final NotificationDeduplicationService deduplicationService;
    private final PartitionService partitionService;
    private final RateLimitService rateLimitService;
    @Lazy
    private final NotificationCenter notificationCenter;
    private final NotificationExecutorService notificationExecutor;
    private final Map<NotificationRuleTriggerType, NotificationRuleTriggerProcessor> triggerProcessors = new EnumMap<NotificationRuleTriggerType, NotificationRuleTriggerProcessor>(NotificationRuleTriggerType.class);

    public void process(NotificationRuleTrigger trigger) {
        NotificationRuleTriggerType triggerType = trigger.getType();
        TenantId tenantId = triggerType.isTenantLevel() ? trigger.getTenantId() : TenantId.SYS_TENANT_ID;
        this.notificationExecutor.submit(() -> {
            try {
                List<NotificationRule> enabledRules = this.notificationRulesCache.getEnabled(tenantId, triggerType);
                if (enabledRules.isEmpty()) {
                    return;
                }
                List<NotificationRule> rulesToProcess = this.filterNotificationRules(trigger, enabledRules);
                for (NotificationRule rule : rulesToProcess) {
                    try {
                        this.processNotificationRule(rule, trigger, NotificationRuleTrigger.DeduplicationStrategy.ONLY_MATCHING.equals((Object)trigger.getDeduplicationStrategy()));
                    }
                    catch (Throwable e) {
                        log.error("Failed to process notification rule {} for trigger type {} with trigger object {}", new Object[]{rule.getId(), rule.getTriggerType(), trigger, e});
                    }
                }
            }
            catch (Throwable e) {
                log.error("Failed to process notification rules for trigger: {}", (Object)trigger, (Object)e);
            }
        });
    }

    private List<NotificationRule> filterNotificationRules(NotificationRuleTrigger trigger, List<NotificationRule> enabledRules) {
        ArrayList<NotificationRule> rulesToProcess = new ArrayList<NotificationRule>(enabledRules);
        rulesToProcess.removeIf(rule -> switch (trigger.getDeduplicationStrategy()) {
            case NotificationRuleTrigger.DeduplicationStrategy.ONLY_MATCHING -> {
                boolean matched = this.matchesFilter(trigger, rule.getTriggerConfig());
                if (!matched || this.deduplicationService.alreadyProcessed(trigger, rule)) {
                    yield true;
                }
                yield false;
            }
            case NotificationRuleTrigger.DeduplicationStrategy.ALL -> this.deduplicationService.alreadyProcessed(trigger, rule);
            default -> false;
        });
        return rulesToProcess;
    }

    private void processNotificationRule(NotificationRule rule, NotificationRuleTrigger trigger, boolean alreadyMatched) {
        NotificationRuleTriggerConfig triggerConfig = rule.getTriggerConfig();
        log.debug("Processing notification rule '{}' for trigger type {}", (Object)rule.getName(), (Object)rule.getTriggerType());
        if (this.matchesClearRule(trigger, triggerConfig)) {
            List scheduledRequests = this.notificationRequestService.findNotificationRequestsByRuleIdAndOriginatorEntityIdAndStatus(rule.getTenantId(), (NotificationRuleId)rule.getId(), trigger.getOriginatorEntityId(), NotificationRequestStatus.SCHEDULED);
            scheduledRequests.forEach(notificationRequest -> this.notificationCenter.deleteNotificationRequest(rule.getTenantId(), (NotificationRequestId)notificationRequest.getId()));
            return;
        }
        if (alreadyMatched || this.matchesFilter(trigger, triggerConfig)) {
            if (!this.rateLimitService.checkRateLimit(LimitedApi.NOTIFICATION_REQUESTS_PER_RULE, rule.getTenantId(), (Object)rule.getId())) {
                log.debug("[{}] Rate limit for notification requests per rule was exceeded (rule '{}')", (Object)rule.getTenantId(), (Object)rule.getName());
                return;
            }
            NotificationInfo notificationInfo = this.constructNotificationInfo(trigger, triggerConfig);
            rule.getRecipientsConfig().getTargetsTable().forEach((delay, targets) -> this.submitNotificationRequest((List<UUID>)targets, rule, trigger.getOriginatorEntityId(), notificationInfo, (int)delay));
        }
    }

    private void submitNotificationRequest(List<UUID> targets, NotificationRule rule, EntityId originatorEntityId, NotificationInfo notificationInfo, int delayInSec) {
        NotificationRequestConfig config = new NotificationRequestConfig();
        if (delayInSec > 0) {
            config.setSendingDelayInSec(delayInSec);
        }
        NotificationRequest notificationRequest = NotificationRequest.builder().tenantId(rule.getTenantId()).targets(targets).templateId(rule.getTemplateId()).additionalConfig(config).info(notificationInfo).ruleId((NotificationRuleId)rule.getId()).originatorEntityId(originatorEntityId).build();
        try {
            log.debug("Submitting notification request for rule '{}' with delay of {} sec to targets {}", new Object[]{rule.getName(), delayInSec, targets});
            this.notificationCenter.processNotificationRequest(rule.getTenantId(), notificationRequest, null);
        }
        catch (Exception e) {
            log.error("Failed to process notification request for tenant {} for rule {}", new Object[]{rule.getTenantId(), rule.getId(), e});
        }
    }

    private boolean matchesFilter(NotificationRuleTrigger trigger, NotificationRuleTriggerConfig triggerConfig) {
        return this.triggerProcessors.get(triggerConfig.getTriggerType()).matchesFilter(trigger, triggerConfig);
    }

    private boolean matchesClearRule(NotificationRuleTrigger trigger, NotificationRuleTriggerConfig triggerConfig) {
        return this.triggerProcessors.get(triggerConfig.getTriggerType()).matchesClearRule(trigger, triggerConfig);
    }

    private NotificationInfo constructNotificationInfo(NotificationRuleTrigger trigger, NotificationRuleTriggerConfig triggerConfig) {
        return this.triggerProcessors.get(triggerConfig.getTriggerType()).constructNotificationInfo(trigger);
    }

    @EventListener(value={ComponentLifecycleMsg.class})
    public void onNotificationRuleDeleted(ComponentLifecycleMsg componentLifecycleMsg) {
        NotificationRuleId notificationRuleId;
        if (componentLifecycleMsg.getEvent() != ComponentLifecycleEvent.DELETED || componentLifecycleMsg.getEntityId().getEntityType() != EntityType.NOTIFICATION_RULE) {
            return;
        }
        TenantId tenantId = componentLifecycleMsg.getTenantId();
        if (this.partitionService.isMyPartition(ServiceType.TB_CORE, tenantId, (EntityId)(notificationRuleId = (NotificationRuleId)componentLifecycleMsg.getEntityId()))) {
            this.notificationExecutor.submit(() -> {
                List scheduledForRule = this.notificationRequestService.findNotificationRequestsIdsByStatusAndRuleId(tenantId, NotificationRequestStatus.SCHEDULED, notificationRuleId);
                for (NotificationRequestId notificationRequestId : scheduledForRule) {
                    this.notificationCenter.deleteNotificationRequest(tenantId, notificationRequestId);
                }
            });
        }
    }

    @Autowired
    public void setTriggerProcessors(Collection<NotificationRuleTriggerProcessor> processors) {
        processors.forEach(processor -> this.triggerProcessors.put(processor.getTriggerType(), (NotificationRuleTriggerProcessor)processor));
    }

    @ConstructorProperties(value={"notificationRulesCache", "notificationRequestService", "deduplicationService", "partitionService", "rateLimitService", "notificationCenter", "notificationExecutor"})
    @Generated
    public DefaultNotificationRuleProcessor(NotificationRulesCache notificationRulesCache, NotificationRequestService notificationRequestService, NotificationDeduplicationService deduplicationService, PartitionService partitionService, RateLimitService rateLimitService, @Lazy NotificationCenter notificationCenter, NotificationExecutorService notificationExecutor) {
        this.notificationRulesCache = notificationRulesCache;
        this.notificationRequestService = notificationRequestService;
        this.deduplicationService = deduplicationService;
        this.partitionService = partitionService;
        this.rateLimitService = rateLimitService;
        this.notificationCenter = notificationCenter;
        this.notificationExecutor = notificationExecutor;
    }
}

