/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.provider;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.notification.FirebaseService;
import org.thingsboard.server.common.data.id.TenantId;

@Service
public class DefaultFirebaseService
implements FirebaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFirebaseService.class);
    private final Cache<String, FirebaseContext> contexts = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener((key, context, cause) -> {
        if (cause == RemovalCause.EXPIRED && context != null) {
            context.destroy();
        }
    }).build();

    public void sendMessage(TenantId tenantId, String credentials, String fcmToken, String title, String body, Map<String, String> data, Integer badge) throws FirebaseMessagingException {
        FirebaseContext firebaseContext = this.contexts.asMap().compute(tenantId.toString(), (key, context) -> {
            if (context == null) {
                return new FirebaseContext((String)key, credentials);
            }
            context.check(credentials);
            return context;
        });
        Aps.Builder apsConfig = Aps.builder().setSound("default");
        if (badge != null) {
            apsConfig.setBadge(badge.intValue());
        }
        Message message = Message.builder().setToken(fcmToken).setNotification(Notification.builder().setTitle(title).setBody(body).build()).setAndroidConfig(AndroidConfig.builder().setPriority(AndroidConfig.Priority.HIGH).build()).setApnsConfig(ApnsConfig.builder().setAps(apsConfig.build()).build()).putAllData(data).build();
        try {
            firebaseContext.getMessaging().send(message);
            log.trace("[{}] Sent message for FCM token {}", (Object)tenantId, (Object)fcmToken);
        }
        catch (Throwable t) {
            log.debug("[{}] Failed to send message for FCM token {}", new Object[]{tenantId, fcmToken, t});
            throw t;
        }
    }

    public static class FirebaseContext {
        private final String key;
        private String credentials;
        private FirebaseApp app;
        private FirebaseMessaging messaging;

        public FirebaseContext(String key, String credentials) {
            this.key = key;
            this.credentials = credentials;
            this.init();
        }

        private void init() {
            FirebaseOptions options;
            try {
                options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)IOUtils.toInputStream((String)this.credentials, (Charset)StandardCharsets.UTF_8))).build();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process service account credentials: " + e.getMessage(), e);
            }
            try {
                this.app = FirebaseApp.initializeApp((FirebaseOptions)options, (String)this.key);
            }
            catch (IllegalStateException alreadyExists) {
                this.app = FirebaseApp.getInstance((String)this.key);
            }
            try {
                this.messaging = FirebaseMessaging.getInstance((FirebaseApp)this.app);
            }
            catch (IllegalStateException alreadyExists) {
                this.messaging = FirebaseMessaging.getInstance((FirebaseApp)this.app);
            }
            log.debug("[{}] Initialized new FirebaseContext", (Object)this.key);
        }

        public void check(String credentials) {
            if (!this.credentials.equals(credentials)) {
                this.destroy();
                this.credentials = credentials;
                this.init();
            } else if (this.app == null || this.messaging == null) {
                throw new IllegalStateException("Firebase app couldn't be initialized");
            }
        }

        public void destroy() {
            if (this.app != null) {
                this.app.delete();
                this.app = null;
            }
            this.messaging = null;
            log.debug("[{}] Destroyed FirebaseContext", (Object)this.key);
        }

        @Generated
        public FirebaseMessaging getMessaging() {
            return this.messaging;
        }
    }
}

