/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification;

import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationRequestStatus;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.executors.NotificationExecutorService;
import org.thingsboard.server.service.notification.NotificationSchedulerService;
import org.thingsboard.server.service.partition.AbstractPartitionBasedService;

@TbCoreComponent
@Service
public class DefaultNotificationSchedulerService
extends AbstractPartitionBasedService<NotificationRequestId>
implements NotificationSchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationSchedulerService.class);
    private final NotificationCenter notificationCenter;
    private final NotificationRequestService notificationRequestService;
    private final NotificationExecutorService notificationExecutor;
    private final ScheduledExecutorService scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"notification-scheduler");
    private final Map<NotificationRequestId, ScheduledRequestMetadata> scheduledNotificationRequests = new ConcurrentHashMap<NotificationRequestId, ScheduledRequestMetadata>();

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    protected Map<TopicPartitionInfo, List<ListenableFuture<?>>> onAddedPartitions(Set<TopicPartitionInfo> addedPartitions) {
        PageDataIterable notificationRequests = new PageDataIterable(arg_0 -> ((NotificationRequestService)this.notificationRequestService).findScheduledNotificationRequests(arg_0), 1000);
        for (NotificationRequest notificationRequest : notificationRequests) {
            TopicPartitionInfo requestPartition = this.partitionService.resolve(ServiceType.TB_CORE, notificationRequest.getTenantId(), (EntityId)notificationRequest.getId());
            if (!addedPartitions.contains(requestPartition)) continue;
            this.partitionedEntities.computeIfAbsent(requestPartition, k -> ConcurrentHashMap.newKeySet()).add((NotificationRequestId)notificationRequest.getId());
            if (this.scheduledNotificationRequests.containsKey(notificationRequest.getId())) continue;
            this.scheduleNotificationRequest(notificationRequest.getTenantId(), notificationRequest, notificationRequest.getCreatedTime());
        }
        return Collections.emptyMap();
    }

    @Override
    public void scheduleNotificationRequest(TenantId tenantId, NotificationRequestId notificationRequestId, long requestTs) {
        NotificationRequest notificationRequest = this.notificationRequestService.findNotificationRequestById(tenantId, notificationRequestId);
        this.scheduleNotificationRequest(tenantId, notificationRequest, requestTs);
    }

    private void scheduleNotificationRequest(TenantId tenantId, NotificationRequest request, long requestTs) {
        int delayInSec = Optional.ofNullable(request).map(NotificationRequest::getAdditionalConfig).map(NotificationRequestConfig::getSendingDelayInSec).orElse(0);
        if (delayInSec <= 0) {
            return;
        }
        long delayInMs = TimeUnit.SECONDS.toMillis(delayInSec) - (System.currentTimeMillis() - requestTs);
        if (delayInMs < 0L) {
            delayInMs = 0L;
        }
        ScheduledFuture<?> scheduledTask = this.scheduler.schedule(() -> {
            NotificationRequest notificationRequest = this.notificationRequestService.findNotificationRequestById(tenantId, (NotificationRequestId)request.getId());
            if (notificationRequest == null) {
                return;
            }
            this.notificationExecutor.executeAsync(() -> {
                try {
                    this.notificationCenter.processNotificationRequest(tenantId, notificationRequest, null);
                }
                catch (Exception e) {
                    log.error("Failed to process scheduled notification request {}", (Object)notificationRequest.getId(), (Object)e);
                    NotificationRequestStats stats = new NotificationRequestStats();
                    stats.setError(e.getMessage());
                    this.notificationRequestService.updateNotificationRequest(tenantId, (NotificationRequestId)request.getId(), NotificationRequestStatus.SENT, stats);
                }
            });
            this.scheduledNotificationRequests.remove(notificationRequest.getId());
        }, delayInMs, TimeUnit.MILLISECONDS);
        this.scheduledNotificationRequests.put((NotificationRequestId)request.getId(), new ScheduledRequestMetadata(tenantId, scheduledTask));
    }

    @EventListener(value={ComponentLifecycleMsg.class})
    public void handleComponentLifecycleEvent(ComponentLifecycleMsg event) {
        if (event.getEvent() == ComponentLifecycleEvent.DELETED) {
            EntityId entityId = event.getEntityId();
            switch (entityId.getEntityType()) {
                case NOTIFICATION_REQUEST: {
                    this.cancelAndRemove((NotificationRequestId)entityId);
                    break;
                }
                case TENANT: {
                    HashSet toCancel = new HashSet();
                    this.scheduledNotificationRequests.forEach((notificationRequestId, scheduledRequestMetadata) -> {
                        if (scheduledRequestMetadata.getTenantId().equals((Object)entityId)) {
                            toCancel.add(notificationRequestId);
                        }
                    });
                    toCancel.forEach(this::cancelAndRemove);
                }
            }
        }
    }

    @Override
    protected void cleanupEntityOnPartitionRemoval(NotificationRequestId notificationRequestId) {
        this.cancelAndRemove(notificationRequestId);
    }

    private void cancelAndRemove(NotificationRequestId notificationRequestId) {
        ScheduledRequestMetadata md = this.scheduledNotificationRequests.remove(notificationRequestId);
        if (md != null) {
            md.getFuture().cancel(false);
        }
    }

    @Override
    protected String getServiceName() {
        return "Notifications scheduler";
    }

    @Override
    protected String getSchedulerExecutorName() {
        return "notifications-scheduler";
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
        this.scheduler.shutdownNow();
    }

    @ConstructorProperties(value={"notificationCenter", "notificationRequestService", "notificationExecutor"})
    @Generated
    public DefaultNotificationSchedulerService(NotificationCenter notificationCenter, NotificationRequestService notificationRequestService, NotificationExecutorService notificationExecutor) {
        this.notificationCenter = notificationCenter;
        this.notificationRequestService = notificationRequestService;
        this.notificationExecutor = notificationExecutor;
    }

    private static class ScheduledRequestMetadata {
        private final TenantId tenantId;
        private final ScheduledFuture<?> future;

        @ConstructorProperties(value={"tenantId", "future"})
        @Generated
        public ScheduledRequestMetadata(TenantId tenantId, ScheduledFuture<?> future) {
            this.tenantId = tenantId;
            this.future = future;
        }

        @Generated
        public TenantId getTenantId() {
            return this.tenantId;
        }

        @Generated
        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScheduledRequestMetadata)) {
                return false;
            }
            ScheduledRequestMetadata other = (ScheduledRequestMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TenantId this$tenantId = this.getTenantId();
            TenantId other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            ScheduledFuture<?> this$future = this.getFuture();
            ScheduledFuture<?> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScheduledRequestMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TenantId $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            ScheduledFuture<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultNotificationSchedulerService.ScheduledRequestMetadata(tenantId=" + String.valueOf(this.getTenantId()) + ", future=" + String.valueOf(this.getFuture()) + ")";
        }
    }
}

