/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import freemarker.template.Configuration;
import freemarker.template.Template;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.mail.internet.MimeMessage;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageRecordState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.RateLimitExceededException;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.mail.MailSenderInternalExecutorService;
import org.thingsboard.server.service.mail.PasswordResetExecutorService;
import org.thingsboard.server.service.mail.TbMailContextComponent;
import org.thingsboard.server.service.mail.TbMailSender;

@Service
public class DefaultMailService
implements MailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMailService.class);
    private static final String TARGET_EMAIL = "targetEmail";
    private static final String UTF_8 = "UTF-8";
    private static final long DEFAULT_TIMEOUT = 10000L;
    private final ScheduledExecutorService timeoutScheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"mail-service-watchdog");
    private final MessageSource messages;
    private final Configuration freemarkerConfig;
    private final AdminSettingsService adminSettingsService;
    private final TbApiUsageReportClient apiUsageClient;
    @Lazy
    private final TbApiUsageStateService apiUsageStateService;
    private final MailSenderInternalExecutorService mailExecutorService;
    private final PasswordResetExecutorService passwordResetExecutorService;
    private final TbMailContextComponent ctx;
    private final RateLimitService rateLimitService;
    @Value(value="${mail.per_tenant_rate_limits:}")
    private String perTenantRateLimitConfig;
    private TbMailSender mailSender;
    private String mailFrom;
    private long timeout;

    @PostConstruct
    private void init() {
        this.updateMailConfiguration();
    }

    @PreDestroy
    public void destroy() {
        this.timeoutScheduler.shutdownNow();
    }

    public void updateMailConfiguration() {
        AdminSettings settings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "mail");
        if (settings == null) {
            throw new IncorrectParameterException("Failed to update mail configuration. Settings not found!");
        }
        JsonNode jsonConfig = settings.getJsonValue();
        this.mailSender = new TbMailSender(this.ctx, jsonConfig);
        this.mailFrom = jsonConfig.get("mailFrom").asText();
        this.timeout = jsonConfig.get("timeout").asLong(10000L);
    }

    public void sendEmail(TenantId tenantId, String email, String subject, String message) throws ThingsboardException {
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendTestMail(JsonNode jsonConfig, String email) throws ThingsboardException {
        TbMailSender testMailSender = new TbMailSender(this.ctx, jsonConfig);
        String mailFrom = jsonConfig.get("mailFrom").asText();
        String subject = this.messages.getMessage("test.message.subject", null, Locale.US);
        long timeout = jsonConfig.get("timeout").asLong(10000L);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("test.ftl", model);
        this.sendMail(testMailSender, mailFrom, email, subject, message, timeout);
    }

    public void sendActivationEmail(String activationLink, long ttlMs, String email) throws ThingsboardException {
        String subject = this.messages.getMessage("activation.subject", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("activationLink", activationLink);
        model.put("activationLinkTtlInHours", (int)Math.ceil((double)ttlMs / 3600000.0));
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("activation.ftl", model);
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendAccountActivatedEmail(String loginLink, String email) throws ThingsboardException {
        String subject = this.messages.getMessage("account.activated.subject", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("loginLink", loginLink);
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("account.activated.ftl", model);
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendResetPasswordEmail(String passwordResetLink, long ttlMs, String email) throws ThingsboardException {
        String subject = this.messages.getMessage("reset.password.subject", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("passwordResetLink", passwordResetLink);
        model.put("passwordResetLinkTtlInHours", (int)Math.ceil((double)ttlMs / 3600000.0));
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("reset.password.ftl", model);
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendResetPasswordEmailAsync(String passwordResetLink, long ttlMs, String email) {
        this.passwordResetExecutorService.execute(() -> {
            try {
                this.sendResetPasswordEmail(passwordResetLink, ttlMs, email);
            }
            catch (Exception e) {
                log.error("Error occurred: {} ", (Object)e.getMessage());
            }
        });
    }

    public void sendPasswordWasResetEmail(String loginLink, String email) throws ThingsboardException {
        String subject = this.messages.getMessage("password.was.reset.subject", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("loginLink", loginLink);
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("password.was.reset.ftl", model);
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void send(TenantId tenantId, CustomerId customerId, TbEmail tbEmail) throws ThingsboardException {
        this.sendMail(tenantId, customerId, tbEmail, (JavaMailSender)this.mailSender, this.timeout);
    }

    public void send(TenantId tenantId, CustomerId customerId, TbEmail tbEmail, JavaMailSender javaMailSender, long timeout) throws ThingsboardException {
        this.sendMail(tenantId, customerId, tbEmail, javaMailSender, timeout);
    }

    private void sendMail(TenantId tenantId, CustomerId customerId, TbEmail tbEmail, JavaMailSender javaMailSender, long timeout) throws ThingsboardException {
        if (this.apiUsageStateService.getApiUsageState(tenantId).isEmailSendEnabled()) {
            if (tenantId != null && !tenantId.isSysTenantId() && StringUtils.isNotEmpty((String)this.perTenantRateLimitConfig) && !this.rateLimitService.checkRateLimit(LimitedApi.EMAILS, (Object)tenantId, this.perTenantRateLimitConfig)) {
                throw new RateLimitExceededException(LimitedApi.EMAILS);
            }
            try {
                MimeMessage mailMsg = javaMailSender.createMimeMessage();
                boolean multipart = tbEmail.getImages() != null && !tbEmail.getImages().isEmpty();
                MimeMessageHelper helper = new MimeMessageHelper(mailMsg, multipart, UTF_8);
                helper.setFrom(StringUtils.isBlank((String)tbEmail.getFrom()) ? this.mailFrom : tbEmail.getFrom());
                helper.setTo(tbEmail.getTo().split("\\s*,\\s*"));
                if (!StringUtils.isBlank((String)tbEmail.getCc())) {
                    helper.setCc(tbEmail.getCc().split("\\s*,\\s*"));
                }
                if (!StringUtils.isBlank((String)tbEmail.getBcc())) {
                    helper.setBcc(tbEmail.getBcc().split("\\s*,\\s*"));
                }
                helper.setSubject(tbEmail.getSubject());
                helper.setText(tbEmail.getBody(), tbEmail.isHtml());
                if (multipart) {
                    for (String imgId : tbEmail.getImages().keySet()) {
                        String imgValue = (String)tbEmail.getImages().get(imgId);
                        String value = imgValue.replaceFirst("^data:image/[^;]*;base64,?", "");
                        byte[] bytes = DatatypeConverter.parseBase64Binary((String)value);
                        String contentType = helper.getFileTypeMap().getContentType(imgId);
                        InputStreamSource iss = () -> new ByteArrayInputStream(bytes);
                        helper.addInline(imgId, iss, contentType);
                    }
                }
                this.sendMailWithTimeout(javaMailSender, helper.getMimeMessage(), timeout);
                this.apiUsageClient.report(tenantId, customerId, ApiUsageRecordKey.EMAIL_EXEC_COUNT, 1L);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        } else {
            throw new RuntimeException("Email sending is disabled due to API limits!");
        }
    }

    public void sendAccountLockoutEmail(String lockoutEmail, String email, Integer maxFailedLoginAttempts) throws ThingsboardException {
        String subject = this.messages.getMessage("account.lockout.subject", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("lockoutAccount", lockoutEmail);
        model.put("maxFailedLoginAttempts", maxFailedLoginAttempts);
        model.put(TARGET_EMAIL, email);
        String message = this.mergeTemplateIntoString("account.lockout.ftl", model);
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendTwoFaVerificationEmail(String email, String verificationCode, int expirationTimeSeconds) throws ThingsboardException {
        String subject = this.messages.getMessage("2fa.verification.code.subject", null, Locale.US);
        String message = this.mergeTemplateIntoString("2fa.verification.code.ftl", Map.of(TARGET_EMAIL, email, "code", verificationCode, "expirationTimeSeconds", expirationTimeSeconds));
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void sendApiFeatureStateEmail(ApiFeature apiFeature, ApiUsageStateValue stateValue, String email, ApiUsageRecordState recordState) throws ThingsboardException {
        String subject = this.messages.getMessage("api.usage.state", null, Locale.US);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("apiFeature", apiFeature.getLabel());
        model.put(TARGET_EMAIL, email);
        String message = switch (stateValue) {
            default -> throw new IncompatibleClassChangeError();
            case ApiUsageStateValue.ENABLED -> {
                model.put("apiLabel", this.toEnabledValueLabel(apiFeature));
                yield this.mergeTemplateIntoString("state.enabled.ftl", model);
            }
            case ApiUsageStateValue.WARNING -> {
                model.put("apiValueLabel", this.toDisabledValueLabel(apiFeature) + " " + this.toWarningValueLabel(recordState));
                yield this.mergeTemplateIntoString("state.warning.ftl", model);
            }
            case ApiUsageStateValue.DISABLED -> {
                model.put("apiLimitValueLabel", this.toDisabledValueLabel(apiFeature) + " " + this.toDisabledValueLabel(recordState));
                yield this.mergeTemplateIntoString("state.disabled.ftl", model);
            }
        };
        this.sendMail(this.mailSender, this.mailFrom, email, subject, message, this.timeout);
    }

    public void testConnection(TenantId tenantId) throws Exception {
        this.mailSender.testConnection();
    }

    public boolean isConfigured(TenantId tenantId) {
        return this.mailSender != null;
    }

    private String toEnabledValueLabel(ApiFeature apiFeature) {
        return switch (apiFeature) {
            case ApiFeature.DB -> "save";
            case ApiFeature.TRANSPORT -> "receive";
            case ApiFeature.JS -> "invoke";
            case ApiFeature.RE -> "process";
            case ApiFeature.EMAIL, ApiFeature.SMS -> "send";
            case ApiFeature.ALARM -> "create";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toDisabledValueLabel(ApiFeature apiFeature) {
        return switch (apiFeature) {
            case ApiFeature.DB -> "saved";
            case ApiFeature.TRANSPORT -> "received";
            case ApiFeature.JS -> "invoked";
            case ApiFeature.RE -> "processed";
            case ApiFeature.EMAIL, ApiFeature.SMS -> "sent";
            case ApiFeature.ALARM -> "created";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toWarningValueLabel(ApiUsageRecordState recordState) {
        String valueInM = recordState.getValueAsString();
        String thresholdInM = recordState.getThresholdAsString();
        return switch (recordState.getKey()) {
            case ApiUsageRecordKey.STORAGE_DP_COUNT, ApiUsageRecordKey.TRANSPORT_DP_COUNT -> valueInM + " out of " + thresholdInM + " allowed data points";
            case ApiUsageRecordKey.TRANSPORT_MSG_COUNT -> valueInM + " out of " + thresholdInM + " allowed messages";
            case ApiUsageRecordKey.JS_EXEC_COUNT -> valueInM + " out of " + thresholdInM + " allowed JavaScript functions";
            case ApiUsageRecordKey.TBEL_EXEC_COUNT -> valueInM + " out of " + thresholdInM + " allowed Tbel functions";
            case ApiUsageRecordKey.RE_EXEC_COUNT -> valueInM + " out of " + thresholdInM + " allowed Rule Engine messages";
            case ApiUsageRecordKey.EMAIL_EXEC_COUNT -> valueInM + " out of " + thresholdInM + " allowed Email messages";
            case ApiUsageRecordKey.SMS_EXEC_COUNT -> valueInM + " out of " + thresholdInM + " allowed SMS messages";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toDisabledValueLabel(ApiUsageRecordState recordState) {
        return switch (recordState.getKey()) {
            case ApiUsageRecordKey.STORAGE_DP_COUNT, ApiUsageRecordKey.TRANSPORT_DP_COUNT -> recordState.getValueAsString() + " data points";
            case ApiUsageRecordKey.TRANSPORT_MSG_COUNT -> recordState.getValueAsString() + " messages";
            case ApiUsageRecordKey.JS_EXEC_COUNT -> "JavaScript functions " + recordState.getValueAsString() + " times";
            case ApiUsageRecordKey.TBEL_EXEC_COUNT -> "TBEL functions " + recordState.getValueAsString() + " times";
            case ApiUsageRecordKey.RE_EXEC_COUNT -> recordState.getValueAsString() + " Rule Engine messages";
            case ApiUsageRecordKey.EMAIL_EXEC_COUNT -> recordState.getValueAsString() + " Email messages";
            case ApiUsageRecordKey.SMS_EXEC_COUNT -> recordState.getValueAsString() + " SMS messages";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private void sendMail(JavaMailSenderImpl mailSender, String mailFrom, String email, String subject, String message, long timeout) throws ThingsboardException {
        try {
            MimeMessage mimeMsg = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMsg, UTF_8);
            helper.setFrom(mailFrom);
            helper.setTo(email);
            helper.setSubject(subject);
            helper.setText(message, true);
            this.sendMailWithTimeout((JavaMailSender)mailSender, helper.getMimeMessage(), timeout);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private void sendMailWithTimeout(JavaMailSender mailSender, MimeMessage msg, long timeout) throws ThingsboardException {
        ListenableFuture submittedMail = Futures.withTimeout((ListenableFuture)this.mailExecutorService.submit(() -> mailSender.send(msg)), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutScheduler);
        try {
            submittedMail.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timeout!");
        }
        catch (Exception e) {
            throw new ThingsboardException("Unable to send mail", ExceptionUtils.getRootCause((Throwable)e), ThingsboardErrorCode.GENERAL);
        }
    }

    private String mergeTemplateIntoString(String templateLocation, Map<String, Object> model) throws ThingsboardException {
        try {
            Template template = this.freemarkerConfig.getTemplate(templateLocation);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, model);
        }
        catch (Exception e) {
            log.warn("Failed to process mail template: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new ThingsboardException("Failed to process mail template: " + e.getMessage(), (Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    protected ThingsboardException handleException(Throwable exception) {
        if (exception instanceof ThingsboardException) {
            ThingsboardException thingsboardException = (ThingsboardException)exception;
            return thingsboardException;
        }
        if (exception instanceof NestedRuntimeException) {
            exception = ((NestedRuntimeException)exception).getMostSpecificCause();
        }
        log.warn("Unable to send mail: {}", (Object)exception.getMessage());
        return new ThingsboardException("Unable to send mail: " + exception.getMessage(), ThingsboardErrorCode.GENERAL);
    }

    @ConstructorProperties(value={"messages", "freemarkerConfig", "adminSettingsService", "apiUsageClient", "apiUsageStateService", "mailExecutorService", "passwordResetExecutorService", "ctx", "rateLimitService"})
    @Generated
    public DefaultMailService(MessageSource messages, Configuration freemarkerConfig, AdminSettingsService adminSettingsService, TbApiUsageReportClient apiUsageClient, @Lazy TbApiUsageStateService apiUsageStateService, MailSenderInternalExecutorService mailExecutorService, PasswordResetExecutorService passwordResetExecutorService, TbMailContextComponent ctx, RateLimitService rateLimitService) {
        this.messages = messages;
        this.freemarkerConfig = freemarkerConfig;
        this.adminSettingsService = adminSettingsService;
        this.apiUsageClient = apiUsageClient;
        this.apiUsageStateService = apiUsageStateService;
        this.mailExecutorService = mailExecutorService;
        this.passwordResetExecutorService = passwordResetExecutorService;
        this.ctx = ctx;
        this.rateLimitService = rateLimitService;
    }
}

