/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.lwm2m;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.LwM2MServerSecurityConfigDefault;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.lwm2m.LwM2MService;
import org.thingsboard.server.transport.lwm2m.config.LwM2MSecureServerConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;

@Service
@TbCoreComponent
public class LwM2MServiceImpl
implements LwM2MService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LwM2MServiceImpl.class);
    private final LwM2MTransportServerConfig serverConfig;
    private final Optional<LwM2MTransportBootstrapConfig> bootstrapConfig;

    @Override
    public LwM2MServerSecurityConfigDefault getServerSecurityInfo(boolean bootstrapServer) {
        LwM2MTransportServerConfig bsServerConfig;
        Object object = bsServerConfig = bootstrapServer ? (LwM2MSecureServerConfig)this.bootstrapConfig.orElse(null) : this.serverConfig;
        if (bsServerConfig != null) {
            LwM2MServerSecurityConfigDefault result = this.getServerSecurityConfig((LwM2MSecureServerConfig)bsServerConfig);
            result.setBootstrapServerIs(bootstrapServer);
            return result;
        }
        return null;
    }

    private LwM2MServerSecurityConfigDefault getServerSecurityConfig(LwM2MSecureServerConfig bsServerConfig) {
        LwM2MServerSecurityConfigDefault bsServ = new LwM2MServerSecurityConfigDefault();
        bsServ.setShortServerId(bsServerConfig.getId());
        bsServ.setHost(bsServerConfig.getHost());
        bsServ.setPort(bsServerConfig.getPort());
        bsServ.setSecurityHost(bsServerConfig.getSecureHost());
        bsServ.setSecurityPort(bsServerConfig.getSecurePort());
        byte[] publicKeyBase64 = this.getPublicKey(bsServerConfig);
        if (publicKeyBase64 == null) {
            bsServ.setServerPublicKey("");
        } else {
            bsServ.setServerPublicKey(Base64.encodeBase64String((byte[])publicKeyBase64));
        }
        byte[] certificateBase64 = this.getCertificate(bsServerConfig);
        if (certificateBase64 == null) {
            bsServ.setServerCertificate("");
        } else {
            bsServ.setServerCertificate(Base64.encodeBase64String((byte[])certificateBase64));
        }
        return bsServ;
    }

    private byte[] getPublicKey(LwM2MSecureServerConfig config) {
        try {
            SslCredentials sslCredentials = config.getSslCredentials();
            if (sslCredentials != null) {
                return sslCredentials.getPublicKey().getEncoded();
            }
        }
        catch (Exception e) {
            log.trace("Failed to fetch public key from key store!", (Throwable)e);
        }
        return null;
    }

    private byte[] getCertificate(LwM2MSecureServerConfig config) {
        try {
            SslCredentials sslCredentials = config.getSslCredentials();
            if (sslCredentials != null) {
                return sslCredentials.getCertificateChain()[0].getEncoded();
            }
        }
        catch (Exception e) {
            log.trace("Failed to fetch certificate from key store!", (Throwable)e);
        }
        return null;
    }

    @ConstructorProperties(value={"serverConfig", "bootstrapConfig"})
    @Generated
    public LwM2MServiceImpl(LwM2MTransportServerConfig serverConfig, Optional<LwM2MTransportBootstrapConfig> bootstrapConfig) {
        this.serverConfig = serverConfig;
        this.bootstrapConfig = bootstrapConfig;
    }
}

