/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.migrate;

import lombok.Generated;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumn;

public class CassandraToSqlColumnData {
    private String value;
    private String originalValue;
    private int constraintCounter = 0;

    public CassandraToSqlColumnData(String value) {
        this.value = value;
        this.originalValue = value;
    }

    public int nextContraintCounter() {
        return ++this.constraintCounter;
    }

    public String getNextConstraintStringValue(CassandraToSqlColumn column) {
        int counter = this.nextContraintCounter();
        String newValue = this.originalValue + counter;
        int overflow = newValue.length() - column.getSize();
        if (overflow > 0) {
            newValue = this.originalValue.substring(0, this.originalValue.length() - overflow) + counter;
        }
        return newValue;
    }

    public String getNextConstraintEmailValue(CassandraToSqlColumn column) {
        int counter = this.nextContraintCounter();
        String[] emailValues = this.originalValue.split("@");
        String newValue = emailValues[0] + "+" + counter + "@" + emailValues[1];
        int overflow = newValue.length() - column.getSize();
        if (overflow > 0) {
            newValue = emailValues[0].substring(0, emailValues[0].length() - overflow) + "+" + counter + "@" + emailValues[1];
        }
        return newValue;
    }

    public String getLogValue() {
        if (this.value != null && this.value.length() > 255) {
            return this.value.substring(0, 255) + "...[truncated " + (this.value.length() - 255) + " symbols]";
        }
        return this.value;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getOriginalValue() {
        return this.originalValue;
    }

    @Generated
    public int getConstraintCounter() {
        return this.constraintCounter;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    @Generated
    public void setConstraintCounter(int constraintCounter) {
        this.constraintCounter = constraintCounter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraToSqlColumnData)) {
            return false;
        }
        CassandraToSqlColumnData other = (CassandraToSqlColumnData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConstraintCounter() != other.getConstraintCounter()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$originalValue = this.getOriginalValue();
        String other$originalValue = other.getOriginalValue();
        return !(this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraToSqlColumnData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConstraintCounter();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $originalValue = this.getOriginalValue();
        result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CassandraToSqlColumnData(value=" + this.getValue() + ", originalValue=" + this.getOriginalValue() + ", constraintCounter=" + this.getConstraintCounter() + ")";
    }
}

