/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.ImageDescriptor;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.OAuth2ClientRegistrationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientRegistrationTemplate;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.oauth2.OAuth2ConfigTemplateService;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.util.ImageUtils;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.service.install.update.ResourcesUpdater;
import org.thingsboard.server.utils.LwM2mObjectModelUtils;

@Component
public class InstallScripts {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallScripts.class);
    public static final String APP_DIR = "application";
    public static final String SRC_DIR = "src";
    public static final String MAIN_DIR = "main";
    public static final String DATA_DIR = "data";
    public static final String JSON_DIR = "json";
    public static final String SYSTEM_DIR = "system";
    public static final String TENANT_DIR = "tenant";
    public static final String EDGE_DIR = "edge";
    public static final String DEVICE_PROFILE_DIR = "device_profile";
    public static final String DEMO_DIR = "demo";
    public static final String RULE_CHAINS_DIR = "rule_chains";
    public static final String WIDGET_TYPES_DIR = "widget_types";
    public static final String WIDGET_BUNDLES_DIR = "widget_bundles";
    public static final String SCADA_SYMBOLS_DIR = "scada_symbols";
    public static final String OAUTH2_CONFIG_TEMPLATES_DIR = "oauth2_config_templates";
    public static final String DASHBOARDS_DIR = "dashboards";
    public static final String MODELS_LWM2M_DIR = "lwm2m-registry";
    public static final String RESOURCES_DIR = "resources";
    public static final String JSON_EXT = ".json";
    public static final String SVG_EXT = ".svg";
    public static final String XML_EXT = ".xml";
    @Value(value="${install.data_dir:}")
    private String dataDir;
    @Autowired
    private RuleChainService ruleChainService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private WidgetTypeService widgetTypeService;
    @Autowired
    private WidgetsBundleService widgetsBundleService;
    @Autowired
    private OAuth2ConfigTemplateService oAuth2TemplateService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ResourcesUpdater resourcesUpdater;
    @Autowired
    private ImageService imageService;

    Path getTenantRuleChainsDir() {
        return Paths.get(this.getDataDir(), JSON_DIR, TENANT_DIR, RULE_CHAINS_DIR);
    }

    Path getDeviceProfileDefaultRuleChainTemplateFilePath() {
        return Paths.get(this.getDataDir(), JSON_DIR, TENANT_DIR, DEVICE_PROFILE_DIR, "rule_chain_template.json");
    }

    Path getEdgeRuleChainsDir() {
        return Paths.get(this.getDataDir(), JSON_DIR, EDGE_DIR, RULE_CHAINS_DIR);
    }

    public Path getWidgetTypesDir() {
        return Paths.get(this.getDataDir(), JSON_DIR, SYSTEM_DIR, WIDGET_TYPES_DIR);
    }

    public String getDataDir() {
        if (!StringUtils.isEmpty((CharSequence)this.dataDir)) {
            if (!Paths.get(this.dataDir, new String[0]).toFile().isDirectory()) {
                throw new RuntimeException("'install.data_dir' property value is not a valid directory!");
            }
            return this.dataDir;
        }
        String workDir = System.getProperty("user.dir");
        if (workDir.endsWith(APP_DIR)) {
            return Paths.get(workDir, SRC_DIR, MAIN_DIR, DATA_DIR).toString();
        }
        Path dataDirPath = Paths.get(workDir, APP_DIR, SRC_DIR, MAIN_DIR, DATA_DIR);
        if (Files.exists(dataDirPath, new LinkOption[0])) {
            return dataDirPath.toString();
        }
        throw new RuntimeException("Not valid working directory: " + workDir + ". Please use either root project directory, application module directory or specify valid \"install.data_dir\" ENV variable to avoid automatic data directory lookup!");
    }

    public void createDefaultRuleChains(TenantId tenantId) {
        Path tenantChainsDir = this.getTenantRuleChainsDir();
        this.loadRuleChainsFromPath(tenantId, tenantChainsDir);
    }

    public void createDefaultEdgeRuleChains(TenantId tenantId) {
        Path edgeChainsDir = this.getEdgeRuleChainsDir();
        this.loadRuleChainsFromPath(tenantId, edgeChainsDir);
    }

    private void loadRuleChainsFromPath(TenantId tenantId, Path ruleChainsPath) {
        this.findRuleChainsFromPath(ruleChainsPath).forEach(path -> {
            try {
                this.createRuleChainFromFile(tenantId, (Path)path, null);
            }
            catch (Exception e) {
                log.error("Unable to load rule chain from json: [{}]", (Object)path.toString());
                throw new RuntimeException("Unable to load rule chain from json", e);
            }
        });
    }

    List<Path> findRuleChainsFromPath(Path ruleChainsPath) {
        try (Stream<Path> files = this.listDir(ruleChainsPath).filter(path -> path.toString().endsWith(JSON_EXT));){
            List<Path> list = files.toList();
            return list;
        }
    }

    public RuleChain createDefaultRuleChain(TenantId tenantId, String ruleChainName) {
        return this.createRuleChainFromFile(tenantId, this.getDeviceProfileDefaultRuleChainTemplateFilePath(), ruleChainName);
    }

    public RuleChain createRuleChainFromFile(TenantId tenantId, Path templateFilePath, String newRuleChainName) {
        JsonNode ruleChainJson = JacksonUtil.toJsonNode((File)templateFilePath.toFile());
        RuleChain ruleChain = (RuleChain)JacksonUtil.treeToValue((JsonNode)ruleChainJson.get("ruleChain"), RuleChain.class);
        RuleChainMetaData ruleChainMetaData = (RuleChainMetaData)JacksonUtil.treeToValue((JsonNode)ruleChainJson.get("metadata"), RuleChainMetaData.class);
        ruleChain.setTenantId(tenantId);
        if (!StringUtils.isEmpty((CharSequence)newRuleChainName)) {
            ruleChain.setName(newRuleChainName);
        }
        ruleChain = this.ruleChainService.saveRuleChain(ruleChain, false);
        ruleChainMetaData.setRuleChainId(ruleChain.getId());
        this.ruleChainService.saveRuleChainMetaData(tenantId, ruleChainMetaData, Function.identity(), false);
        return ruleChain;
    }

    public void loadSystemWidgets() {
        log.info("Loading system widgets");
        HashMap widgetsBundlesMap = new HashMap();
        Path widgetBundlesDir = Paths.get(this.getDataDir(), JSON_DIR, SYSTEM_DIR, WIDGET_BUNDLES_DIR);
        try (Stream<Path> dirStream = this.listDir(widgetBundlesDir).filter(path -> path.toString().endsWith(JSON_EXT));){
            dirStream.forEach(path -> {
                JsonNode widgetsBundleDescriptorJson;
                try {
                    widgetsBundleDescriptorJson = JacksonUtil.toJsonNode((File)path.toFile());
                }
                catch (Exception e) {
                    log.error("Unable to parse widgets bundle from json: [{}]", path);
                    throw new RuntimeException("Unable to parse widgets bundle from json", e);
                }
                if (widgetsBundleDescriptorJson == null || !widgetsBundleDescriptorJson.has("widgetsBundle")) {
                    log.error("Invalid widgets bundle json: [{}]", path);
                    throw new RuntimeException("Invalid widgets bundle json: [" + String.valueOf(path) + "]");
                }
                widgetsBundlesMap.put(path, widgetsBundleDescriptorJson);
                JsonNode bundleAliasNode = widgetsBundleDescriptorJson.get("widgetsBundle").get("alias");
                if (bundleAliasNode == null || !bundleAliasNode.isTextual()) {
                    log.error("Invalid widgets bundle json: [{}]", path);
                    throw new RuntimeException("Invalid widgets bundle json: [" + String.valueOf(path) + "]");
                }
                String bundleAlias = bundleAliasNode.asText();
                try {
                    this.deleteSystemWidgetBundle(bundleAlias);
                }
                catch (Exception e) {
                    log.error("Failed to delete system widgets bundle: [{}]", (Object)bundleAlias);
                    throw new RuntimeException("Failed to delete system widgets bundle: [" + bundleAlias + "]", e);
                }
            });
        }
        Path widgetTypesDir = this.getWidgetTypesDir();
        if (Files.exists(widgetTypesDir, new LinkOption[0])) {
            try (Stream<Path> dirStream = this.listDir(widgetTypesDir).filter(path -> path.toString().endsWith(JSON_EXT));){
                dirStream.forEach(path -> {
                    try {
                        JsonNode widgetTypeJson = JacksonUtil.toJsonNode((File)path.toFile());
                        WidgetTypeDetails widgetTypeDetails = (WidgetTypeDetails)JacksonUtil.treeToValue((JsonNode)widgetTypeJson, WidgetTypeDetails.class);
                        this.widgetTypeService.saveWidgetType(widgetTypeDetails);
                    }
                    catch (Exception e) {
                        log.error("Unable to load widget type from json: [{}]", (Object)path.toString());
                        throw new RuntimeException("Unable to load widget type from json", e);
                    }
                });
            }
        }
        this.loadSystemScadaSymbols();
        for (Map.Entry widgetsBundleDescriptorEntry : widgetsBundlesMap.entrySet()) {
            Path path2 = (Path)widgetsBundleDescriptorEntry.getKey();
            try {
                JsonNode widgetsBundleDescriptorJson = (JsonNode)widgetsBundleDescriptorEntry.getValue();
                JsonNode widgetsBundleJson = widgetsBundleDescriptorJson.get("widgetsBundle");
                WidgetsBundle widgetsBundle = (WidgetsBundle)JacksonUtil.treeToValue((JsonNode)widgetsBundleJson, WidgetsBundle.class);
                WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
                ArrayList widgetTypeFqns = new ArrayList();
                if (widgetsBundleDescriptorJson.has("widgetTypes")) {
                    JsonNode widgetTypesArrayJson = widgetsBundleDescriptorJson.get("widgetTypes");
                    widgetTypesArrayJson.forEach(widgetTypeJson -> {
                        try {
                            WidgetTypeDetails widgetTypeDetails = (WidgetTypeDetails)JacksonUtil.treeToValue((JsonNode)widgetTypeJson, WidgetTypeDetails.class);
                            WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetTypeDetails);
                            widgetTypeFqns.add(savedWidgetType.getFqn());
                        }
                        catch (Exception e) {
                            log.error("Unable to load widget type from json: [{}]", (Object)path2.toString());
                            throw new RuntimeException("Unable to load widget type from json", e);
                        }
                    });
                }
                if (widgetsBundleDescriptorJson.has("widgetTypeFqns")) {
                    JsonNode widgetFqnsArrayJson = widgetsBundleDescriptorJson.get("widgetTypeFqns");
                    widgetFqnsArrayJson.forEach(fqnJson -> widgetTypeFqns.add(fqnJson.asText()));
                }
                this.widgetTypeService.updateWidgetsBundleWidgetFqns(TenantId.SYS_TENANT_ID, savedWidgetsBundle.getId(), widgetTypeFqns);
            }
            catch (Exception e) {
                log.error("Unable to load widgets bundle from json: [{}]", (Object)path2.toString());
                throw new RuntimeException("Unable to load widgets bundle from json", e);
            }
        }
    }

    private void loadSystemScadaSymbols() {
        log.info("Loading system SCADA symbols");
        Path scadaSymbolsDir = Paths.get(this.getDataDir(), JSON_DIR, SYSTEM_DIR, SCADA_SYMBOLS_DIR);
        if (Files.exists(scadaSymbolsDir, new LinkOption[0])) {
            WidgetTypeDetails scadaSymbolWidgetTemplate = this.widgetTypeService.findWidgetTypeDetailsByTenantIdAndFqn(TenantId.SYS_TENANT_ID, "scada_symbol");
            try (Stream<Path> dirStream = this.listDir(scadaSymbolsDir).filter(path -> path.toString().endsWith(SVG_EXT));){
                dirStream.forEach(path -> {
                    try {
                        String fileName = path.getFileName().toString();
                        byte[] scadaSymbolData = Files.readAllBytes(path);
                        ImageUtils.ScadaSymbolMetadataInfo metadata = ImageUtils.processScadaSymbolMetadata((String)fileName, (byte[])scadaSymbolData);
                        TbResourceInfo savedScadaSymbol = this.saveScadaSymbol(metadata, fileName, scadaSymbolData);
                        if (scadaSymbolWidgetTemplate != null) {
                            this.saveScadaSymbolWidget(scadaSymbolWidgetTemplate, savedScadaSymbol, metadata);
                        }
                    }
                    catch (Exception e) {
                        log.error("Unable to load SCADA symbol from file: [{}]", (Object)path.toString());
                        throw new RuntimeException("Unable to load SCADA symbol from file", e);
                    }
                });
            }
        }
    }

    private TbResourceInfo saveScadaSymbol(ImageUtils.ScadaSymbolMetadataInfo metadata, String fileName, byte[] scadaSymbolData) {
        String etag = this.imageService.calculateImageEtag(scadaSymbolData);
        TbResourceInfo existingImage = this.imageService.findSystemOrTenantImageByEtag(TenantId.SYS_TENANT_ID, etag);
        if (existingImage != null && ResourceSubType.SCADA_SYMBOL.equals((Object)existingImage.getResourceSubType())) {
            return existingImage;
        }
        TbResourceInfo existing = this.imageService.getImageInfoByTenantIdAndKey(TenantId.SYS_TENANT_ID, fileName);
        if (existing != null && ResourceSubType.SCADA_SYMBOL.equals((Object)existing.getResourceSubType())) {
            this.imageService.deleteImage(existing, true);
        }
        TbResource image = new TbResource();
        image.setTenantId(TenantId.SYS_TENANT_ID);
        image.setFileName(fileName);
        image.setTitle(metadata.getTitle());
        image.setResourceSubType(ResourceSubType.SCADA_SYMBOL);
        image.setResourceType(ResourceType.IMAGE);
        image.setPublic(true);
        ImageDescriptor descriptor = new ImageDescriptor();
        descriptor.setMediaType("image/svg+xml");
        image.setDescriptorValue((Object)descriptor);
        image.setData(scadaSymbolData);
        return this.imageService.saveImage(image);
    }

    private WidgetTypeDetails saveScadaSymbolWidget(WidgetTypeDetails template, TbResourceInfo scadaSymbol, ImageUtils.ScadaSymbolMetadataInfo metadata) {
        ObjectNode settings;
        String symbolUrl = "tb-image;" + scadaSymbol.getLink();
        WidgetTypeDetails scadaSymbolWidget = new WidgetTypeDetails();
        JsonNode descriptor = (JsonNode)JacksonUtil.clone((Object)template.getDescriptor());
        scadaSymbolWidget.setDescriptor(descriptor);
        scadaSymbolWidget.setName(metadata.getTitle());
        scadaSymbolWidget.setImage(symbolUrl);
        scadaSymbolWidget.setDescription(metadata.getDescription());
        scadaSymbolWidget.setTags(metadata.getSearchTags());
        scadaSymbolWidget.setScada(true);
        ObjectNode defaultConfig = null;
        if (descriptor.has("defaultConfig")) {
            defaultConfig = (ObjectNode)JacksonUtil.fromString((String)descriptor.get("defaultConfig").asText(), ObjectNode.class);
        }
        if (defaultConfig == null) {
            defaultConfig = JacksonUtil.newObjectNode();
        }
        defaultConfig.put("title", metadata.getTitle());
        if (defaultConfig.has("settings")) {
            settings = (ObjectNode)defaultConfig.get("settings");
        } else {
            settings = JacksonUtil.newObjectNode();
            defaultConfig.set("settings", (JsonNode)settings);
        }
        settings.put("scadaSymbolUrl", symbolUrl);
        ((ObjectNode)descriptor).put("defaultConfig", JacksonUtil.toString((Object)defaultConfig));
        ((ObjectNode)descriptor).put("sizeX", metadata.getWidgetSizeX());
        ((ObjectNode)descriptor).put("sizeY", metadata.getWidgetSizeY());
        String controllerScript = descriptor.get("controllerScript").asText();
        controllerScript = controllerScript.replaceAll("previewWidth: '\\d*px'", "previewWidth: '" + metadata.getWidgetSizeX() * 100 + "px'");
        controllerScript = controllerScript.replaceAll("previewHeight: '\\d*px'", "previewHeight: '" + (metadata.getWidgetSizeY() * 100 + 20) + "px'");
        ((ObjectNode)descriptor).put("controllerScript", controllerScript);
        return this.widgetTypeService.saveWidgetType(scadaSymbolWidget);
    }

    private void deleteSystemWidgetBundle(String bundleAlias) {
        WidgetsBundle widgetsBundle = this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(TenantId.SYS_TENANT_ID, bundleAlias);
        if (widgetsBundle != null) {
            this.widgetTypeService.deleteWidgetTypesByBundleId(TenantId.SYS_TENANT_ID, widgetsBundle.getId());
            this.widgetsBundleService.deleteWidgetsBundle(TenantId.SYS_TENANT_ID, widgetsBundle.getId());
        }
    }

    public void loadSystemImagesAndResources() {
        Stream<Path> dashboardsFiles;
        log.info("Loading system images and resources...");
        try (Stream<Path> stream = dashboardsFiles = Stream.concat(this.listDir(Paths.get(this.getDataDir(), JSON_DIR, DEMO_DIR, DASHBOARDS_DIR)), this.listDir(Paths.get(this.getDataDir(), JSON_DIR, TENANT_DIR, DASHBOARDS_DIR)));){
            dashboardsFiles.forEach(file -> {
                try {
                    Dashboard dashboard = (Dashboard)JacksonUtil.OBJECT_MAPPER.readValue(file.toFile(), Dashboard.class);
                    this.resourcesUpdater.createSystemImagesAndResources(dashboard);
                }
                catch (Exception e) {
                    log.error("Failed to create system images for default dashboard {}", (Object)file.getFileName(), (Object)e);
                }
            });
        }
        Path resourcesDir = Path.of(this.getDataDir(), RESOURCES_DIR);
        this.loadSystemResources(resourcesDir.resolve("images"), ResourceType.IMAGE, null);
        this.loadSystemResources(resourcesDir.resolve("js_modules"), ResourceType.JS_MODULE, ResourceSubType.EXTENSION);
        this.loadSystemResources(resourcesDir.resolve(DASHBOARDS_DIR), ResourceType.DASHBOARD, null);
    }

    public void loadDashboards(TenantId tenantId, CustomerId customerId) {
        Path dashboardsDir = Paths.get(this.getDataDir(), JSON_DIR, DEMO_DIR, DASHBOARDS_DIR);
        this.loadDashboardsFromDir(tenantId, customerId, dashboardsDir);
    }

    public void createDefaultTenantDashboards(TenantId tenantId, CustomerId customerId) {
        Path dashboardsDir = Paths.get(this.getDataDir(), JSON_DIR, TENANT_DIR, DASHBOARDS_DIR);
        this.loadDashboardsFromDir(tenantId, customerId, dashboardsDir);
    }

    private void loadDashboardsFromDir(TenantId tenantId, CustomerId customerId, Path dashboardsDir) {
        try (Stream<Path> dashboards = this.listDir(dashboardsDir).filter(path -> path.toString().endsWith(JSON_EXT));){
            dashboards.forEach(path -> {
                try {
                    JsonNode dashboardJson = JacksonUtil.toJsonNode((File)path.toFile());
                    Dashboard dashboard = (Dashboard)JacksonUtil.treeToValue((JsonNode)dashboardJson, Dashboard.class);
                    dashboard.setTenantId(tenantId);
                    Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
                    if (customerId != null && !customerId.isNullUid()) {
                        this.dashboardService.assignDashboardToCustomer(TenantId.SYS_TENANT_ID, savedDashboard.getId(), customerId);
                    }
                }
                catch (Exception e) {
                    log.error("Unable to load dashboard from json: [{}]", (Object)path.toString());
                    throw new RuntimeException("Unable to load dashboard from json", e);
                }
            });
        }
    }

    public void loadDemoRuleChains(TenantId tenantId) {
        try {
            this.createDefaultRuleChains(tenantId);
            this.createDefaultRuleChain(tenantId, "Thermostat");
            this.createDefaultEdgeRuleChains(tenantId);
        }
        catch (Exception e) {
            log.error("Unable to load rule chain from json", (Throwable)e);
            throw new RuntimeException("Unable to load rule chain from json", e);
        }
    }

    public void createOAuth2Templates() {
        Path oauth2ConfigTemplatesDir = Paths.get(this.getDataDir(), JSON_DIR, SYSTEM_DIR, OAUTH2_CONFIG_TEMPLATES_DIR);
        try (Stream<Path> dirStream = this.listDir(oauth2ConfigTemplatesDir).filter(path -> path.toString().endsWith(JSON_EXT));){
            dirStream.forEach(path -> {
                try {
                    JsonNode oauth2ConfigTemplateJson = JacksonUtil.toJsonNode((File)path.toFile());
                    OAuth2ClientRegistrationTemplate clientRegistrationTemplate = (OAuth2ClientRegistrationTemplate)JacksonUtil.treeToValue((JsonNode)oauth2ConfigTemplateJson, OAuth2ClientRegistrationTemplate.class);
                    Optional existingClientRegistrationTemplate = this.oAuth2TemplateService.findClientRegistrationTemplateByProviderId(clientRegistrationTemplate.getProviderId());
                    if (existingClientRegistrationTemplate.isPresent()) {
                        clientRegistrationTemplate.setId((UUIDBased)((OAuth2ClientRegistrationTemplateId)((OAuth2ClientRegistrationTemplate)existingClientRegistrationTemplate.get()).getId()));
                    }
                    this.oAuth2TemplateService.saveClientRegistrationTemplate(clientRegistrationTemplate);
                }
                catch (Exception e) {
                    log.error("Unable to load oauth2 config templates from json: [{}]", (Object)path.toString());
                    throw new RuntimeException("Unable to load oauth2 config templates from json", e);
                }
            });
        }
    }

    public void loadSystemLwm2mResources() {
        Path resourceLwm2mPath = Paths.get(this.getDataDir(), MODELS_LWM2M_DIR);
        try (Stream<Path> dirStream = this.listDir(resourceLwm2mPath).filter(path -> path.toString().endsWith(XML_EXT));){
            dirStream.forEach(path -> {
                try {
                    byte[] data = Files.readAllBytes(path);
                    TbResource tbResource = new TbResource();
                    tbResource.setTenantId(TenantId.SYS_TENANT_ID);
                    tbResource.setData(data);
                    tbResource.setResourceType(ResourceType.LWM2M_MODEL);
                    tbResource.setFileName(path.toFile().getName());
                    this.doSaveLwm2mResource(tbResource);
                }
                catch (Exception e) {
                    log.error("Unable to load resource lwm2m object model from file: [{}]", (Object)path.toString());
                    throw new RuntimeException("resource lwm2m object model from file", e);
                }
            });
        }
        catch (Exception e) {
            log.error("Unable to load resources lwm2m object model from file: [{}]", (Object)resourceLwm2mPath);
            throw new RuntimeException("resource lwm2m object model from file", e);
        }
    }

    private void loadSystemResources(Path dir, ResourceType resourceType, ResourceSubType resourceSubType) {
        this.listDir(dir).forEach(resourceFile -> {
            String resourceKey = resourceFile.getFileName().toString();
            try {
                byte[] data = this.getContent((Path)resourceFile);
                if (resourceType == ResourceType.IMAGE) {
                    this.imageService.createOrUpdateSystemImage(resourceKey, data);
                } else {
                    this.resourceService.createOrUpdateSystemResource(resourceType, resourceSubType, resourceKey, data);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load system resource " + String.valueOf(resourceFile), e);
            }
        });
    }

    private byte[] getContent(Path file) {
        try {
            return Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Stream<Path> listDir(Path dir) {
        try {
            return Files.list(dir);
        }
        catch (NoSuchFileException e) {
            return Stream.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doSaveLwm2mResource(TbResource resource) throws ThingsboardException {
        log.trace("Executing saveResource [{}]", (Object)resource);
        if (resource.getData() == null || resource.getData().length == 0) {
            throw new DataValidationException("Resource data should be specified!");
        }
        LwM2mObjectModelUtils.toLwm2mResource(resource);
        TbResource foundResource = this.resourceService.findResourceByTenantIdAndKey(TenantId.SYS_TENANT_ID, ResourceType.LWM2M_MODEL, resource.getResourceKey());
        if (foundResource == null) {
            this.resourceService.saveResource(resource);
        }
    }
}

