/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.device.profile.AlarmCondition;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilter;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilterKey;
import org.thingsboard.server.common.data.device.profile.AlarmConditionKeyType;
import org.thingsboard.server.common.data.device.profile.AlarmConditionSpec;
import org.thingsboard.server.common.data.device.profile.AlarmRule;
import org.thingsboard.server.common.data.device.profile.DefaultDeviceProfileConfiguration;
import org.thingsboard.server.common.data.device.profile.DefaultDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileAlarm;
import org.thingsboard.server.common.data.device.profile.DeviceProfileConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileData;
import org.thingsboard.server.common.data.device.profile.DeviceProfileProvisionConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DisabledDeviceProfileProvisionConfiguration;
import org.thingsboard.server.common.data.device.profile.SimpleAlarmConditionSpec;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.query.BooleanFilterPredicate;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.DynamicValueSourceType;
import org.thingsboard.server.common.data.query.EntityKeyValueType;
import org.thingsboard.server.common.data.query.FilterPredicateValue;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.NumericFilterPredicate;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.ProcessingStrategyType;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.queue.SubmitStrategyType;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.JwtSettings;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceConnectivityConfiguration;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.mobile.MobileAppDao;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.install.SystemDataLoaderService;
import org.thingsboard.server.service.security.auth.jwt.settings.DefaultJwtSettingsService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

@Service
@Profile(value={"install"})
public class DefaultSystemDataLoaderService
implements SystemDataLoaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemDataLoaderService.class);
    public static final String CUSTOMER_CRED = "customer";
    public static final String ACTIVITY_STATE = "active";
    private final InstallScripts installScripts;
    private final UserService userService;
    private final AdminSettingsService adminSettingsService;
    private final TenantService tenantService;
    private final TenantProfileService tenantProfileService;
    private final CustomerService customerService;
    private final DeviceService deviceService;
    private final DeviceProfileService deviceProfileService;
    private final AttributesService attributesService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final RuleChainService ruleChainService;
    private final TimeseriesService tsService;
    private final DeviceConnectivityConfiguration connectivityConfiguration;
    private final QueueService queueService;
    private final JwtSettingsService jwtSettingsService;
    private final MobileAppDao mobileAppDao;
    private final NotificationSettingsService notificationSettingsService;
    private final NotificationTargetService notificationTargetService;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Value(value="${state.persistToTelemetry:false}")
    private boolean persistActivityToTelemetry;
    @Value(value="${security.jwt.tokenExpirationTime:9000}")
    private Integer tokenExpirationTime;
    @Value(value="${security.jwt.refreshTokenExpTime:604800}")
    private Integer refreshTokenExpTime;
    @Value(value="${security.jwt.tokenIssuer:thingsboard.io}")
    private String tokenIssuer;
    @Value(value="${security.jwt.tokenSigningKey:thingsboardDefaultSigningKey}")
    private String tokenSigningKey;
    private ExecutorService tsCallBackExecutor;

    @Bean
    protected BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @PostConstruct
    public void initExecutor() {
        this.tsCallBackExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"sys-loader-ts-callback"));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.tsCallBackExecutor != null) {
            this.tsCallBackExecutor.shutdownNow();
        }
    }

    @Override
    public void createSysAdmin() {
        this.createUser(Authority.SYS_ADMIN, null, null, "sysadmin@thingsboard.org", "sysadmin");
    }

    @Override
    public void createDefaultTenantProfiles() throws Exception {
        this.tenantProfileService.findOrCreateDefaultTenantProfile(TenantId.SYS_TENANT_ID);
        TenantProfileData isolatedRuleEngineTenantProfileData = new TenantProfileData();
        DefaultTenantProfileConfiguration configuration = new DefaultTenantProfileConfiguration();
        configuration.setMaxDebugModeDurationMinutes(15);
        isolatedRuleEngineTenantProfileData.setConfiguration((TenantProfileConfiguration)configuration);
        TenantProfileQueueConfiguration mainQueueConfiguration = new TenantProfileQueueConfiguration();
        mainQueueConfiguration.setName("Main");
        mainQueueConfiguration.setTopic("tb_rule_engine.main");
        mainQueueConfiguration.setPollInterval(25);
        mainQueueConfiguration.setPartitions(10);
        mainQueueConfiguration.setConsumerPerPartition(true);
        mainQueueConfiguration.setPackProcessingTimeout(2000L);
        SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
        mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
        mainQueueSubmitStrategy.setBatchSize(1000);
        mainQueueConfiguration.setSubmitStrategy(mainQueueSubmitStrategy);
        ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
        mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        mainQueueProcessingStrategy.setRetries(3);
        mainQueueProcessingStrategy.setFailurePercentage(0.0);
        mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
        mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
        mainQueueConfiguration.setProcessingStrategy(mainQueueProcessingStrategy);
        isolatedRuleEngineTenantProfileData.setQueueConfiguration(Collections.singletonList(mainQueueConfiguration));
        TenantProfile isolatedTbRuleEngineProfile = new TenantProfile();
        isolatedTbRuleEngineProfile.setDefault(false);
        isolatedTbRuleEngineProfile.setName("Isolated TB Rule Engine");
        isolatedTbRuleEngineProfile.setDescription("Isolated TB Rule Engine tenant profile");
        isolatedTbRuleEngineProfile.setIsolatedTbRuleEngine(true);
        isolatedTbRuleEngineProfile.setProfileData(isolatedRuleEngineTenantProfileData);
        try {
            this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, isolatedTbRuleEngineProfile);
        }
        catch (DataValidationException e) {
            log.warn(e.getMessage());
        }
    }

    @Override
    public void createAdminSettings() throws Exception {
        AdminSettings generalSettings = new AdminSettings();
        generalSettings.setTenantId(TenantId.SYS_TENANT_ID);
        generalSettings.setKey("general");
        ObjectNode node = JacksonUtil.newObjectNode();
        node.put("baseUrl", "http://localhost:8080");
        node.put("prohibitDifferentUrl", false);
        generalSettings.setJsonValue((JsonNode)node);
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, generalSettings);
        AdminSettings mailSettings = new AdminSettings();
        mailSettings.setTenantId(TenantId.SYS_TENANT_ID);
        mailSettings.setKey("mail");
        node = JacksonUtil.newObjectNode();
        node.put("mailFrom", "ThingsBoard <sysadmin@localhost.localdomain>");
        node.put("smtpProtocol", "smtp");
        node.put("smtpHost", "localhost");
        node.put("smtpPort", "25");
        node.put("timeout", "10000");
        node.put("enableTls", false);
        node.put("username", "");
        node.put("password", "");
        node.put("tlsVersion", "TLSv1.2");
        node.put("enableProxy", false);
        node.put("showChangePassword", false);
        mailSettings.setJsonValue((JsonNode)node);
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, mailSettings);
        AdminSettings connectivitySettings = new AdminSettings();
        connectivitySettings.setTenantId(TenantId.SYS_TENANT_ID);
        connectivitySettings.setKey("connectivity");
        connectivitySettings.setJsonValue(JacksonUtil.valueToTree((Object)this.connectivityConfiguration.getConnectivity()));
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, connectivitySettings);
    }

    @Override
    public void createRandomJwtSettings() throws Exception {
        if (this.jwtSettingsService.getJwtSettings() == null) {
            log.info("Creating JWT admin settings...");
            JwtSettings jwtSettings = new JwtSettings(this.tokenExpirationTime, this.refreshTokenExpTime, this.tokenIssuer, this.tokenSigningKey);
            if (DefaultJwtSettingsService.isSigningKeyDefault(jwtSettings) || !DefaultJwtSettingsService.validateKeyLength(jwtSettings.getTokenSigningKey())) {
                jwtSettings.setTokenSigningKey(this.generateRandomKey());
            }
            this.jwtSettingsService.saveJwtSettings(jwtSettings);
        } else {
            log.info("Skip creating JWT admin settings because they already exist.");
        }
    }

    @Override
    public void updateSecuritySettings() {
        List mobiles;
        JwtSettings jwtSettings = this.jwtSettingsService.getJwtSettings();
        boolean invalidSignKey = false;
        String warningMessage = null;
        if (DefaultJwtSettingsService.isSigningKeyDefault(jwtSettings)) {
            warningMessage = "The platform is using the default JWT Signing Key, which is a security risk.";
            invalidSignKey = true;
        } else if (!DefaultJwtSettingsService.validateKeyLength(jwtSettings.getTokenSigningKey())) {
            warningMessage = "The JWT Signing Key is shorter than 512 bits, which is a security risk.";
            invalidSignKey = true;
        }
        if (invalidSignKey) {
            log.warn("WARNING: {}. A new JWT Signing Key has been added automatically. You can change the JWT Signing Key using the Web UI: Navigate to \"System settings -> Security settings\" while logged in as a System Administrator.", (Object)warningMessage);
            jwtSettings.setTokenSigningKey(this.generateRandomKey());
            this.jwtSettingsService.saveJwtSettings(jwtSettings);
        }
        if (CollectionUtils.isNotEmpty((Collection)(mobiles = this.mobileAppDao.findByTenantId(TenantId.SYS_TENANT_ID, null, new PageLink(Integer.MAX_VALUE, 0)).getData()))) {
            mobiles.stream().filter(mobileApp -> !DefaultJwtSettingsService.validateKeyLength(mobileApp.getAppSecret())).forEach(mobileApp -> {
                log.warn("WARNING: The App secret is shorter than 512 bits, which is a security risk. A new Application Secret has been added automatically for Mobile Application [{}]. You can change the Application Secret using the Web UI: Navigate to \"Security settings -> OAuth2 -> Mobile applications\" while logged in as a System Administrator.", (Object)mobileApp.getPkgName());
                mobileApp.setAppSecret(this.generateRandomKey());
                this.mobileAppDao.save(TenantId.SYS_TENANT_ID, mobileApp);
            });
        }
    }

    private String generateRandomKey() {
        return Base64.getEncoder().encodeToString(RandomStringUtils.randomAlphanumeric((int)64).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void createOAuth2Templates() throws Exception {
        this.installScripts.createOAuth2Templates();
    }

    @Override
    public void loadDemoData() throws Exception {
        Tenant demoTenant = new Tenant();
        demoTenant.setRegion("Global");
        demoTenant.setTitle("Tenant");
        demoTenant = this.tenantService.saveTenant(demoTenant);
        this.installScripts.loadDemoRuleChains(demoTenant.getId());
        this.createUser(Authority.TENANT_ADMIN, demoTenant.getId(), null, "tenant@thingsboard.org", "tenant");
        Customer customerA = new Customer();
        customerA.setTenantId(demoTenant.getId());
        customerA.setTitle("Customer A");
        customerA = this.customerService.saveCustomer(customerA);
        Customer customerB = new Customer();
        customerB.setTenantId(demoTenant.getId());
        customerB.setTitle("Customer B");
        customerB = this.customerService.saveCustomer(customerB);
        Customer customerC = new Customer();
        customerC.setTenantId(demoTenant.getId());
        customerC.setTitle("Customer C");
        customerC = this.customerService.saveCustomer(customerC);
        this.createUser(Authority.CUSTOMER_USER, demoTenant.getId(), customerA.getId(), "customer@thingsboard.org", CUSTOMER_CRED);
        this.createUser(Authority.CUSTOMER_USER, demoTenant.getId(), customerA.getId(), "customerA@thingsboard.org", CUSTOMER_CRED);
        this.createUser(Authority.CUSTOMER_USER, demoTenant.getId(), customerB.getId(), "customerB@thingsboard.org", CUSTOMER_CRED);
        this.createUser(Authority.CUSTOMER_USER, demoTenant.getId(), customerC.getId(), "customerC@thingsboard.org", CUSTOMER_CRED);
        DeviceProfile defaultDeviceProfile = this.deviceProfileService.findOrCreateDeviceProfile(demoTenant.getId(), "default");
        this.createDevice(demoTenant.getId(), customerA.getId(), defaultDeviceProfile.getId(), "Test Device A1", "A1_TEST_TOKEN", null);
        this.createDevice(demoTenant.getId(), customerA.getId(), defaultDeviceProfile.getId(), "Test Device A2", "A2_TEST_TOKEN", null);
        this.createDevice(demoTenant.getId(), customerA.getId(), defaultDeviceProfile.getId(), "Test Device A3", "A3_TEST_TOKEN", null);
        this.createDevice(demoTenant.getId(), customerB.getId(), defaultDeviceProfile.getId(), "Test Device B1", "B1_TEST_TOKEN", null);
        this.createDevice(demoTenant.getId(), customerC.getId(), defaultDeviceProfile.getId(), "Test Device C1", "C1_TEST_TOKEN", null);
        this.createDevice(demoTenant.getId(), null, defaultDeviceProfile.getId(), "DHT11 Demo Device", "DHT11_DEMO_TOKEN", "Demo device that is used in sample applications that upload data from DHT11 temperature and humidity sensor");
        this.createDevice(demoTenant.getId(), null, defaultDeviceProfile.getId(), "Raspberry Pi Demo Device", "RASPBERRY_PI_DEMO_TOKEN", "Demo device that is used in Raspberry Pi GPIO control sample application");
        DeviceProfile thermostatDeviceProfile = new DeviceProfile();
        thermostatDeviceProfile.setTenantId(demoTenant.getId());
        thermostatDeviceProfile.setDefault(false);
        thermostatDeviceProfile.setName("thermostat");
        thermostatDeviceProfile.setType(DeviceProfileType.DEFAULT);
        thermostatDeviceProfile.setTransportType(DeviceTransportType.DEFAULT);
        thermostatDeviceProfile.setProvisionType(DeviceProfileProvisionType.DISABLED);
        thermostatDeviceProfile.setDescription("Thermostat device profile");
        thermostatDeviceProfile.setDefaultRuleChainId(((RuleChain)this.ruleChainService.findTenantRuleChainsByType(demoTenant.getId(), RuleChainType.CORE, new PageLink(1, 0, "Thermostat")).getData().get(0)).getId());
        DeviceProfileData deviceProfileData = new DeviceProfileData();
        DefaultDeviceProfileConfiguration configuration = new DefaultDeviceProfileConfiguration();
        DefaultDeviceProfileTransportConfiguration transportConfiguration = new DefaultDeviceProfileTransportConfiguration();
        DisabledDeviceProfileProvisionConfiguration provisionConfiguration = new DisabledDeviceProfileProvisionConfiguration(null);
        deviceProfileData.setConfiguration((DeviceProfileConfiguration)configuration);
        deviceProfileData.setTransportConfiguration((DeviceProfileTransportConfiguration)transportConfiguration);
        deviceProfileData.setProvisionConfiguration((DeviceProfileProvisionConfiguration)provisionConfiguration);
        thermostatDeviceProfile.setProfileData(deviceProfileData);
        DeviceProfileAlarm highTemperature = new DeviceProfileAlarm();
        highTemperature.setId("highTemperatureAlarmID");
        highTemperature.setAlarmType("High Temperature");
        AlarmRule temperatureRule = new AlarmRule();
        AlarmCondition temperatureCondition = new AlarmCondition();
        temperatureCondition.setSpec((AlarmConditionSpec)new SimpleAlarmConditionSpec());
        AlarmConditionFilter temperatureAlarmFlagAttributeFilter = new AlarmConditionFilter();
        temperatureAlarmFlagAttributeFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.ATTRIBUTE, "temperatureAlarmFlag"));
        temperatureAlarmFlagAttributeFilter.setValueType(EntityKeyValueType.BOOLEAN);
        BooleanFilterPredicate temperatureAlarmFlagAttributePredicate = new BooleanFilterPredicate();
        temperatureAlarmFlagAttributePredicate.setOperation(BooleanFilterPredicate.BooleanOperation.EQUAL);
        temperatureAlarmFlagAttributePredicate.setValue(new FilterPredicateValue((Object)Boolean.TRUE));
        temperatureAlarmFlagAttributeFilter.setPredicate((KeyFilterPredicate)temperatureAlarmFlagAttributePredicate);
        AlarmConditionFilter temperatureTimeseriesFilter = new AlarmConditionFilter();
        temperatureTimeseriesFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.TIME_SERIES, "temperature"));
        temperatureTimeseriesFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate temperatureTimeseriesFilterPredicate = new NumericFilterPredicate();
        temperatureTimeseriesFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.GREATER);
        FilterPredicateValue temperatureTimeseriesPredicateValue = new FilterPredicateValue((Object)25.0, null, new DynamicValue(DynamicValueSourceType.CURRENT_DEVICE, "temperatureAlarmThreshold"));
        temperatureTimeseriesFilterPredicate.setValue(temperatureTimeseriesPredicateValue);
        temperatureTimeseriesFilter.setPredicate((KeyFilterPredicate)temperatureTimeseriesFilterPredicate);
        temperatureCondition.setCondition(Arrays.asList(temperatureAlarmFlagAttributeFilter, temperatureTimeseriesFilter));
        temperatureRule.setAlarmDetails("Current temperature = ${temperature}");
        temperatureRule.setCondition(temperatureCondition);
        highTemperature.setCreateRules(new TreeMap<AlarmSeverity, AlarmRule>(Collections.singletonMap(AlarmSeverity.MAJOR, temperatureRule)));
        AlarmRule clearTemperatureRule = new AlarmRule();
        AlarmCondition clearTemperatureCondition = new AlarmCondition();
        clearTemperatureCondition.setSpec((AlarmConditionSpec)new SimpleAlarmConditionSpec());
        AlarmConditionFilter clearTemperatureTimeseriesFilter = new AlarmConditionFilter();
        clearTemperatureTimeseriesFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.TIME_SERIES, "temperature"));
        clearTemperatureTimeseriesFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate clearTemperatureTimeseriesFilterPredicate = new NumericFilterPredicate();
        clearTemperatureTimeseriesFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL);
        FilterPredicateValue clearTemperatureTimeseriesPredicateValue = new FilterPredicateValue((Object)25.0, null, new DynamicValue(DynamicValueSourceType.CURRENT_DEVICE, "temperatureAlarmThreshold"));
        clearTemperatureTimeseriesFilterPredicate.setValue(clearTemperatureTimeseriesPredicateValue);
        clearTemperatureTimeseriesFilter.setPredicate((KeyFilterPredicate)clearTemperatureTimeseriesFilterPredicate);
        clearTemperatureCondition.setCondition(Collections.singletonList(clearTemperatureTimeseriesFilter));
        clearTemperatureRule.setCondition(clearTemperatureCondition);
        clearTemperatureRule.setAlarmDetails("Current temperature = ${temperature}");
        highTemperature.setClearRule(clearTemperatureRule);
        DeviceProfileAlarm lowHumidity = new DeviceProfileAlarm();
        lowHumidity.setId("lowHumidityAlarmID");
        lowHumidity.setAlarmType("Low Humidity");
        AlarmRule humidityRule = new AlarmRule();
        AlarmCondition humidityCondition = new AlarmCondition();
        humidityCondition.setSpec((AlarmConditionSpec)new SimpleAlarmConditionSpec());
        AlarmConditionFilter humidityAlarmFlagAttributeFilter = new AlarmConditionFilter();
        humidityAlarmFlagAttributeFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.ATTRIBUTE, "humidityAlarmFlag"));
        humidityAlarmFlagAttributeFilter.setValueType(EntityKeyValueType.BOOLEAN);
        BooleanFilterPredicate humidityAlarmFlagAttributePredicate = new BooleanFilterPredicate();
        humidityAlarmFlagAttributePredicate.setOperation(BooleanFilterPredicate.BooleanOperation.EQUAL);
        humidityAlarmFlagAttributePredicate.setValue(new FilterPredicateValue((Object)Boolean.TRUE));
        humidityAlarmFlagAttributeFilter.setPredicate((KeyFilterPredicate)humidityAlarmFlagAttributePredicate);
        AlarmConditionFilter humidityTimeseriesFilter = new AlarmConditionFilter();
        humidityTimeseriesFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.TIME_SERIES, "humidity"));
        humidityTimeseriesFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate humidityTimeseriesFilterPredicate = new NumericFilterPredicate();
        humidityTimeseriesFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.LESS);
        FilterPredicateValue humidityTimeseriesPredicateValue = new FilterPredicateValue((Object)60.0, null, new DynamicValue(DynamicValueSourceType.CURRENT_DEVICE, "humidityAlarmThreshold"));
        humidityTimeseriesFilterPredicate.setValue(humidityTimeseriesPredicateValue);
        humidityTimeseriesFilter.setPredicate((KeyFilterPredicate)humidityTimeseriesFilterPredicate);
        humidityCondition.setCondition(Arrays.asList(humidityAlarmFlagAttributeFilter, humidityTimeseriesFilter));
        humidityRule.setCondition(humidityCondition);
        humidityRule.setAlarmDetails("Current humidity = ${humidity}");
        lowHumidity.setCreateRules(new TreeMap<AlarmSeverity, AlarmRule>(Collections.singletonMap(AlarmSeverity.MINOR, humidityRule)));
        AlarmRule clearHumidityRule = new AlarmRule();
        AlarmCondition clearHumidityCondition = new AlarmCondition();
        clearHumidityCondition.setSpec((AlarmConditionSpec)new SimpleAlarmConditionSpec());
        AlarmConditionFilter clearHumidityTimeseriesFilter = new AlarmConditionFilter();
        clearHumidityTimeseriesFilter.setKey(new AlarmConditionFilterKey(AlarmConditionKeyType.TIME_SERIES, "humidity"));
        clearHumidityTimeseriesFilter.setValueType(EntityKeyValueType.NUMERIC);
        NumericFilterPredicate clearHumidityTimeseriesFilterPredicate = new NumericFilterPredicate();
        clearHumidityTimeseriesFilterPredicate.setOperation(NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL);
        FilterPredicateValue clearHumidityTimeseriesPredicateValue = new FilterPredicateValue((Object)60.0, null, new DynamicValue(DynamicValueSourceType.CURRENT_DEVICE, "humidityAlarmThreshold"));
        clearHumidityTimeseriesFilterPredicate.setValue(clearHumidityTimeseriesPredicateValue);
        clearHumidityTimeseriesFilter.setPredicate((KeyFilterPredicate)clearHumidityTimeseriesFilterPredicate);
        clearHumidityCondition.setCondition(Collections.singletonList(clearHumidityTimeseriesFilter));
        clearHumidityRule.setCondition(clearHumidityCondition);
        clearHumidityRule.setAlarmDetails("Current humidity = ${humidity}");
        lowHumidity.setClearRule(clearHumidityRule);
        deviceProfileData.setAlarms(Arrays.asList(highTemperature, lowHumidity));
        DeviceProfile savedThermostatDeviceProfile = this.deviceProfileService.saveDeviceProfile(thermostatDeviceProfile);
        DeviceId t1Id = this.createDevice(demoTenant.getId(), null, savedThermostatDeviceProfile.getId(), "Thermostat T1", "T1_TEST_TOKEN", "Demo device for Thermostats dashboard").getId();
        DeviceId t2Id = this.createDevice(demoTenant.getId(), null, savedThermostatDeviceProfile.getId(), "Thermostat T2", "T2_TEST_TOKEN", "Demo device for Thermostats dashboard").getId();
        this.attributesService.save(demoTenant.getId(), (EntityId)t1Id, AttributeScope.SERVER_SCOPE, Arrays.asList(new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new DoubleDataEntry("latitude", Double.valueOf(37.3948))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new DoubleDataEntry("longitude", Double.valueOf(-122.1503))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry("temperatureAlarmFlag", Boolean.valueOf(true))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry("humidityAlarmFlag", Boolean.valueOf(true))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new LongDataEntry("temperatureAlarmThreshold", Long.valueOf(20L))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new LongDataEntry("humidityAlarmThreshold", Long.valueOf(50L)))));
        this.attributesService.save(demoTenant.getId(), (EntityId)t2Id, AttributeScope.SERVER_SCOPE, Arrays.asList(new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new DoubleDataEntry("latitude", Double.valueOf(37.493801))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new DoubleDataEntry("longitude", Double.valueOf(-121.948769))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry("temperatureAlarmFlag", Boolean.valueOf(true))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry("humidityAlarmFlag", Boolean.valueOf(true))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new LongDataEntry("temperatureAlarmThreshold", Long.valueOf(25L))), new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new LongDataEntry("humidityAlarmThreshold", Long.valueOf(30L)))));
        this.installScripts.loadDashboards(demoTenant.getId(), null);
        this.installScripts.createDefaultTenantDashboards(demoTenant.getId(), null);
    }

    @Override
    public void loadSystemWidgets() throws Exception {
        this.installScripts.loadSystemWidgets();
    }

    private User createUser(Authority authority, TenantId tenantId, CustomerId customerId, String email, String password) {
        User user = new User();
        user.setAuthority(authority);
        user.setEmail(email);
        user.setTenantId(tenantId);
        user.setCustomerId(customerId);
        user = this.userService.saveUser(tenantId, user);
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(TenantId.SYS_TENANT_ID, user.getId());
        userCredentials.setPassword(this.passwordEncoder.encode((CharSequence)password));
        userCredentials.setEnabled(true);
        userCredentials.setActivateToken(null);
        this.userService.saveUserCredentials(TenantId.SYS_TENANT_ID, userCredentials);
        return user;
    }

    private Device createDevice(TenantId tenantId, CustomerId customerId, DeviceProfileId deviceProfileId, String name, String accessToken, String description) {
        Device device = new Device();
        device.setTenantId(tenantId);
        device.setCustomerId(customerId);
        device.setDeviceProfileId(deviceProfileId);
        device.setName(name);
        if (description != null) {
            ObjectNode additionalInfo = JacksonUtil.newObjectNode();
            additionalInfo.put("description", description);
            device.setAdditionalInfo((JsonNode)additionalInfo);
        }
        device = this.deviceService.saveDevice(device);
        this.save(device.getId(), ACTIVITY_STATE, false);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(TenantId.SYS_TENANT_ID, device.getId());
        deviceCredentials.setCredentialsId(accessToken);
        this.deviceCredentialsService.updateDeviceCredentials(TenantId.SYS_TENANT_ID, deviceCredentials);
        return device;
    }

    private void save(DeviceId deviceId, String key, boolean value) {
        if (this.persistActivityToTelemetry) {
            ListenableFuture saveFuture = this.tsService.save(TenantId.SYS_TENANT_ID, (EntityId)deviceId, Collections.singletonList(new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value)))), 0L);
            this.addTsCallback(saveFuture, new TelemetrySaveCallback(deviceId, key, value));
        } else {
            ListenableFuture saveFuture = this.attributesService.save(TenantId.SYS_TENANT_ID, (EntityId)deviceId, AttributeScope.SERVER_SCOPE, (AttributeKvEntry)new BaseAttributeKvEntry((KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value)), System.currentTimeMillis()));
            this.addTsCallback(saveFuture, new TelemetrySaveCallback(deviceId, key, value));
        }
    }

    private <S> void addTsCallback(ListenableFuture<S> saveFuture, final FutureCallback<S> callback) {
        Futures.addCallback(saveFuture, (FutureCallback)new FutureCallback<S>(){

            public void onSuccess(@Nullable S result) {
                callback.onSuccess(result);
            }

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        }, (Executor)this.tsCallBackExecutor);
    }

    @Override
    public void createQueues() {
        Queue sequentialByOriginatorQueue;
        Queue highPriorityQueue;
        Queue mainQueue = this.queueService.findQueueByTenantIdAndName(TenantId.SYS_TENANT_ID, "Main");
        if (mainQueue == null) {
            mainQueue = new Queue();
            mainQueue.setTenantId(TenantId.SYS_TENANT_ID);
            mainQueue.setName("Main");
            mainQueue.setTopic("tb_rule_engine.main");
            mainQueue.setPollInterval(25);
            mainQueue.setPartitions(10);
            mainQueue.setConsumerPerPartition(true);
            mainQueue.setPackProcessingTimeout(2000L);
            SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
            mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
            mainQueueSubmitStrategy.setBatchSize(1000);
            mainQueue.setSubmitStrategy(mainQueueSubmitStrategy);
            ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
            mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
            mainQueueProcessingStrategy.setRetries(3);
            mainQueueProcessingStrategy.setFailurePercentage(0.0);
            mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
            mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
            mainQueue.setProcessingStrategy(mainQueueProcessingStrategy);
            this.queueService.saveQueue(mainQueue);
        }
        if ((highPriorityQueue = this.queueService.findQueueByTenantIdAndName(TenantId.SYS_TENANT_ID, "HighPriority")) == null) {
            highPriorityQueue = new Queue();
            highPriorityQueue.setTenantId(TenantId.SYS_TENANT_ID);
            highPriorityQueue.setName("HighPriority");
            highPriorityQueue.setTopic("tb_rule_engine.hp");
            highPriorityQueue.setPollInterval(25);
            highPriorityQueue.setPartitions(10);
            highPriorityQueue.setConsumerPerPartition(true);
            highPriorityQueue.setPackProcessingTimeout(2000L);
            SubmitStrategy highPriorityQueueSubmitStrategy = new SubmitStrategy();
            highPriorityQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
            highPriorityQueueSubmitStrategy.setBatchSize(100);
            highPriorityQueue.setSubmitStrategy(highPriorityQueueSubmitStrategy);
            ProcessingStrategy highPriorityQueueProcessingStrategy = new ProcessingStrategy();
            highPriorityQueueProcessingStrategy.setType(ProcessingStrategyType.RETRY_FAILED_AND_TIMED_OUT);
            highPriorityQueueProcessingStrategy.setRetries(0);
            highPriorityQueueProcessingStrategy.setFailurePercentage(0.0);
            highPriorityQueueProcessingStrategy.setPauseBetweenRetries(5L);
            highPriorityQueueProcessingStrategy.setMaxPauseBetweenRetries(5L);
            highPriorityQueue.setProcessingStrategy(highPriorityQueueProcessingStrategy);
            this.queueService.saveQueue(highPriorityQueue);
        }
        if ((sequentialByOriginatorQueue = this.queueService.findQueueByTenantIdAndName(TenantId.SYS_TENANT_ID, "SequentialByOriginator")) == null) {
            sequentialByOriginatorQueue = new Queue();
            sequentialByOriginatorQueue.setTenantId(TenantId.SYS_TENANT_ID);
            sequentialByOriginatorQueue.setName("SequentialByOriginator");
            sequentialByOriginatorQueue.setTopic("tb_rule_engine.sq");
            sequentialByOriginatorQueue.setPollInterval(25);
            sequentialByOriginatorQueue.setPartitions(10);
            sequentialByOriginatorQueue.setPackProcessingTimeout(2000L);
            sequentialByOriginatorQueue.setConsumerPerPartition(true);
            SubmitStrategy sequentialByOriginatorQueueSubmitStrategy = new SubmitStrategy();
            sequentialByOriginatorQueueSubmitStrategy.setType(SubmitStrategyType.SEQUENTIAL_BY_ORIGINATOR);
            sequentialByOriginatorQueueSubmitStrategy.setBatchSize(100);
            sequentialByOriginatorQueue.setSubmitStrategy(sequentialByOriginatorQueueSubmitStrategy);
            ProcessingStrategy sequentialByOriginatorQueueProcessingStrategy = new ProcessingStrategy();
            sequentialByOriginatorQueueProcessingStrategy.setType(ProcessingStrategyType.RETRY_FAILED_AND_TIMED_OUT);
            sequentialByOriginatorQueueProcessingStrategy.setRetries(3);
            sequentialByOriginatorQueueProcessingStrategy.setFailurePercentage(0.0);
            sequentialByOriginatorQueueProcessingStrategy.setPauseBetweenRetries(5L);
            sequentialByOriginatorQueueProcessingStrategy.setMaxPauseBetweenRetries(5L);
            sequentialByOriginatorQueue.setProcessingStrategy(sequentialByOriginatorQueueProcessingStrategy);
            this.queueService.saveQueue(sequentialByOriginatorQueue);
        }
    }

    @Override
    public void createDefaultNotificationConfigs() {
        log.info("Creating default notification configs for system admin");
        if (this.notificationTargetService.countNotificationTargetsByTenantId(TenantId.SYS_TENANT_ID) == 0L) {
            this.notificationSettingsService.createDefaultNotificationConfigs(TenantId.SYS_TENANT_ID);
        }
        PageDataIterable tenants = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 500);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4));
        log.info("Creating default notification configs for all tenants");
        AtomicInteger count = new AtomicInteger();
        for (TenantId tenantId : tenants) {
            executor.submit(() -> {
                if (this.notificationTargetService.countNotificationTargetsByTenantId(tenantId) == 0L) {
                    this.notificationSettingsService.createDefaultNotificationConfigs(tenantId);
                    int n = count.incrementAndGet();
                    if (n % 500 == 0) {
                        log.info("{} tenants processed", (Object)n);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void updateDefaultNotificationConfigs(boolean updateTenants) {
        log.info("Updating notification configs...");
        this.notificationSettingsService.updateDefaultNotificationConfigs(TenantId.SYS_TENANT_ID);
        if (updateTenants) {
            PageDataIterable tenants = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 500);
            ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4));
            AtomicInteger count = new AtomicInteger();
            for (TenantId tenantId : tenants) {
                executor.submit(() -> {
                    this.notificationSettingsService.updateDefaultNotificationConfigs(tenantId);
                    int n = count.incrementAndGet();
                    if (n % 500 == 0) {
                        log.info("{} tenants processed", (Object)n);
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    @ConstructorProperties(value={"installScripts", "userService", "adminSettingsService", "tenantService", "tenantProfileService", "customerService", "deviceService", "deviceProfileService", "attributesService", "deviceCredentialsService", "ruleChainService", "tsService", "connectivityConfiguration", "queueService", "jwtSettingsService", "mobileAppDao", "notificationSettingsService", "notificationTargetService"})
    @Generated
    public DefaultSystemDataLoaderService(InstallScripts installScripts, UserService userService, AdminSettingsService adminSettingsService, TenantService tenantService, TenantProfileService tenantProfileService, CustomerService customerService, DeviceService deviceService, DeviceProfileService deviceProfileService, AttributesService attributesService, DeviceCredentialsService deviceCredentialsService, RuleChainService ruleChainService, TimeseriesService tsService, DeviceConnectivityConfiguration connectivityConfiguration, QueueService queueService, JwtSettingsService jwtSettingsService, MobileAppDao mobileAppDao, NotificationSettingsService notificationSettingsService, NotificationTargetService notificationTargetService) {
        this.installScripts = installScripts;
        this.userService = userService;
        this.adminSettingsService = adminSettingsService;
        this.tenantService = tenantService;
        this.tenantProfileService = tenantProfileService;
        this.customerService = customerService;
        this.deviceService = deviceService;
        this.deviceProfileService = deviceProfileService;
        this.attributesService = attributesService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.ruleChainService = ruleChainService;
        this.tsService = tsService;
        this.connectivityConfiguration = connectivityConfiguration;
        this.queueService = queueService;
        this.jwtSettingsService = jwtSettingsService;
        this.mobileAppDao = mobileAppDao;
        this.notificationSettingsService = notificationSettingsService;
        this.notificationTargetService = notificationTargetService;
    }

    @Generated
    public boolean isPersistActivityToTelemetry() {
        return this.persistActivityToTelemetry;
    }

    private static class TelemetrySaveCallback<T>
    implements FutureCallback<T> {
        private final DeviceId deviceId;
        private final String key;
        private final Object value;

        TelemetrySaveCallback(DeviceId deviceId, String key, Object value) {
            this.deviceId = deviceId;
            this.key = key;
            this.value = value;
        }

        public void onSuccess(@Nullable T result) {
            log.trace("[{}] Successfully updated attribute [{}] with value [{}]", new Object[]{this.deviceId, this.key, this.value});
        }

        public void onFailure(Throwable t) {
            log.warn("[{}] Failed to update attribute [{}] with value [{}]", new Object[]{this.deviceId, this.key, this.value, t});
        }
    }
}

