/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.housekeeper.LatestTsDeletionHousekeeperTask;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class LatestTsDeletionTaskProcessor
extends HousekeeperTaskProcessor<LatestTsDeletionHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatestTsDeletionTaskProcessor.class);
    private final TimeseriesService timeseriesService;

    @Override
    public void process(LatestTsDeletionHousekeeperTask task) throws Exception {
        this.wait(this.timeseriesService.removeLatest(task.getTenantId(), task.getEntityId(), List.of(task.getKey())));
        log.debug("[{}][{}][{}] Deleted latest telemetry for key '{}'", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), task.getKey()});
    }

    @Override
    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_LATEST_TS;
    }

    @ConstructorProperties(value={"timeseriesService"})
    @Generated
    public LatestTsDeletionTaskProcessor(TimeseriesService timeseriesService) {
        this.timeseriesService = timeseriesService;
    }
}

