/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.housekeeper.EntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.entity.EntityDaoService;
import org.thingsboard.server.dao.entity.EntityServiceRegistry;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class EntitiesDeletionTaskProcessor
extends HousekeeperTaskProcessor<EntitiesDeletionHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitiesDeletionTaskProcessor.class);
    private final EntityServiceRegistry entityServiceRegistry;

    @Override
    public void process(EntitiesDeletionHousekeeperTask task) throws Exception {
        EntityType entityType = task.getEntityType();
        TenantId tenantId = task.getTenantId();
        EntityDaoService entityService = this.entityServiceRegistry.getServiceByEntityType(entityType);
        for (UUID entityUuid : task.getEntities()) {
            EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)entityUuid);
            entityService.deleteEntity(tenantId, entityId, true);
        }
        log.debug("[{}] Deleted {} {}s", new Object[]{tenantId, task.getEntities().size(), entityType.getNormalName().toLowerCase()});
    }

    @Override
    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_ENTITIES;
    }

    @ConstructorProperties(value={"entityServiceRegistry"})
    @Generated
    public EntitiesDeletionTaskProcessor(EntityServiceRegistry entityServiceRegistry) {
        this.entityServiceRegistry = entityServiceRegistry;
    }
}

