/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.housekeeper.AlarmsDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class AlarmsDeletionTaskProcessor
extends HousekeeperTaskProcessor<AlarmsDeletionHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmsDeletionTaskProcessor.class);
    private final AlarmService alarmService;

    @Override
    public void process(AlarmsDeletionHousekeeperTask task) throws Exception {
        EntityId entityId = task.getEntityId();
        EntityType entityType = entityId.getEntityType();
        TenantId tenantId = task.getTenantId();
        if (task.getAlarms() == null) {
            List alarms;
            AlarmId lastId = null;
            long lastCreatedTime = 0L;
            while (!(alarms = this.alarmService.findAlarmIdsByOriginatorId(tenantId, entityId, lastCreatedTime, lastId, 128)).isEmpty()) {
                this.housekeeperClient.submitTask((HousekeeperTask)new AlarmsDeletionHousekeeperTask(tenantId, entityId, alarms.stream().map(TbPair::getFirst).toList()));
                TbPair last = (TbPair)alarms.get(alarms.size() - 1);
                lastId = new AlarmId((UUID)last.getFirst());
                lastCreatedTime = (Long)last.getSecond();
                log.debug("[{}][{}][{}] Submitted task for deleting {} alarms", new Object[]{tenantId, entityType, entityId, alarms.size()});
            }
            int count = this.alarmService.deleteEntityAlarmRecords(tenantId, entityId);
            log.debug("[{}][{}][{}] Deleted {} entity alarms", new Object[]{tenantId, entityType, entityId, count});
        } else {
            for (UUID alarmId : task.getAlarms()) {
                this.alarmService.delAlarm(tenantId, new AlarmId(alarmId));
            }
            log.debug("[{}][{}][{}] Deleted {} alarms", new Object[]{tenantId, entityType, entityId, task.getAlarms().size()});
        }
    }

    @Override
    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_ALARMS;
    }

    @ConstructorProperties(value={"alarmService"})
    @Generated
    public AlarmsDeletionTaskProcessor(AlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

