/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.gateway_device;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.service.gateway_device.GatewayNotificationsService;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;

@Service
public class DefaultGatewayNotificationsService
implements GatewayNotificationsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGatewayNotificationsService.class);
    private static final String DEVICE_RENAMED_METHOD_NAME = "gateway_device_renamed";
    private static final String DEVICE_DELETED_METHOD_NAME = "gateway_device_deleted";
    private static final Long rpcTimeout = TimeUnit.DAYS.toMillis(1L);
    @Lazy
    @Autowired
    private TbCoreDeviceRpcService deviceRpcService;

    @Override
    public void onDeviceUpdated(Device device, Device oldDevice) {
        Optional<DeviceId> gatewayDeviceId = this.getGatewayDeviceIdFromAdditionalInfoInDevice(device);
        if (gatewayDeviceId.isPresent()) {
            ObjectNode renamedDeviceNode = JacksonUtil.newObjectNode();
            renamedDeviceNode.put(oldDevice.getName(), device.getName());
            ToDeviceRpcRequest rpcRequest = this.formDeviceToGatewayRPCRequest(device.getTenantId(), gatewayDeviceId.get(), (JsonNode)renamedDeviceNode, DEVICE_RENAMED_METHOD_NAME);
            this.deviceRpcService.processRestApiRpcRequest(rpcRequest, fromDeviceRpcResponse -> log.trace("Device renamed RPC with id: [{}] processed to gateway device with id: [{}], old device name: [{}], new device name: [{}]", new Object[]{rpcRequest.getId(), gatewayDeviceId, oldDevice.getName(), device.getName()}), null);
        }
    }

    @Override
    public void onDeviceDeleted(Device device) {
        Optional<DeviceId> gatewayDeviceId = this.getGatewayDeviceIdFromAdditionalInfoInDevice(device);
        if (gatewayDeviceId.isPresent()) {
            TextNode deletedDeviceNode = new TextNode(device.getName());
            ToDeviceRpcRequest rpcRequest = this.formDeviceToGatewayRPCRequest(device.getTenantId(), gatewayDeviceId.get(), (JsonNode)deletedDeviceNode, DEVICE_DELETED_METHOD_NAME);
            this.deviceRpcService.processRestApiRpcRequest(rpcRequest, fromDeviceRpcResponse -> log.trace("Device deleted RPC with id: [{}] processed to gateway device with id: [{}], deleted device name: [{}]", new Object[]{rpcRequest.getId(), gatewayDeviceId, device.getName()}), null);
        }
    }

    private ToDeviceRpcRequest formDeviceToGatewayRPCRequest(TenantId tenantId, DeviceId gatewayDeviceId, JsonNode deviceDataNode, String method) {
        ToDeviceRpcRequestBody body = new ToDeviceRpcRequestBody(method, JacksonUtil.toString((Object)deviceDataNode));
        long expTime = System.currentTimeMillis() + rpcTimeout;
        UUID rpcRequestUUID = UUID.randomUUID();
        return new ToDeviceRpcRequest(rpcRequestUUID, tenantId, gatewayDeviceId, true, expTime, body, true, Integer.valueOf(3), null);
    }

    private Optional<DeviceId> getGatewayDeviceIdFromAdditionalInfoInDevice(Device device) {
        JsonNode deviceAdditionalInfo = device.getAdditionalInfo();
        if (deviceAdditionalInfo != null && deviceAdditionalInfo.has("lastConnectedGateway")) {
            try {
                JsonNode lastConnectedGatewayIdNode = deviceAdditionalInfo.get("lastConnectedGateway");
                return Optional.of(new DeviceId(UUID.fromString(lastConnectedGatewayIdNode.asText())));
            }
            catch (RuntimeException e) {
                log.debug("[{}] Failed to decode connected gateway: {}", (Object)device.getId(), (Object)deviceAdditionalInfo);
            }
        }
        return Optional.empty();
    }

    @Generated
    public DefaultGatewayNotificationsService() {
    }
}

