/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.widgets.type;

import java.beans.ConstructorProperties;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.widgets.type.TbWidgetTypeService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultWidgetTypeService
extends AbstractTbEntityService
implements TbWidgetTypeService {
    private final WidgetTypeService widgetTypeService;
    private final TbResourceService tbResourceService;

    @Override
    public WidgetTypeDetails save(WidgetTypeDetails entity, SecurityUser user) throws Exception {
        return this.save(entity, false, user);
    }

    @Override
    public WidgetTypeDetails save(WidgetTypeDetails widgetTypeDetails, boolean updateExistingByFqn, SecurityUser user) throws Exception {
        WidgetType widgetType;
        TenantId tenantId = widgetTypeDetails.getTenantId();
        if (widgetTypeDetails.getId() == null && StringUtils.isNotEmpty((String)widgetTypeDetails.getFqn()) && updateExistingByFqn && (widgetType = this.widgetTypeService.findWidgetTypeByTenantIdAndFqn(tenantId, widgetTypeDetails.getFqn())) != null) {
            widgetTypeDetails.setId((UUIDBased)widgetType.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)widgetTypeDetails.getResources())) {
            this.tbResourceService.importResources(widgetTypeDetails.getResources(), user);
        }
        ActionType actionType = widgetTypeDetails.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        try {
            WidgetTypeDetails savedWidgetTypeDetails = this.checkNotNull(this.widgetTypeService.saveWidgetType(widgetTypeDetails));
            this.autoCommit(user, (EntityId)savedWidgetTypeDetails.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedWidgetTypeDetails.getId(), savedWidgetTypeDetails, null, actionType, (User)user, new Object[0]);
            return savedWidgetTypeDetails;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.WIDGET_TYPE), widgetTypeDetails, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(WidgetTypeDetails widgetTypeDetails, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = widgetTypeDetails.getTenantId();
        try {
            this.widgetTypeService.deleteWidgetType(widgetTypeDetails.getTenantId(), widgetTypeDetails.getId());
            this.logEntityActionService.logEntityAction(tenantId, widgetTypeDetails.getId(), widgetTypeDetails, null, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.WIDGET_TYPE), actionType, user, e, new Object[]{widgetTypeDetails.getId()});
            throw e;
        }
    }

    @ConstructorProperties(value={"widgetTypeService", "tbResourceService"})
    @Generated
    public DefaultWidgetTypeService(WidgetTypeService widgetTypeService, TbResourceService tbResourceService) {
        this.widgetTypeService = widgetTypeService;
        this.tbResourceService = tbResourceService;
    }
}

