/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.user;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.settings.AbstractUserDashboardInfo;
import org.thingsboard.server.common.data.settings.LastVisitedDashboardInfo;
import org.thingsboard.server.common.data.settings.StarredDashboardInfo;
import org.thingsboard.server.common.data.settings.UserDashboardAction;
import org.thingsboard.server.common.data.settings.UserDashboardsInfo;
import org.thingsboard.server.common.data.settings.UserSettings;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.user.UserSettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.user.TbUserSettingsService;

@Service
@TbCoreComponent
public class DefaultTbUserSettingsService
implements TbUserSettingsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbUserSettingsService.class);
    private static final int MAX_DASHBOARD_INFO_LIST_SIZE = 10;
    private static final Predicate<HasTitle> EMPTY_TITLE = i -> StringUtils.isEmpty((String)i.getTitle());
    private final UserSettingsService settingsService;
    private final DashboardService dashboardService;

    @Override
    public UserSettings saveUserSettings(TenantId tenantId, UserSettings userSettings) {
        return this.settingsService.saveUserSettings(tenantId, userSettings);
    }

    @Override
    public void updateUserSettings(TenantId tenantId, UserId userId, UserSettingsType type, JsonNode settings) {
        this.settingsService.updateUserSettings(tenantId, userId, type, settings);
    }

    @Override
    public UserSettings findUserSettings(TenantId tenantId, UserId userId, UserSettingsType type) {
        return this.settingsService.findUserSettings(tenantId, userId, type);
    }

    @Override
    public void deleteUserSettings(TenantId tenantId, UserId userId, UserSettingsType type, List<String> jsonPaths) {
        this.settingsService.deleteUserSettings(tenantId, userId, type, jsonPaths);
    }

    @Override
    public UserDashboardsInfo findUserDashboardsInfo(TenantId tenantId, UserId id) {
        UserSettings us = this.findUserSettings(tenantId, id, UserSettingsType.VISITED_DASHBOARDS);
        if (us == null) {
            return UserDashboardsInfo.EMPTY;
        }
        UserDashboardsInfo stored = (UserDashboardsInfo)JacksonUtil.convertValue((Object)us.getSettings(), UserDashboardsInfo.class);
        return this.refreshDashboardTitles(tenantId, stored);
    }

    @Override
    public UserDashboardsInfo reportUserDashboardAction(TenantId tenantId, UserId id, DashboardId dashboardId, UserDashboardAction action) {
        UserSettings us = this.findUserSettings(tenantId, id, UserSettingsType.VISITED_DASHBOARDS);
        UserDashboardsInfo stored = null;
        if (us != null) {
            stored = (UserDashboardsInfo)JacksonUtil.convertValue((Object)us.getSettings(), UserDashboardsInfo.class);
        }
        if (stored == null) {
            stored = new UserDashboardsInfo();
        }
        switch (action) {
            case STAR: {
                this.addToStarred(stored, dashboardId);
                break;
            }
            case UNSTAR: {
                this.removeFromStarred(stored, dashboardId);
                break;
            }
            case VISIT: {
                this.addToVisited(stored, dashboardId);
            }
        }
        stored = this.refreshDashboardTitles(tenantId, stored);
        us = new UserSettings();
        us.setUserId(id);
        us.setType(UserSettingsType.VISITED_DASHBOARDS);
        us.setSettings(JacksonUtil.valueToTree((Object)stored));
        this.saveUserSettings(tenantId, us);
        return stored;
    }

    private void addToVisited(UserDashboardsInfo stored, DashboardId dashboardId) {
        UUID id = dashboardId.getId();
        long ts = System.currentTimeMillis();
        Optional<AbstractUserDashboardInfo> opt = stored.getLast().stream().filter(this.filterById(id)).findFirst();
        if (opt.isPresent()) {
            ((LastVisitedDashboardInfo)opt.get()).setLastVisited(ts);
        } else {
            LastVisitedDashboardInfo newInfo = new LastVisitedDashboardInfo();
            newInfo.setId(id);
            newInfo.setStarred(stored.getStarred().stream().anyMatch(this.filterById(id)));
            newInfo.setLastVisited(System.currentTimeMillis());
            stored.getLast().add(newInfo);
        }
        stored.getLast().sort(Comparator.comparing(LastVisitedDashboardInfo::getLastVisited).reversed());
        if (stored.getLast().size() > 10) {
            stored.setLast(stored.getLast().stream().limit(10L).collect(Collectors.toList()));
        }
    }

    private void removeFromStarred(UserDashboardsInfo stored, DashboardId dashboardId) {
        UUID id = dashboardId.getId();
        stored.getStarred().removeIf(this.filterById(id));
        stored.getLast().stream().filter(d -> id.equals(d.getId())).findFirst().ifPresent(d -> d.setStarred(false));
    }

    private void addToStarred(UserDashboardsInfo stored, DashboardId dashboardId) {
        UUID id = dashboardId.getId();
        long ts = System.currentTimeMillis();
        Optional<AbstractUserDashboardInfo> opt = stored.getStarred().stream().filter(this.filterById(id)).findFirst();
        if (opt.isPresent()) {
            ((StarredDashboardInfo)opt.get()).setStarredAt(ts);
        } else {
            StarredDashboardInfo newInfo = new StarredDashboardInfo();
            newInfo.setId(id);
            newInfo.setStarredAt(System.currentTimeMillis());
            stored.getStarred().add(newInfo);
        }
        stored.getStarred().sort(Comparator.comparing(StarredDashboardInfo::getStarredAt).reversed());
        if (stored.getStarred().size() > 10) {
            stored.setStarred(stored.getStarred().stream().limit(10L).collect(Collectors.toList()));
        }
        Set starredMap = stored.getStarred().stream().map(AbstractUserDashboardInfo::getId).collect(Collectors.toSet());
        stored.getLast().forEach(d -> d.setStarred(starredMap.contains(d.getId())));
    }

    private Predicate<AbstractUserDashboardInfo> filterById(UUID id) {
        return d -> id.equals(d.getId());
    }

    private UserDashboardsInfo refreshDashboardTitles(TenantId tenantId, UserDashboardsInfo stored) {
        if (stored == null) {
            return UserDashboardsInfo.EMPTY;
        }
        stored.getLast().forEach(i -> i.setTitle(null));
        stored.getStarred().forEach(i -> i.setTitle(null));
        HashSet uniqueIds = new HashSet();
        stored.getLast().stream().map(AbstractUserDashboardInfo::getId).forEach(uniqueIds::add);
        stored.getStarred().stream().map(AbstractUserDashboardInfo::getId).forEach(uniqueIds::add);
        HashMap dashboardTitles = new HashMap();
        uniqueIds.forEach(id -> {
            String title = this.dashboardService.findDashboardTitleById(tenantId, new DashboardId(id));
            if (StringUtils.isNotEmpty((String)title)) {
                dashboardTitles.put(id, title);
            }
        });
        stored.getLast().forEach(i -> i.setTitle((String)dashboardTitles.get(i.getId())));
        stored.getLast().removeIf(EMPTY_TITLE);
        stored.getStarred().forEach(i -> i.setTitle((String)dashboardTitles.get(i.getId())));
        stored.getStarred().removeIf(EMPTY_TITLE);
        return stored;
    }

    @ConstructorProperties(value={"settingsService", "dashboardService"})
    @Generated
    public DefaultTbUserSettingsService(UserSettingsService settingsService, DashboardService dashboardService) {
        this.settingsService = settingsService;
        this.dashboardService = dashboardService;
    }
}

