/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.tenant.profile;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.queue.TbQueueService;
import org.thingsboard.server.service.entitiy.tenant.profile.TbTenantProfileService;

@Service
@TbCoreComponent
public class DefaultTbTenantProfileService
extends AbstractTbEntityService
implements TbTenantProfileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbTenantProfileService.class);
    private final TbQueueService tbQueueService;
    private final TenantProfileService tenantProfileService;
    private final TenantService tenantService;
    private final TbTenantProfileCache tenantProfileCache;

    @Override
    public TenantProfile save(TenantId tenantId, TenantProfile tenantProfile, TenantProfile oldTenantProfile) throws ThingsboardException {
        TenantProfile savedTenantProfile = this.checkNotNull(this.tenantProfileService.saveTenantProfile(tenantId, tenantProfile));
        this.tenantProfileCache.put(savedTenantProfile);
        List tenantIds = this.tenantService.findTenantIdsByTenantProfileId(savedTenantProfile.getId());
        this.tbQueueService.updateQueuesByTenants(tenantIds, savedTenantProfile, oldTenantProfile);
        return savedTenantProfile;
    }

    @Override
    public void delete(TenantId tenantId, TenantProfile tenantProfile) throws ThingsboardException {
        this.tenantProfileService.deleteTenantProfile(tenantId, tenantProfile.getId());
    }

    @ConstructorProperties(value={"tbQueueService", "tenantProfileService", "tenantService", "tenantProfileCache"})
    @Generated
    public DefaultTbTenantProfileService(TbQueueService tbQueueService, TenantProfileService tenantProfileService, TenantService tenantService, TbTenantProfileCache tenantProfileCache) {
        this.tbQueueService = tbQueueService;
        this.tenantProfileService = tenantProfileService;
        this.tenantService = tenantService;
        this.tenantProfileCache = tenantProfileCache;
    }
}

