/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.tenant;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.queue.TbQueueService;
import org.thingsboard.server.service.entitiy.tenant.TbTenantService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;

@Service
@TbCoreComponent
public class DefaultTbTenantService
extends AbstractTbEntityService
implements TbTenantService {
    private final TenantService tenantService;
    private final TbTenantProfileCache tenantProfileCache;
    private final InstallScripts installScripts;
    private final TbQueueService tbQueueService;
    private final TenantProfileService tenantProfileService;
    private final EntitiesVersionControlService versionControlService;

    @Override
    public Tenant save(Tenant tenant) throws Exception {
        boolean created = tenant.getId() == null;
        Tenant oldTenant = !created ? this.tenantService.findTenantById(tenant.getId()) : null;
        Tenant savedTenant = this.tenantService.saveTenant(tenant, tenantId -> {
            this.installScripts.createDefaultRuleChains((TenantId)tenantId);
            this.installScripts.createDefaultEdgeRuleChains((TenantId)tenantId);
            if (!this.isTestProfile()) {
                this.installScripts.createDefaultTenantDashboards((TenantId)tenantId, null);
            }
        });
        this.tenantProfileCache.evict(savedTenant.getId());
        TenantProfile oldTenantProfile = oldTenant != null ? this.tenantProfileService.findTenantProfileById(TenantId.SYS_TENANT_ID, oldTenant.getTenantProfileId()) : null;
        TenantProfile newTenantProfile = this.tenantProfileService.findTenantProfileById(TenantId.SYS_TENANT_ID, savedTenant.getTenantProfileId());
        this.tbQueueService.updateQueuesByTenants(Collections.singletonList(savedTenant.getTenantId()), newTenantProfile, oldTenantProfile);
        return savedTenant;
    }

    @Override
    public void delete(Tenant tenant) throws Exception {
        TenantId tenantId = tenant.getId();
        this.tenantService.deleteTenant(tenantId);
        this.tenantProfileCache.evict(tenantId);
        this.versionControlService.deleteVersionControlSettings(tenantId).get(1L, TimeUnit.MINUTES);
    }

    @ConstructorProperties(value={"tenantService", "tenantProfileCache", "installScripts", "tbQueueService", "tenantProfileService", "versionControlService"})
    @Generated
    public DefaultTbTenantService(TenantService tenantService, TbTenantProfileCache tenantProfileCache, InstallScripts installScripts, TbQueueService tbQueueService, TenantProfileService tenantProfileService, EntitiesVersionControlService versionControlService) {
        this.tenantService = tenantService;
        this.tenantProfileCache = tenantProfileCache;
        this.installScripts = installScripts;
        this.tbQueueService = tbQueueService;
        this.tenantProfileService = tenantProfileService;
        this.versionControlService = versionControlService;
    }
}

