/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.ota;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.SaveOtaPackageInfoRequest;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.ota.TbOtaPackageService;

@Service
@TbCoreComponent
public class DefaultTbOtaPackageService
extends AbstractTbEntityService
implements TbOtaPackageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbOtaPackageService.class);
    private final OtaPackageService otaPackageService;

    @Override
    public OtaPackageInfo save(SaveOtaPackageInfoRequest saveOtaPackageInfoRequest, User user) throws ThingsboardException {
        ActionType actionType = saveOtaPackageInfoRequest.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = saveOtaPackageInfoRequest.getTenantId();
        try {
            OtaPackageInfo savedOtaPackageInfo = this.otaPackageService.saveOtaPackageInfo(new OtaPackageInfo((OtaPackageInfo)saveOtaPackageInfoRequest), saveOtaPackageInfoRequest.isUsesUrl());
            this.logEntityActionService.logEntityAction(tenantId, savedOtaPackageInfo.getId(), savedOtaPackageInfo, null, actionType, user, new Object[0]);
            return savedOtaPackageInfo;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.OTA_PACKAGE), saveOtaPackageInfoRequest, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public OtaPackageInfo saveOtaPackageData(OtaPackageInfo otaPackageInfo, String checksum, ChecksumAlgorithm checksumAlgorithm, byte[] data, String filename, String contentType, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UPDATED;
        TenantId tenantId = otaPackageInfo.getTenantId();
        OtaPackageId otaPackageId = otaPackageInfo.getId();
        try {
            if (StringUtils.isEmpty((String)checksum)) {
                checksum = this.otaPackageService.generateChecksum(checksumAlgorithm, ByteBuffer.wrap(data));
            }
            OtaPackage otaPackage = new OtaPackage(otaPackageId);
            otaPackage.setCreatedTime(otaPackageInfo.getCreatedTime());
            otaPackage.setTenantId(tenantId);
            otaPackage.setDeviceProfileId(otaPackageInfo.getDeviceProfileId());
            otaPackage.setType(otaPackageInfo.getType());
            otaPackage.setTitle(otaPackageInfo.getTitle());
            otaPackage.setVersion(otaPackageInfo.getVersion());
            otaPackage.setTag(otaPackageInfo.getTag());
            otaPackage.setAdditionalInfo(otaPackageInfo.getAdditionalInfo());
            otaPackage.setChecksumAlgorithm(checksumAlgorithm);
            otaPackage.setChecksum(checksum);
            otaPackage.setFileName(filename);
            otaPackage.setContentType(contentType);
            otaPackage.setData(ByteBuffer.wrap(data));
            otaPackage.setDataSize(Long.valueOf(data.length));
            OtaPackageInfo savedOtaPackage = new OtaPackageInfo((OtaPackageInfo)this.otaPackageService.saveOtaPackage(otaPackage));
            this.logEntityActionService.logEntityAction(tenantId, savedOtaPackage.getId(), savedOtaPackage, null, actionType, user, new Object[0]);
            return savedOtaPackage;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.OTA_PACKAGE), actionType, user, e, new Object[]{otaPackageId.toString()});
            throw e;
        }
    }

    @Override
    public void delete(OtaPackageInfo otaPackageInfo, User user) throws ThingsboardException {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = otaPackageInfo.getTenantId();
        OtaPackageId otaPackageId = otaPackageInfo.getId();
        try {
            this.otaPackageService.deleteOtaPackage(tenantId, otaPackageId);
            this.logEntityActionService.logEntityAction(tenantId, otaPackageId, otaPackageInfo, null, actionType, user, otaPackageInfo.getId().toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.OTA_PACKAGE), actionType, user, e, new Object[]{otaPackageId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"otaPackageService"})
    @Generated
    public DefaultTbOtaPackageService(OtaPackageService otaPackageService) {
        this.otaPackageService = otaPackageService;
    }
}

