/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.entityview;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesDeleteRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@Service
public class DefaultTbEntityViewService
extends AbstractTbEntityService
implements TbEntityViewService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbEntityViewService.class);
    private final EntityViewService entityViewService;
    private final AttributesService attributesService;
    private final TelemetrySubscriptionService tsSubService;
    private final TimeseriesService tsService;
    final Map<TenantId, Map<EntityId, List<EntityView>>> localCache = new ConcurrentHashMap<TenantId, Map<EntityId, List<EntityView>>>();

    @Override
    public EntityView save(EntityView entityView, EntityView existingEntityView, User user) throws Exception {
        ActionType actionType = entityView.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = entityView.getTenantId();
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.saveEntityView(entityView));
            this.updateEntityViewAttributes(tenantId, savedEntityView, existingEntityView, user);
            this.autoCommit(user, (EntityId)savedEntityView.getId());
            this.logEntityActionService.logEntityAction(savedEntityView.getTenantId(), savedEntityView.getId(), savedEntityView, null, actionType, user, new Object[0]);
            this.localCache.computeIfAbsent(savedEntityView.getTenantId(), k -> new ConcurrentReferenceHashMap()).clear();
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(user.getTenantId(), this.emptyId(EntityType.ENTITY_VIEW), entityView, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void updateEntityViewAttributes(TenantId tenantId, EntityView savedEntityView, EntityView oldEntityView, User user) throws ThingsboardException {
        ArrayList<Object> futures = new ArrayList<Object>();
        if (oldEntityView != null) {
            if (oldEntityView.getKeys() != null && oldEntityView.getKeys().getAttributes() != null) {
                futures.add(this.deleteAttributesFromEntityView(oldEntityView, AttributeScope.CLIENT_SCOPE, oldEntityView.getKeys().getAttributes().getCs(), user));
                futures.add(this.deleteAttributesFromEntityView(oldEntityView, AttributeScope.SERVER_SCOPE, oldEntityView.getKeys().getAttributes().getSs(), user));
                futures.add(this.deleteAttributesFromEntityView(oldEntityView, AttributeScope.SHARED_SCOPE, oldEntityView.getKeys().getAttributes().getSh(), user));
            }
            List tsKeys = oldEntityView.getKeys() != null && oldEntityView.getKeys().getTimeseries() != null ? oldEntityView.getKeys().getTimeseries() : Collections.emptyList();
            futures.add(this.deleteLatestFromEntityView(oldEntityView, tsKeys, user));
        }
        if (savedEntityView.getKeys() != null) {
            if (savedEntityView.getKeys().getAttributes() != null) {
                futures.add(this.copyAttributesFromEntityToEntityView(savedEntityView, AttributeScope.CLIENT_SCOPE, savedEntityView.getKeys().getAttributes().getCs(), user));
                futures.add(this.copyAttributesFromEntityToEntityView(savedEntityView, AttributeScope.SERVER_SCOPE, savedEntityView.getKeys().getAttributes().getSs(), user));
                futures.add(this.copyAttributesFromEntityToEntityView(savedEntityView, AttributeScope.SHARED_SCOPE, savedEntityView.getKeys().getAttributes().getSh(), user));
            }
            futures.add(this.copyLatestFromEntityToEntityView(tenantId, savedEntityView));
        }
        for (ListenableFuture listenableFuture : futures) {
            try {
                listenableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to copy attributes to entity view", e);
            }
        }
    }

    @Override
    public void delete(EntityView entityView, User user) throws ThingsboardException {
        TenantId tenantId = entityView.getTenantId();
        EntityViewId entityViewId = entityView.getId();
        try {
            this.entityViewService.deleteEntityView(tenantId, entityViewId);
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, entityView, entityView.getCustomerId(), ActionType.DELETED, user, entityViewId.toString());
            this.localCache.computeIfAbsent(tenantId, k -> new ConcurrentReferenceHashMap()).clear();
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), ActionType.DELETED, user, e, new Object[]{entityViewId.toString()});
            throw e;
        }
    }

    @Override
    public EntityView assignEntityViewToCustomer(TenantId tenantId, EntityViewId entityViewId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        CustomerId customerId = customer.getId();
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.assignEntityViewToCustomer(tenantId, entityViewId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, savedEntityView, savedEntityView.getCustomerId(), actionType, user, (Object)entityViewId.toString(), (Object)customerId.toString(), (Object)customer.getName());
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), actionType, user, e, new Object[]{entityViewId.toString(), customerId.toString()});
            throw e;
        }
    }

    @Override
    public EntityView unassignEntityViewFromCustomer(TenantId tenantId, EntityViewId entityViewId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.unassignEntityViewFromCustomer(tenantId, entityViewId));
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, savedEntityView, customer.getId(), actionType, user, (Object)savedEntityView.getId().toString(), (Object)customer.getId().toString(), (Object)customer.getName());
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), actionType, user, e, new Object[]{entityViewId.toString()});
            throw e;
        }
    }

    @Override
    public EntityView assignEntityViewToPublicCustomer(TenantId tenantId, EntityViewId entityViewId, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.assignEntityViewToCustomer(tenantId, entityViewId, publicCustomer.getId()));
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, savedEntityView, savedEntityView.getCustomerId(), actionType, user, (Object)savedEntityView.getId().toString(), (Object)publicCustomer.getId().toString(), (Object)publicCustomer.getName());
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), actionType, user, e, new Object[]{entityViewId.toString()});
            throw e;
        }
    }

    @Override
    public EntityView assignEntityViewToEdge(TenantId tenantId, CustomerId customerId, EntityViewId entityViewId, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        EdgeId edgeId = edge.getId();
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.assignEntityViewToEdge(tenantId, entityViewId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, savedEntityView, customerId, actionType, user, (Object)savedEntityView.getEntityId().toString(), (Object)edgeId.toString(), (Object)edge.getName());
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), actionType, user, e, new Object[]{entityViewId.toString(), edgeId.toString()});
            throw e;
        }
    }

    @Override
    public EntityView unassignEntityViewFromEdge(TenantId tenantId, CustomerId customerId, EntityView entityView, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        EntityViewId entityViewId = entityView.getId();
        EdgeId edgeId = edge.getId();
        try {
            EntityView savedEntityView = this.checkNotNull(this.entityViewService.unassignEntityViewFromEdge(tenantId, entityViewId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, entityViewId, savedEntityView, customerId, actionType, user, (Object)entityViewId.toString(), (Object)edgeId.toString(), (Object)edge.getName());
            return savedEntityView;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_VIEW), actionType, user, e, new Object[]{entityViewId.toString(), edgeId.toString()});
            throw e;
        }
    }

    @Override
    public ListenableFuture<List<EntityView>> findEntityViewsByTenantIdAndEntityIdAsync(TenantId tenantId, EntityId entityId) {
        Map localCacheByTenant = this.localCache.computeIfAbsent(tenantId, k -> new ConcurrentReferenceHashMap());
        List fromLocalCache = (List)localCacheByTenant.get(entityId);
        if (fromLocalCache != null) {
            return Futures.immediateFuture((Object)fromLocalCache);
        }
        ListenableFuture future = this.entityViewService.findEntityViewsByTenantIdAndEntityIdAsync(tenantId, entityId);
        return Futures.transform((ListenableFuture)future, entityViewList -> {
            localCacheByTenant.put(entityId, entityViewList);
            return entityViewList;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void onComponentLifecycleMsg(ComponentLifecycleMsg componentLifecycleMsg) {
        EntityView entityView;
        Map localCacheByTenant = this.localCache.computeIfAbsent(componentLifecycleMsg.getTenantId(), k -> new ConcurrentReferenceHashMap());
        EntityViewId entityViewId = new EntityViewId(componentLifecycleMsg.getEntityId().getId());
        this.deleteOldCacheValue(localCacheByTenant, entityViewId);
        if (componentLifecycleMsg.getEvent() != ComponentLifecycleEvent.DELETED && (entityView = this.entityViewService.findEntityViewById(componentLifecycleMsg.getTenantId(), entityViewId)) != null) {
            localCacheByTenant.remove(entityView.getEntityId());
        }
    }

    private void deleteOldCacheValue(Map<EntityId, List<EntityView>> localCacheByTenant, EntityViewId entityViewId) {
        for (Map.Entry<EntityId, List<EntityView>> entry : localCacheByTenant.entrySet()) {
            EntityView toDelete = null;
            for (EntityView view : entry.getValue()) {
                if (!entityViewId.equals((Object)view.getId())) continue;
                toDelete = view;
                break;
            }
            if (toDelete == null) continue;
            entry.getValue().remove(toDelete);
            break;
        }
    }

    private ListenableFuture<List<Void>> copyAttributesFromEntityToEntityView(final EntityView entityView, final AttributeScope scope, Collection<String> keys, final User user) throws ThingsboardException {
        final EntityViewId entityId = entityView.getId();
        if (keys != null && !keys.isEmpty()) {
            ListenableFuture getAttrFuture = this.attributesService.find(entityView.getTenantId(), entityView.getEntityId(), scope, keys);
            return Futures.transform((ListenableFuture)getAttrFuture, attributeKvEntries -> {
                if (attributeKvEntries != null && !attributeKvEntries.isEmpty()) {
                    final List attributes = attributeKvEntries.stream().filter(attributeKvEntry -> {
                        long startTime = entityView.getStartTimeMs();
                        long endTime = entityView.getEndTimeMs();
                        long lastUpdateTs = attributeKvEntry.getLastUpdateTs();
                        return startTime == 0L && endTime == 0L || endTime == 0L && startTime < lastUpdateTs || startTime == 0L && endTime > lastUpdateTs || startTime < lastUpdateTs && endTime > lastUpdateTs;
                    }).collect(Collectors.toList());
                    this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(entityView.getTenantId()).entityId((EntityId)entityId).scope(scope).entries(attributes).callback((FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void tmp) {
                            try {
                                DefaultTbEntityViewService.this.logAttributesUpdated(entityView.getTenantId(), user, (EntityId)entityId, scope, attributes, null);
                            }
                            catch (ThingsboardException e) {
                                log.error("Failed to log attribute updates", (Throwable)e);
                            }
                        }

                        public void onFailure(Throwable t) {
                            try {
                                DefaultTbEntityViewService.this.logAttributesUpdated(entityView.getTenantId(), user, (EntityId)entityId, scope, attributes, t);
                            }
                            catch (ThingsboardException e) {
                                log.error("Failed to log attribute updates", (Throwable)e);
                            }
                        }
                    }).build());
                }
                return null;
            }, (Executor)MoreExecutors.directExecutor());
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<List<Void>> copyLatestFromEntityToEntityView(final TenantId tenantId, final EntityView entityView) {
        EntityViewId entityId = entityView.getId();
        List keys = entityView.getKeys() != null && entityView.getKeys().getTimeseries() != null ? entityView.getKeys().getTimeseries() : Collections.emptyList();
        long startTs = entityView.getStartTimeMs();
        long endTs = entityView.getEndTimeMs() == 0L ? Long.MAX_VALUE : entityView.getEndTimeMs();
        ListenableFuture keysFuture = keys.isEmpty() ? Futures.transform((ListenableFuture)this.tsService.findAllLatest(tenantId, entityView.getEntityId()), latest -> latest.stream().map(KvEntry::getKey).collect(Collectors.toList()), (Executor)MoreExecutors.directExecutor()) : Futures.immediateFuture((Object)keys);
        ListenableFuture latestFuture = Futures.transformAsync((ListenableFuture)keysFuture, fetchKeys -> {
            List queries = fetchKeys.stream().filter(key -> !StringUtils.isBlank((String)key)).map(key -> new BaseReadTsKvQuery(key, startTs, endTs, 1, "DESC")).collect(Collectors.toList());
            if (!queries.isEmpty()) {
                return this.tsService.findAll(tenantId, entityView.getEntityId(), queries);
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transform((ListenableFuture)latestFuture, latestValues -> {
            if (latestValues != null && !latestValues.isEmpty()) {
                this.tsSubService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(entityView.getTenantId()).entityId((EntityId)entityId).entries(latestValues).strategy(TimeseriesSaveRequest.Strategy.LATEST_AND_WS).callback((FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void tmp) {
                    }

                    public void onFailure(Throwable t) {
                        log.error("[{}][{}] Failed to save entity view latest timeseries: {}", new Object[]{tenantId, entityView.getId(), latestValues, t});
                    }
                }).build());
            }
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Void> deleteAttributesFromEntityView(final EntityView entityView, final AttributeScope scope, final List<String> keys, final User user) {
        final EntityViewId entityId = entityView.getId();
        final SettableFuture resultFuture = SettableFuture.create();
        if (keys != null && !keys.isEmpty()) {
            this.tsSubService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(entityView.getTenantId()).entityId((EntityId)entityId).scope(scope).keys(keys).callback((FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void tmp) {
                    try {
                        DefaultTbEntityViewService.this.logAttributesDeleted(entityView.getTenantId(), user, (EntityId)entityId, scope, keys, null);
                    }
                    catch (ThingsboardException e) {
                        log.error("Failed to log attribute delete", (Throwable)e);
                    }
                    resultFuture.set((Object)tmp);
                }

                public void onFailure(Throwable t) {
                    try {
                        DefaultTbEntityViewService.this.logAttributesDeleted(entityView.getTenantId(), user, (EntityId)entityId, scope, keys, t);
                    }
                    catch (ThingsboardException e) {
                        log.error("Failed to log attribute delete", (Throwable)e);
                    }
                    resultFuture.setException(t);
                }
            }).build());
        } else {
            resultFuture.set(null);
        }
        return resultFuture;
    }

    private ListenableFuture<Void> deleteLatestFromEntityView(final EntityView entityView, final List<String> keys, final User user) {
        final EntityViewId entityId = entityView.getId();
        final SettableFuture resultFuture = SettableFuture.create();
        this.tsSubService.deleteTimeseries(TimeseriesDeleteRequest.builder().tenantId(entityView.getTenantId()).entityId((EntityId)entityId).keys(keys).callback((FutureCallback)new FutureCallback<List<String>>(){

            public void onSuccess(@Nullable List<String> result) {
                try {
                    DefaultTbEntityViewService.this.logTimeseriesDeleted(entityView.getTenantId(), user, (EntityId)entityId, result, null);
                }
                catch (ThingsboardException e) {
                    log.error("Failed to log timeseries delete", (Throwable)e);
                }
                resultFuture.set(null);
            }

            public void onFailure(Throwable t) {
                try {
                    DefaultTbEntityViewService.this.logTimeseriesDeleted(entityView.getTenantId(), user, (EntityId)entityId, Optional.ofNullable(keys).orElse(Collections.emptyList()), t);
                }
                catch (ThingsboardException e) {
                    log.error("Failed to log timeseries delete", (Throwable)e);
                }
                resultFuture.setException(t);
            }
        }).build());
        return resultFuture;
    }

    private void logAttributesUpdated(TenantId tenantId, User user, EntityId entityId, AttributeScope scope, List<AttributeKvEntry> attributes, Throwable e) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(tenantId, entityId, ActionType.ATTRIBUTES_UPDATED, user, DefaultTbEntityViewService.toException(e), scope, attributes);
    }

    private void logAttributesDeleted(TenantId tenantId, User user, EntityId entityId, AttributeScope scope, List<String> keys, Throwable e) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(tenantId, entityId, ActionType.ATTRIBUTES_DELETED, user, DefaultTbEntityViewService.toException(e), scope, keys);
    }

    private void logTimeseriesDeleted(TenantId tenantId, User user, EntityId entityId, List<String> keys, Throwable e) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(tenantId, entityId, ActionType.TIMESERIES_DELETED, user, DefaultTbEntityViewService.toException(e), keys);
    }

    public static Exception toException(Throwable error) {
        return error != null ? (Exception.class.isInstance(error) ? (Exception)error : new Exception(error)) : null;
    }

    @ConstructorProperties(value={"entityViewService", "attributesService", "tsSubService", "tsService"})
    @Generated
    public DefaultTbEntityViewService(EntityViewService entityViewService, AttributesService attributesService, TelemetrySubscriptionService tsSubService, TimeseriesService tsService) {
        this.entityViewService = entityViewService;
        this.attributesService = attributesService;
        this.tsSubService = tsSubService;
        this.tsService = tsService;
    }
}

