/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.device.profile;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.device.profile.TbDeviceProfileService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultTbDeviceProfileService
extends AbstractTbEntityService
implements TbDeviceProfileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbDeviceProfileService.class);
    private final DeviceProfileService deviceProfileService;

    @Override
    public DeviceProfile save(DeviceProfile deviceProfile, SecurityUser user) throws Exception {
        ActionType actionType = deviceProfile.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = deviceProfile.getTenantId();
        try {
            DeviceProfile savedDeviceProfile = this.checkNotNull(this.deviceProfileService.saveDeviceProfile(deviceProfile));
            this.autoCommit(user, (EntityId)savedDeviceProfile.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedDeviceProfile.getId(), savedDeviceProfile, null, actionType, (User)user, new Object[0]);
            return savedDeviceProfile;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE_PROFILE), deviceProfile, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(DeviceProfile deviceProfile, User user) {
        ActionType actionType = ActionType.DELETED;
        DeviceProfileId deviceProfileId = deviceProfile.getId();
        TenantId tenantId = deviceProfile.getTenantId();
        try {
            this.deviceProfileService.deleteDeviceProfile(tenantId, deviceProfileId);
            this.logEntityActionService.logEntityAction(tenantId, deviceProfileId, deviceProfile, null, actionType, user, deviceProfileId.toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE_PROFILE), actionType, user, e, new Object[]{deviceProfileId.toString()});
            throw e;
        }
    }

    @Override
    public DeviceProfile setDefaultDeviceProfile(DeviceProfile deviceProfile, DeviceProfile previousDefaultDeviceProfile, User user) throws ThingsboardException {
        TenantId tenantId = deviceProfile.getTenantId();
        DeviceProfileId deviceProfileId = deviceProfile.getId();
        try {
            if (this.deviceProfileService.setDefaultDeviceProfile(tenantId, deviceProfileId)) {
                if (previousDefaultDeviceProfile != null) {
                    previousDefaultDeviceProfile = this.deviceProfileService.findDeviceProfileById(tenantId, previousDefaultDeviceProfile.getId());
                    this.logEntityActionService.logEntityAction(tenantId, previousDefaultDeviceProfile.getId(), previousDefaultDeviceProfile, ActionType.UPDATED, user, new Object[0]);
                }
                deviceProfile = this.deviceProfileService.findDeviceProfileById(tenantId, deviceProfileId);
                this.logEntityActionService.logEntityAction(tenantId, deviceProfileId, deviceProfile, ActionType.UPDATED, user, new Object[0]);
            }
            return deviceProfile;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE_PROFILE), ActionType.UPDATED, user, e, new Object[]{deviceProfileId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"deviceProfileService"})
    @Generated
    public DefaultTbDeviceProfileService(DeviceProfileService deviceProfileService) {
        this.deviceProfileService = deviceProfileService;
    }
}

