/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.dashboard;

import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.install.ProjectInfo;
import org.thingsboard.server.service.sync.GitSyncService;
import org.thingsboard.server.service.sync.vc.GitRepository;

@Service
@TbCoreComponent
@ConditionalOnProperty(value={"transport.gateway.dashboard.sync.enabled"}, havingValue="true")
public class DashboardSyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardSyncService.class);
    private final GitSyncService gitSyncService;
    private final ResourceService resourceService;
    private final ImageService imageService;
    private final WidgetsBundleService widgetsBundleService;
    private final PartitionService partitionService;
    private final ProjectInfo projectInfo;
    @Value(value="${transport.gateway.dashboard.sync.repository_url:}")
    private String repoUrl;
    @Value(value="${transport.gateway.dashboard.sync.branch:}")
    private String branch;
    @Value(value="${transport.gateway.dashboard.sync.fetch_frequency:24}")
    private int fetchFrequencyHours;
    private static final String REPO_KEY = "gateways-dashboard";
    private static final String GATEWAYS_DASHBOARD_KEY = "gateways_dashboard.json";

    @AfterStartUp(order=11)
    public void init() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.branch)) {
            this.branch = "release/" + this.projectInfo.getProjectVersion();
        }
        this.gitSyncService.registerSync(REPO_KEY, this.repoUrl, this.branch, TimeUnit.HOURS.toMillis(this.fetchFrequencyHours), this::update);
    }

    private void update() {
        if (!this.partitionService.isMyPartition(ServiceType.TB_CORE, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID)) {
            return;
        }
        List<GitRepository.RepoFile> resources = this.listFiles("resources");
        for (GitRepository.RepoFile repoFile : resources) {
            byte[] data = this.getFileContent(repoFile.path());
            this.resourceService.createOrUpdateSystemResource(ResourceType.JS_MODULE, ResourceSubType.EXTENSION, repoFile.name(), data);
        }
        List<GitRepository.RepoFile> images = this.listFiles("images");
        for (GitRepository.RepoFile imageFile : images) {
            byte[] data = this.getFileContent(imageFile.path());
            this.imageService.createOrUpdateSystemImage(imageFile.name(), data);
        }
        Stream<String> stream = this.listFiles("widget_bundles").stream().map(widgetsBundleFile -> new String(this.getFileContent(widgetsBundleFile.path()), StandardCharsets.UTF_8));
        Stream<String> widgetTypes = this.listFiles("widget_types").stream().map(widgetTypeFile -> new String(this.getFileContent(widgetTypeFile.path()), StandardCharsets.UTF_8));
        this.widgetsBundleService.updateSystemWidgets(stream, widgetTypes);
        GitRepository.RepoFile dashboardFile = this.listFiles("dashboards").get(0);
        this.resourceService.createOrUpdateSystemResource(ResourceType.DASHBOARD, null, GATEWAYS_DASHBOARD_KEY, this.getFileContent(dashboardFile.path()));
        log.info("Gateways dashboard sync completed");
    }

    private List<GitRepository.RepoFile> listFiles(String path) {
        return this.gitSyncService.listFiles(REPO_KEY, path, 1, GitRepository.FileType.FILE);
    }

    private byte[] getFileContent(String path) {
        return this.gitSyncService.getFileContent(REPO_KEY, path);
    }

    @ConstructorProperties(value={"gitSyncService", "resourceService", "imageService", "widgetsBundleService", "partitionService", "projectInfo"})
    @Generated
    public DashboardSyncService(GitSyncService gitSyncService, ResourceService resourceService, ImageService imageService, WidgetsBundleService widgetsBundleService, PartitionService partitionService, ProjectInfo projectInfo) {
        this.gitSyncService = gitSyncService;
        this.resourceService = resourceService;
        this.imageService = imageService;
        this.widgetsBundleService = widgetsBundleService;
        this.partitionService = partitionService;
        this.projectInfo = projectInfo;
    }
}

