/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.customer;

import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.customer.TbCustomerService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
public class DefaultTbCustomerService
extends AbstractTbEntityService
implements TbCustomerService {
    @Override
    public Customer save(Customer customer, SecurityUser user) throws Exception {
        ActionType actionType = customer.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = customer.getTenantId();
        try {
            Customer savedCustomer = this.checkNotNull(this.customerService.saveCustomer(customer));
            this.autoCommit(user, (EntityId)savedCustomer.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedCustomer.getId(), savedCustomer, null, actionType, (User)user, new Object[0]);
            return savedCustomer;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CUSTOMER), customer, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(Customer customer, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = customer.getTenantId();
        CustomerId customerId = customer.getId();
        try {
            this.customerService.deleteCustomer(tenantId, customerId);
            this.logEntityActionService.logEntityAction(tenantId, customer.getId(), customer, customerId, actionType, user, customerId.toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CUSTOMER), actionType, user, e, new Object[]{customerId.toString()});
            throw e;
        }
    }

    @Generated
    public DefaultTbCustomerService() {
    }
}

