/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.telemetry;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.transport.util.JsonUtils;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.gen.edge.v1.AttributeDeleteMsg;
import org.thingsboard.server.gen.edge.v1.EntityDataProto;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class BaseTelemetryProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTelemetryProcessor.class);
    @Autowired
    private PartitionService partitionService;
    @Autowired
    private TelemetrySubscriptionService tsSubService;
    @Autowired
    private TbDeviceProfileCache deviceProfileCache;
    @Autowired
    private TbAssetProfileCache assetProfileCache;
    @Lazy
    @Autowired
    private TbQueueProducerProvider producerProvider;
    private final Gson gson = new Gson();
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> tbCoreMsgProducer;

    @PostConstruct
    public void init() {
        this.tbCoreMsgProducer = this.producerProvider.getTbCoreMsgProducer();
    }

    protected abstract String getMsgSourceKey();

    public List<ListenableFuture<Void>> processTelemetryMsg(TenantId tenantId, EntityDataProto entityData) throws Exception {
        log.trace("[{}] processTelemetryMsg [{}]", (Object)tenantId, (Object)entityData);
        ArrayList<ListenableFuture<Void>> result = new ArrayList<ListenableFuture<Void>>();
        EntityId entityId = this.constructEntityId(entityData.getEntityType(), entityData.getEntityIdMSB(), entityData.getEntityIdLSB());
        if (entityId != null && this.isEntityExists(tenantId, entityId)) {
            if (entityData.hasPostAttributesMsg() || entityData.hasPostTelemetryMsg() || entityData.hasAttributesUpdatedMsg()) {
                long ts;
                Pair<TbMsgMetaData, CustomerId> pair = this.getBaseMsgMetadataAndCustomerId(tenantId, entityId);
                TbMsgMetaData metaData = (TbMsgMetaData)pair.getKey();
                CustomerId customerId = (CustomerId)pair.getValue();
                metaData.putValue("source", this.getMsgSourceKey());
                if (entityData.hasPostAttributesMsg()) {
                    metaData.putValue("scope", entityData.getPostAttributeScope());
                    ts = entityData.hasAttributeTs() ? entityData.getAttributeTs() : System.currentTimeMillis();
                    result.add(this.processPostAttributes(tenantId, customerId, entityId, entityData.getPostAttributesMsg(), metaData, ts));
                }
                if (entityData.hasAttributesUpdatedMsg()) {
                    metaData.putValue("scope", entityData.getPostAttributeScope());
                    ts = entityData.hasAttributeTs() ? entityData.getAttributeTs() : System.currentTimeMillis();
                    result.add(this.processAttributesUpdate(tenantId, customerId, entityId, entityData.getAttributesUpdatedMsg(), metaData, ts));
                }
                if (entityData.hasPostTelemetryMsg()) {
                    result.add(this.processPostTelemetry(tenantId, customerId, entityId, entityData.getPostTelemetryMsg(), metaData));
                }
                if (EntityType.DEVICE.equals((Object)entityId.getEntityType())) {
                    DeviceId deviceId = new DeviceId(entityId.getId());
                    long currentTs = System.currentTimeMillis();
                    TransportProtos.DeviceActivityProto deviceActivityMsg = TransportProtos.DeviceActivityProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setLastActivityTime(currentTs).build();
                    log.trace("[{}][{}] device activity time is going to be updated, ts {}", new Object[]{tenantId, deviceId, currentTs});
                    TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)deviceId);
                    this.tbCoreMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(deviceId.getId(), (GeneratedMessageV3)TransportProtos.ToCoreMsg.newBuilder().setDeviceActivityMsg(deviceActivityMsg).build()), null);
                }
            }
            if (entityData.hasAttributeDeleteMsg()) {
                result.add(this.processAttributeDeleteMsg(tenantId, entityId, entityData.getAttributeDeleteMsg(), entityData.getEntityType()));
            }
        } else {
            log.warn("[{}] Skipping telemetry update msg because entity doesn't exists on edge, {}", (Object)tenantId, (Object)entityData);
        }
        return result;
    }

    private Pair<TbMsgMetaData, CustomerId> getBaseMsgMetadataAndCustomerId(TenantId tenantId, EntityId entityId) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        CustomerId customerId = null;
        switch (entityId.getEntityType()) {
            case DEVICE: {
                Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, new DeviceId(entityId.getId()));
                if (device == null) break;
                customerId = device.getCustomerId();
                metaData.putValue("deviceName", device.getName());
                metaData.putValue("deviceType", device.getType());
                break;
            }
            case ASSET: {
                Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, new AssetId(entityId.getId()));
                if (asset == null) break;
                customerId = asset.getCustomerId();
                metaData.putValue("assetName", asset.getName());
                metaData.putValue("assetType", asset.getType());
                break;
            }
            case ENTITY_VIEW: {
                EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, new EntityViewId(entityId.getId()));
                if (entityView == null) break;
                customerId = entityView.getCustomerId();
                metaData.putValue("entityViewName", entityView.getName());
                metaData.putValue("entityViewType", entityView.getType());
                break;
            }
            case EDGE: {
                Edge edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, new EdgeId(entityId.getId()));
                if (edge == null) break;
                customerId = edge.getCustomerId();
                metaData.putValue("edgeName", edge.getName());
                metaData.putValue("edgeType", edge.getType());
                break;
            }
            default: {
                log.debug("[{}] Using empty metadata for entityId [{}]", (Object)tenantId, (Object)entityId);
            }
        }
        return new ImmutablePair((Object)metaData, (Object)(customerId != null ? customerId : new CustomerId(ModelConstants.NULL_UUID)));
    }

    private ListenableFuture<Void> processPostTelemetry(final TenantId tenantId, CustomerId customerId, EntityId entityId, final TransportProtos.PostTelemetryMsg msg, TbMsgMetaData metaData) {
        final SettableFuture futureToSet = SettableFuture.create();
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            JsonObject json = JsonUtils.getJsonObject((List)tsKv.getKvList());
            metaData.putValue("ts", "" + tsKv.getTs());
            Pair<String, RuleChainId> defaultQueueAndRuleChain = this.getDefaultQueueNameAndRuleChainId(tenantId, entityId);
            TbMsg tbMsg = TbMsg.newMsg().queueName((String)defaultQueueAndRuleChain.getKey()).type(TbMsgType.POST_TELEMETRY_REQUEST).originator(entityId).customerId(customerId).copyMetaData(metaData).data(this.gson.toJson((JsonElement)json)).ruleChainId((RuleChainId)defaultQueueAndRuleChain.getValue()).build();
            this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, tbMsg.getOriginator(), tbMsg, new TbQueueCallback(){

                public void onSuccess(TbQueueMsgMetadata metadata) {
                    futureToSet.set(null);
                }

                public void onFailure(Throwable t) {
                    log.error("[{}] Can't process post telemetry [{}]", new Object[]{tenantId, msg, t});
                    futureToSet.setException(t);
                }
            });
        }
        return futureToSet;
    }

    private Pair<String, RuleChainId> getDefaultQueueNameAndRuleChainId(TenantId tenantId, EntityId entityId) {
        RuleChainId ruleChainId = null;
        String queueName = null;
        if (EntityType.DEVICE.equals((Object)entityId.getEntityType())) {
            DeviceProfile deviceProfile = this.deviceProfileCache.get(tenantId, new DeviceId(entityId.getId()));
            if (deviceProfile == null) {
                log.warn("[{}][{}] Device profile is null!", (Object)tenantId, (Object)entityId);
            } else {
                ruleChainId = deviceProfile.getDefaultRuleChainId();
                queueName = deviceProfile.getDefaultQueueName();
            }
        } else if (EntityType.ASSET.equals((Object)entityId.getEntityType())) {
            AssetProfile assetProfile = this.assetProfileCache.get(tenantId, new AssetId(entityId.getId()));
            if (assetProfile == null) {
                log.warn("[{}][{}] Asset profile is null!", (Object)tenantId, (Object)entityId);
            } else {
                ruleChainId = assetProfile.getDefaultRuleChainId();
                queueName = assetProfile.getDefaultQueueName();
            }
        }
        return new ImmutablePair(queueName, ruleChainId);
    }

    private ListenableFuture<Void> processPostAttributes(final TenantId tenantId, final CustomerId customerId, final EntityId entityId, final TransportProtos.PostAttributeMsg msg, final TbMsgMetaData metaData, long ts) throws Exception {
        final SettableFuture futureToSet = SettableFuture.create();
        final JsonObject json = JsonUtils.getJsonObject((List)msg.getKvList());
        AttributeScope scope = AttributeScope.valueOf((String)metaData.getValue("scope"));
        List attributes = JsonConverter.convertToAttributes((JsonElement)json, (long)ts);
        ListenableFuture<List<AttributeKvEntry>> future = this.filterAttributesByTs(tenantId, entityId, scope, attributes);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<List<AttributeKvEntry>>(){

            public void onSuccess(List<AttributeKvEntry> attributesToSave) {
                JsonObject jsonToSave = BaseTelemetryProcessor.this.filterAttributesFromJson(json, attributesToSave);
                Pair<String, RuleChainId> defaultQueueAndRuleChain = BaseTelemetryProcessor.this.getDefaultQueueNameAndRuleChainId(tenantId, entityId);
                TbMsg tbMsg = TbMsg.newMsg().queueName((String)defaultQueueAndRuleChain.getKey()).type(TbMsgType.POST_ATTRIBUTES_REQUEST).originator(entityId).customerId(customerId).copyMetaData(metaData).data(BaseTelemetryProcessor.this.gson.toJson((JsonElement)jsonToSave)).ruleChainId((RuleChainId)defaultQueueAndRuleChain.getValue()).build();
                BaseTelemetryProcessor.this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, tbMsg.getOriginator(), tbMsg, new TbQueueCallback(){

                    public void onSuccess(TbQueueMsgMetadata metadata) {
                        futureToSet.set(null);
                    }

                    public void onFailure(Throwable t) {
                        log.error("[{}] Can't process post attributes [{}]", new Object[]{tenantId, msg, t});
                        futureToSet.setException(t);
                    }
                });
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Can't process post attributes [{}]", new Object[]{tenantId, msg, t});
                futureToSet.setException(t);
            }
        }, (Executor)((Object)this.dbCallbackExecutorService));
        return futureToSet;
    }

    private ListenableFuture<Void> processAttributesUpdate(final TenantId tenantId, final CustomerId customerId, final EntityId entityId, final TransportProtos.PostAttributeMsg msg, final TbMsgMetaData metaData, long ts) {
        final SettableFuture futureToSet = SettableFuture.create();
        final JsonObject json = JsonUtils.getJsonObject((List)msg.getKvList());
        final AttributeScope scope = AttributeScope.valueOf((String)metaData.getValue("scope"));
        List attributes = JsonConverter.convertToAttributes((JsonElement)json, (long)ts);
        ListenableFuture<List<AttributeKvEntry>> future = this.filterAttributesByTs(tenantId, entityId, scope, attributes);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<List<AttributeKvEntry>>(){

            public void onSuccess(List<AttributeKvEntry> attributesToSave) {
                final JsonObject jsonToSave = BaseTelemetryProcessor.this.filterAttributesFromJson(json, attributesToSave);
                BaseTelemetryProcessor.this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId(entityId).scope(scope).entries(attributesToSave).callback((FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void tmp) {
                        Pair<String, RuleChainId> defaultQueueAndRuleChain = BaseTelemetryProcessor.this.getDefaultQueueNameAndRuleChainId(tenantId, entityId);
                        TbMsg tbMsg = TbMsg.newMsg().queueName((String)defaultQueueAndRuleChain.getKey()).type(TbMsgType.ATTRIBUTES_UPDATED).originator(entityId).customerId(customerId).copyMetaData(metaData).data(BaseTelemetryProcessor.this.gson.toJson((JsonElement)jsonToSave)).ruleChainId((RuleChainId)defaultQueueAndRuleChain.getValue()).build();
                        BaseTelemetryProcessor.this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, tbMsg.getOriginator(), tbMsg, new TbQueueCallback(){

                            public void onSuccess(TbQueueMsgMetadata metadata) {
                                futureToSet.set(null);
                            }

                            public void onFailure(Throwable t) {
                                log.error("[{}] Can't process attributes update [{}]", new Object[]{tenantId, msg, t});
                                futureToSet.setException(t);
                            }
                        });
                    }

                    public void onFailure(Throwable t) {
                        log.error("[{}] Can't process attributes update [{}]", new Object[]{tenantId, msg, t});
                        futureToSet.setException(t);
                    }
                }).build());
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Can't process attributes update [{}]", new Object[]{tenantId, msg, t});
                futureToSet.setException(t);
            }
        }, (Executor)((Object)this.dbCallbackExecutorService));
        return futureToSet;
    }

    private JsonObject filterAttributesFromJson(JsonObject json, List<AttributeKvEntry> attributesToSave) {
        Set keysToSave = attributesToSave.stream().map(KvEntry::getKey).collect(Collectors.toSet());
        json.keySet().removeIf(key -> !keysToSave.contains(key));
        return json;
    }

    private ListenableFuture<Void> processAttributeDeleteMsg(TenantId tenantId, EntityId entityId, AttributeDeleteMsg attributeDeleteMsg, String entityType) {
        String scope = attributeDeleteMsg.getScope();
        ProtocolStringList attributeKeys = attributeDeleteMsg.getAttributeNamesList();
        ListenableFuture removeAllFuture = this.edgeCtx.getAttributesService().removeAll(tenantId, entityId, AttributeScope.valueOf((String)scope), (List)attributeKeys);
        return Futures.transformAsync((ListenableFuture)removeAllFuture, arg_0 -> this.lambda$processAttributeDeleteMsg$1(entityType, tenantId, entityId, scope, (List)attributeKeys, attributeDeleteMsg, arg_0), (Executor)((Object)this.dbCallbackExecutorService));
    }

    public EntityDataProto convertTelemetryEventToEntityDataProto(TenantId tenantId, EntityType entityType, UUID entityUUID, EdgeEventActionType actionType, JsonNode body) {
        TenantId entityId;
        switch (entityType) {
            case DEVICE: {
                entityId = new DeviceId(entityUUID);
                break;
            }
            case ASSET: {
                entityId = new AssetId(entityUUID);
                break;
            }
            case ENTITY_VIEW: {
                entityId = new EntityViewId(entityUUID);
                break;
            }
            case DASHBOARD: {
                entityId = new DashboardId(entityUUID);
                break;
            }
            case TENANT: {
                entityId = TenantId.fromUUID((UUID)entityUUID);
                break;
            }
            case CUSTOMER: {
                entityId = new CustomerId(entityUUID);
                break;
            }
            case USER: {
                entityId = new UserId(entityUUID);
                break;
            }
            case EDGE: {
                entityId = new EdgeId(entityUUID);
                break;
            }
            default: {
                log.warn("[{}] Unsupported edge event type [{}]", (Object)tenantId, (Object)entityType);
                return null;
            }
        }
        String bodyJackson = JacksonUtil.toString((Object)body);
        return bodyJackson == null ? null : EdgeMsgConstructorUtils.constructEntityDataMsg(tenantId, (EntityId)entityId, actionType, JsonParser.parseString((String)bodyJackson));
    }

    private ListenableFuture<List<AttributeKvEntry>> filterAttributesByTs(TenantId tenantId, EntityId entityId, AttributeScope scope, List<AttributeKvEntry> attributes) {
        List<String> keys = attributes.stream().map(KvEntry::getKey).toList();
        ListenableFuture future = this.edgeCtx.getAttributesService().find(tenantId, entityId, scope, keys);
        return Futures.transform((ListenableFuture)future, input -> {
            Map<String, Long> existingAttributesTs = input.stream().collect(Collectors.toMap(KvEntry::getKey, AttributeKvEntry::getLastUpdateTs));
            return attributes.stream().filter(attribute -> {
                String key = attribute.getKey();
                long incomingTs = attribute.getLastUpdateTs();
                return incomingTs > existingAttributesTs.getOrDefault(key, 0L);
            }).toList();
        }, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private /* synthetic */ ListenableFuture lambda$processAttributeDeleteMsg$1(String entityType, final TenantId tenantId, EntityId entityId, String scope, List attributeKeys, final AttributeDeleteMsg attributeDeleteMsg, List removeAttributes) throws Exception {
        if (EntityType.DEVICE.name().equals(entityType)) {
            final SettableFuture futureToSet = SettableFuture.create();
            this.edgeCtx.getClusterService().pushMsgToCore((ToDeviceActorNotificationMsg)DeviceAttributesEventNotificationMsg.onDelete((TenantId)tenantId, (DeviceId)((DeviceId)entityId), (String)scope, (List)attributeKeys), new TbQueueCallback(){

                public void onSuccess(TbQueueMsgMetadata metadata) {
                    futureToSet.set(null);
                }

                public void onFailure(Throwable t) {
                    log.error("[{}] Can't process attribute delete msg [{}]", new Object[]{tenantId, attributeDeleteMsg, t});
                    futureToSet.setException(t);
                }
            });
            return futureToSet;
        }
        return Futures.immediateFuture(null);
    }
}

