/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.dashboard;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.BaseDashboardProcessor;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.DashboardProcessor;

@Component
@TbCoreComponent
public class DashboardEdgeProcessor
extends BaseDashboardProcessor
implements DashboardProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Void> processDashboardMsgFromEdge(TenantId tenantId, Edge edge, DashboardUpdateMsg dashboardUpdateMsg) {
        log.trace("[{}] executing processDashboardMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, dashboardUpdateMsg, edge.getId()});
        DashboardId dashboardId = new DashboardId(new UUID(dashboardUpdateMsg.getIdMSB(), dashboardUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (dashboardUpdateMsg.getMsgType()) {
                case ENTITY_CREATED_RPC_MESSAGE: 
                case ENTITY_UPDATED_RPC_MESSAGE: {
                    this.saveOrUpdateDashboard(tenantId, dashboardId, dashboardUpdateMsg, edge);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case ENTITY_DELETED_RPC_MESSAGE: {
                    Dashboard dashboardToDelete = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
                    if (dashboardToDelete != null) {
                        this.edgeCtx.getDashboardService().unassignDashboardFromEdge(tenantId, dashboardId, edge.getId());
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture<Void> listenableFuture = this.handleUnsupportedMsgType(dashboardUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed dashboard violated {}", new Object[]{tenantId, dashboardUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateDashboard(TenantId tenantId, DashboardId dashboardId, DashboardUpdateMsg dashboardUpdateMsg, Edge edge) {
        boolean created = super.saveOrUpdateDashboard(tenantId, dashboardId, dashboardUpdateMsg, edge.getCustomerId());
        if (created) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)dashboardId);
            this.pushDashboardCreatedEventToRuleEngine(tenantId, edge, dashboardId);
            this.edgeCtx.getDashboardService().assignDashboardToEdge(tenantId, dashboardId, edge.getId());
        }
    }

    private void pushDashboardCreatedEventToRuleEngine(TenantId tenantId, Edge edge, DashboardId dashboardId) {
        try {
            Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
            String dashboardAsString = JacksonUtil.toString((Object)dashboard);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, null);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)dashboardId, null, TbMsgType.ENTITY_CREATED, dashboardAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push dashboard action to rule engine: {}", new Object[]{tenantId, dashboardId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    @Override
    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DashboardId dashboardId = new DashboardId(edgeEvent.getEntityId());
        switch (edgeEvent.getAction()) {
            case ADDED: 
            case UPDATED: 
            case ASSIGNED_TO_EDGE: 
            case ASSIGNED_TO_CUSTOMER: 
            case UNASSIGNED_FROM_CUSTOMER: {
                Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(edgeEvent.getTenantId(), dashboardId);
                if (dashboard == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DashboardUpdateMsg dashboardUpdateMsg = EdgeMsgConstructorUtils.constructDashboardUpdatedMsg(msgType, dashboard);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(dashboardUpdateMsg).build();
            }
            case DELETED: 
            case UNASSIGNED_FROM_EDGE: {
                DashboardUpdateMsg dashboardUpdateMsg = EdgeMsgConstructorUtils.constructDashboardDeleteMsg(dashboardId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(dashboardUpdateMsg).build();
            }
        }
        return null;
    }

    @Override
    protected Set<ShortCustomerInfo> filterNonExistingCustomers(TenantId tenantId, CustomerId edgeCustomerId, Set<ShortCustomerInfo> currentAssignedCustomers, Set<ShortCustomerInfo> newAssignedCustomers) {
        boolean edgeCustomerPresentInNewAssignments = newAssignedCustomers.stream().map(ShortCustomerInfo::getCustomerId).anyMatch(arg_0 -> ((CustomerId)edgeCustomerId).equals(arg_0));
        if (edgeCustomerPresentInNewAssignments) {
            HashSet<ShortCustomerInfo> result = new HashSet<ShortCustomerInfo>(newAssignedCustomers);
            result.addAll(currentAssignedCustomers);
            return result;
        }
        return currentAssignedCustomers.stream().filter(info -> !edgeCustomerId.equals((Object)info.getCustomerId())).collect(Collectors.toSet());
    }

    @Override
    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DASHBOARD;
    }
}

