/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.alarm;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.AlarmUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.alarm.AlarmProcessor;
import org.thingsboard.server.service.edge.rpc.processor.alarm.BaseAlarmProcessor;

@Component
@TbCoreComponent
public class AlarmEdgeProcessor
extends BaseAlarmProcessor
implements AlarmProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Void> processAlarmMsgFromEdge(TenantId tenantId, EdgeId edgeId, AlarmUpdateMsg alarmUpdateMsg) {
        log.trace("[{}] processAlarmMsgFromEdge [{}]", (Object)tenantId, (Object)alarmUpdateMsg);
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edgeId);
            ListenableFuture<Void> listenableFuture = this.processAlarmMsg(tenantId, alarmUpdateMsg);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    @Override
    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        AlarmUpdateMsg alarmUpdateMsg = this.convertAlarmEventToAlarmMsg(edgeEvent);
        if (alarmUpdateMsg != null) {
            return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAlarmUpdateMsg(alarmUpdateMsg).build();
        }
        return null;
    }

    @Override
    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        AlarmId alarmId = new AlarmId(new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        if (EdgeEventActionType.DELETED.equals((Object)actionType) || EdgeEventActionType.ALARM_DELETE.equals((Object)actionType)) {
            Alarm deletedAlarm = (Alarm)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), Alarm.class);
            if (deletedAlarm == null) {
                return Futures.immediateFuture(null);
            }
            List<ListenableFuture<Void>> delFutures = this.pushEventToAllRelatedEdges(tenantId, deletedAlarm.getOriginator(), alarmId, actionType, JacksonUtil.valueToTree((Object)deletedAlarm), originatorEdgeId, EdgeEventType.ALARM);
            return Futures.transform((ListenableFuture)Futures.allAsList(delFutures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
        }
        ListenableFuture alarmFuture = this.edgeCtx.getAlarmService().findAlarmByIdAsync(tenantId, alarmId);
        return Futures.transformAsync((ListenableFuture)alarmFuture, alarm -> {
            if (alarm == null) {
                return Futures.immediateFuture(null);
            }
            EdgeEventType type = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)alarm.getOriginator().getEntityType());
            if (type == null) {
                return Futures.immediateFuture(null);
            }
            List<ListenableFuture<Void>> futures = this.pushEventToAllRelatedEdges(tenantId, alarm.getOriginator(), alarmId, actionType, null, originatorEdgeId, EdgeEventType.ALARM);
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
        }, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private AlarmUpdateMsg convertAlarmEventToAlarmMsg(EdgeEvent edgeEvent) {
        AlarmId alarmId = new AlarmId(edgeEvent.getEntityId());
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        switch (edgeEvent.getAction()) {
            case ADDED: 
            case UPDATED: 
            case ALARM_ACK: 
            case ALARM_CLEAR: {
                Alarm alarm = this.edgeCtx.getAlarmService().findAlarmById(edgeEvent.getTenantId(), alarmId);
                if (alarm == null) break;
                return EdgeMsgConstructorUtils.constructAlarmUpdatedMsg(msgType, alarm);
            }
            case ALARM_DELETE: 
            case DELETED: {
                Alarm deletedAlarm = (Alarm)JacksonUtil.convertValue((Object)edgeEvent.getBody(), Alarm.class);
                if (deletedAlarm == null) break;
                return EdgeMsgConstructorUtils.constructAlarmUpdatedMsg(msgType, deletedAlarm);
            }
        }
        return null;
    }

    @Override
    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ALARM;
    }
}

