/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageDataIterableByTenantIdEntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainConnectionInfo;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.edge.EdgeSynchronizationManager;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.rpc.processor.EdgeProcessor;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

public abstract class BaseEdgeProcessor
implements EdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEdgeProcessor.class);
    protected static final Lock deviceCreationLock = new ReentrantLock();
    protected static final Lock assetCreationLock = new ReentrantLock();
    @Lazy
    @Autowired
    protected EdgeContextComponent edgeCtx;
    @Autowired
    protected EntityDaoRegistry entityDaoRegistry;
    @Autowired
    protected EdgeSynchronizationManager edgeSynchronizationManager;
    @Autowired
    protected DbCallbackExecutorService dbCallbackExecutorService;

    protected ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        return this.saveEdgeEvent(tenantId, edgeId, type, action, entityId, body, true);
    }

    protected ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, boolean doValidate) {
        if (doValidate) {
            ListenableFuture future = this.edgeCtx.getAttributesService().find(tenantId, (EntityId)edgeId, AttributeScope.SERVER_SCOPE, "active");
            return Futures.transformAsync((ListenableFuture)future, activeOpt -> {
                if (activeOpt.isEmpty()) {
                    log.trace("Edge is not activated. Skipping event. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body});
                    return Futures.immediateFuture(null);
                }
                if (((AttributeKvEntry)activeOpt.get()).getBooleanValue().isPresent() && ((Boolean)((AttributeKvEntry)activeOpt.get()).getBooleanValue().get()).booleanValue()) {
                    return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body);
                }
                if (this.doSaveIfEdgeIsOffline(type, action)) {
                    return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body);
                }
                log.trace("Edge is not active at the moment. Skipping event. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body});
                return Futures.immediateFuture(null);
            }, (Executor)((Object)this.dbCallbackExecutorService));
        }
        return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body);
    }

    private boolean doSaveIfEdgeIsOffline(EdgeEventType type, EdgeEventActionType action) {
        return switch (action) {
            case EdgeEventActionType.TIMESERIES_UPDATED, EdgeEventActionType.ALARM_ACK, EdgeEventActionType.ALARM_CLEAR, EdgeEventActionType.ALARM_ASSIGNED, EdgeEventActionType.ALARM_UNASSIGNED, EdgeEventActionType.ADDED_COMMENT, EdgeEventActionType.UPDATED_COMMENT, EdgeEventActionType.DELETED -> true;
            default -> {
                switch (type) {
                    case ALARM: 
                    case ALARM_COMMENT: 
                    case RULE_CHAIN: 
                    case RULE_CHAIN_METADATA: 
                    case USER: 
                    case CUSTOMER: 
                    case TENANT: 
                    case TENANT_PROFILE: 
                    case WIDGETS_BUNDLE: 
                    case WIDGET_TYPE: 
                    case ADMIN_SETTINGS: 
                    case OTA_PACKAGE: 
                    case QUEUE: 
                    case RELATION: 
                    case CALCULATED_FIELD: 
                    case NOTIFICATION_TEMPLATE: 
                    case NOTIFICATION_TARGET: 
                    case NOTIFICATION_RULE: {
                        yield true;
                    }
                }
                yield false;
            }
        };
    }

    private ListenableFuture<Void> doSaveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        log.debug("Pushing event to edge queue. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body});
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)action, (EntityId)entityId, (JsonNode)body);
        return this.edgeCtx.getEdgeEventService().saveAsync(edgeEvent);
    }

    protected ListenableFuture<Void> processActionForAllEdges(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, JsonNode body, EdgeId sourceEdgeId) {
        List<Object> futures = new ArrayList();
        if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
            PageDataIterable edges = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findActiveEdges(link), 1024);
            for (Edge edge : edges) {
                futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), type, actionType, entityId, body, false));
            }
        } else {
            futures = this.processActionForAllEdgesByTenantId(tenantId, type, actionType, entityId, null, sourceEdgeId);
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private List<ListenableFuture<Void>> processActionForAllEdgesByTenantId(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, JsonNode body, EdgeId sourceEdgeId) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterable edges = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findEdgesByTenantId(tenantId, link), 1024);
        for (Edge edge : edges) {
            if (edge.getId().equals((Object)sourceEdgeId)) continue;
            futures.add(this.saveEdgeEvent(tenantId, edge.getId(), type, actionType, entityId, body));
        }
        return futures;
    }

    protected ListenableFuture<Void> handleUnsupportedMsgType(UpdateMsgType msgType) {
        String errMsg = String.format("Unsupported msg type %s", msgType);
        log.error(errMsg);
        return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg));
    }

    protected UpdateMsgType getUpdateMsgType(EdgeEventActionType actionType) {
        return switch (actionType) {
            case EdgeEventActionType.UPDATED_COMMENT, EdgeEventActionType.UPDATED, EdgeEventActionType.CREDENTIALS_UPDATED, EdgeEventActionType.ASSIGNED_TO_CUSTOMER, EdgeEventActionType.UNASSIGNED_FROM_CUSTOMER -> UpdateMsgType.ENTITY_UPDATED_RPC_MESSAGE;
            case EdgeEventActionType.ADDED_COMMENT, EdgeEventActionType.ADDED, EdgeEventActionType.ASSIGNED_TO_EDGE, EdgeEventActionType.RELATION_ADD_OR_UPDATE -> UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE;
            case EdgeEventActionType.DELETED, EdgeEventActionType.UNASSIGNED_FROM_EDGE, EdgeEventActionType.RELATION_DELETED, EdgeEventActionType.DELETED_COMMENT, EdgeEventActionType.ALARM_DELETE -> UpdateMsgType.ENTITY_DELETED_RPC_MESSAGE;
            case EdgeEventActionType.ALARM_ACK -> UpdateMsgType.ALARM_ACK_RPC_MESSAGE;
            case EdgeEventActionType.ALARM_CLEAR -> UpdateMsgType.ALARM_CLEAR_RPC_MESSAGE;
            default -> throw new RuntimeException("Unsupported actionType [" + String.valueOf(actionType) + "]");
        };
    }

    @Override
    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        if (type.isAllEdgesRelated()) {
            return this.processEntityNotificationForAllEdges(tenantId, type, actionType, entityId, originatorEdgeId);
        }
        JsonNode body = JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody());
        EdgeId edgeId = this.safeGetEdgeId(edgeNotificationMsg.getEdgeIdMSB(), edgeNotificationMsg.getEdgeIdLSB());
        switch (actionType) {
            case UPDATED: 
            case CREDENTIALS_UPDATED: 
            case ASSIGNED_TO_CUSTOMER: 
            case UNASSIGNED_FROM_CUSTOMER: {
                if (edgeId != null && !edgeId.equals((Object)originatorEdgeId)) {
                    return this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body);
                }
                return this.processNotificationToRelatedEdges(tenantId, entityId, entityId, type, actionType, originatorEdgeId);
            }
            case DELETED: {
                EdgeEventActionType deleted = EdgeEventActionType.DELETED;
                if (edgeId != null) {
                    return this.saveEdgeEvent(tenantId, edgeId, type, deleted, entityId, body);
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(this.processActionForAllEdgesByTenantId(tenantId, type, deleted, entityId, body, originatorEdgeId)), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
            }
            case ASSIGNED_TO_EDGE: 
            case UNASSIGNED_FROM_EDGE: {
                if (originatorEdgeId == null) {
                    ListenableFuture<Void> future = this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body);
                    return Futures.transformAsync(future, unused -> {
                        if (type.equals((Object)EdgeEventType.RULE_CHAIN)) {
                            return this.updateDependentRuleChains(tenantId, new RuleChainId(entityId.getId()), edgeId);
                        }
                        return Futures.immediateFuture(null);
                    }, (Executor)((Object)this.dbCallbackExecutorService));
                }
                return Futures.immediateFuture(null);
            }
        }
        return Futures.immediateFuture(null);
    }

    protected EdgeId safeGetEdgeId(long edgeIdMSB, long edgeIdLSB) {
        if (edgeIdMSB != 0L && edgeIdLSB != 0L) {
            return new EdgeId(new UUID(edgeIdMSB, edgeIdLSB));
        }
        return null;
    }

    protected ListenableFuture<Void> processNotificationToRelatedEdges(TenantId tenantId, EntityId ownerEntityId, EntityId entityId, EdgeEventType type, EdgeEventActionType actionType, EdgeId sourceEdgeId) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterableByTenantIdEntityId edgeIds = new PageDataIterableByTenantIdEntityId((arg_0, arg_1, arg_2) -> ((EdgeService)this.edgeCtx.getEdgeService()).findRelatedEdgeIdsByEntityId(arg_0, arg_1, arg_2), tenantId, ownerEntityId, 1000);
        for (EdgeId relatedEdgeId : edgeIds) {
            if (relatedEdgeId.equals((Object)sourceEdgeId)) continue;
            futures.add(this.saveEdgeEvent(tenantId, relatedEdgeId, type, actionType, entityId, null));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private ListenableFuture<Void> updateDependentRuleChains(TenantId tenantId, RuleChainId processingRuleChainId, EdgeId edgeId) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterable ruleChains = new PageDataIterable(link -> this.edgeCtx.getRuleChainService().findRuleChainsByTenantIdAndEdgeId(tenantId, edgeId, link), 1024);
        for (RuleChain ruleChain : ruleChains) {
            List connectionInfos = this.edgeCtx.getRuleChainService().loadRuleChainMetaData(ruleChain.getTenantId(), ruleChain.getId()).getRuleChainConnections();
            if (connectionInfos == null || connectionInfos.isEmpty()) continue;
            for (RuleChainConnectionInfo connectionInfo : connectionInfos) {
                if (!connectionInfo.getTargetRuleChainId().equals((Object)processingRuleChainId)) continue;
                futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.RULE_CHAIN_METADATA, EdgeEventActionType.UPDATED, (EntityId)ruleChain.getId(), null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private ListenableFuture<Void> processEntityNotificationForAllEdges(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, EdgeId sourceEdgeId) {
        return switch (actionType) {
            case EdgeEventActionType.DELETED, EdgeEventActionType.UPDATED, EdgeEventActionType.CREDENTIALS_UPDATED, EdgeEventActionType.ADDED -> this.processActionForAllEdges(tenantId, type, actionType, entityId, null, sourceEdgeId);
            default -> Futures.immediateFuture(null);
        };
    }

    protected EntityId constructEntityId(String entityTypeStr, long entityIdMSB, long entityIdLSB) {
        EntityType entityType = EntityType.valueOf((String)entityTypeStr);
        return switch (entityType) {
            case EntityType.DEVICE -> new DeviceId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.ASSET -> new AssetId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.ENTITY_VIEW -> new EntityViewId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.DASHBOARD -> new DashboardId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.TENANT -> TenantId.fromUUID((UUID)new UUID(entityIdMSB, entityIdLSB));
            case EntityType.CUSTOMER -> new CustomerId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.USER -> new UserId(new UUID(entityIdMSB, entityIdLSB));
            case EntityType.EDGE -> new EdgeId(new UUID(entityIdMSB, entityIdLSB));
            default -> {
                log.warn("Unsupported entity type [{}] during construct of entity id. entityIdMSB [{}], entityIdLSB [{}]", new Object[]{entityTypeStr, entityIdMSB, entityIdLSB});
                yield null;
            }
        };
    }

    protected UUID safeGetUUID(long mSB, long lSB) {
        return mSB != 0L && lSB != 0L ? new UUID(mSB, lSB) : null;
    }

    protected CustomerId safeGetCustomerId(long mSB, long lSB) {
        CustomerId customerId = null;
        UUID customerUUID = this.safeGetUUID(mSB, lSB);
        if (customerUUID != null) {
            customerId = new CustomerId(customerUUID);
        }
        return customerId;
    }

    protected boolean isEntityExists(TenantId tenantId, EntityId entityId) {
        return this.entityDaoRegistry.getDao(entityId.getEntityType()).existsById(tenantId, entityId.getId());
    }

    protected void createRelationFromEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId) {
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)edgeId);
        relation.setTo(entityId);
        relation.setTypeGroup(RelationTypeGroup.COMMON);
        relation.setType("ManagedByEdge");
        this.edgeCtx.getRelationService().saveRelation(tenantId, relation);
    }

    protected TbMsgMetaData getEdgeActionTbMsgMetaData(Edge edge, CustomerId customerId) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("edgeId", edge.getId().toString());
        metaData.putValue("edgeName", edge.getName());
        if (customerId != null && !customerId.isNullUid()) {
            metaData.putValue("customerId", customerId.toString());
        }
        return metaData;
    }

    protected void pushEntityEventToRuleEngine(final TenantId tenantId, EntityId entityId, CustomerId customerId, TbMsgType msgType, final String msgData, TbMsgMetaData metaData) {
        TbMsg tbMsg = TbMsg.newMsg().type(msgType).originator(entityId).customerId(customerId).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(msgData).build();
        this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, entityId, tbMsg, new TbQueueCallback(){

            public void onSuccess(TbQueueMsgMetadata metadata) {
                log.debug("[{}] Successfully send ENTITY_CREATED EVENT to rule engine [{}]", (Object)tenantId, (Object)msgData);
            }

            public void onFailure(Throwable t) {
                log.warn("[{}] Failed to send ENTITY_CREATED EVENT to rule engine [{}]", new Object[]{tenantId, msgData, t});
            }
        });
    }
}

