/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class TenantResourcesEdgeEventFetcher
extends BasePageableEdgeEventFetcher<TbResource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantResourcesEdgeEventFetcher.class);
    private final ResourceService resourceService;

    @Override
    PageData<TbResource> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.resourceService.findAllTenantResources(tenantId, pageLink);
    }

    @Override
    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, TbResource tbResource) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.TB_RESOURCE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)tbResource.getId(), null);
    }

    @ConstructorProperties(value={"resourceService"})
    @Generated
    public TenantResourcesEdgeEventFetcher(ResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

