/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class QueuesEdgeEventFetcher
extends BasePageableEdgeEventFetcher<Queue> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueuesEdgeEventFetcher.class);
    private final QueueService queueService;

    @Override
    PageData<Queue> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.queueService.findQueuesByTenantId(tenantId, pageLink);
    }

    @Override
    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, Queue queue) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.QUEUE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)((EntityId)queue.getId()), null);
    }

    @ConstructorProperties(value={"queueService"})
    @Generated
    public QueuesEdgeEventFetcher(QueueService queueService) {
        this.queueService = queueService;
    }
}

