/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class OtaPackagesEdgeEventFetcher
extends BasePageableEdgeEventFetcher<OtaPackageInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackagesEdgeEventFetcher.class);
    private final OtaPackageService otaPackageService;

    @Override
    PageData<OtaPackageInfo> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.otaPackageService.findTenantOtaPackagesByTenantId(tenantId, pageLink);
    }

    @Override
    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, OtaPackageInfo otaPackageInfo) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.OTA_PACKAGE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)otaPackageInfo.getId(), null);
    }

    @ConstructorProperties(value={"otaPackageService"})
    @Generated
    public OtaPackagesEdgeEventFetcher(OtaPackageService otaPackageService) {
        this.otaPackageService = otaPackageService;
    }
}

