/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class DevicesEdgeEventFetcher
extends BasePageableEdgeEventFetcher<Device> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DevicesEdgeEventFetcher.class);
    private final DeviceService deviceService;

    @Override
    PageData<Device> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.deviceService.findDevicesByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    @Override
    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, Device device) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.DEVICE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)device.getId(), null);
    }

    @ConstructorProperties(value={"deviceService"})
    @Generated
    public DevicesEdgeEventFetcher(DeviceService deviceService) {
        this.deviceService = deviceService;
    }
}

