/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.edge.stats.EdgeStatsCounterService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.EdgeEventStorageSettings;
import org.thingsboard.server.service.edge.rpc.EdgeRpcService;
import org.thingsboard.server.service.edge.rpc.processor.EdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.alarm.AlarmProcessor;
import org.thingsboard.server.service.edge.rpc.processor.alarm.comment.AlarmCommentProcessor;
import org.thingsboard.server.service.edge.rpc.processor.asset.AssetEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.asset.profile.AssetProfileEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.cf.CalculatedFieldProcessor;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.DashboardEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.DeviceEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.profile.DeviceProfileEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.entityview.EntityViewEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.relation.RelationEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.resource.ResourceEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.rule.RuleChainEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.rule.RuleChainMetadataEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.telemetry.TelemetryEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.sync.EdgeRequestsService;
import org.thingsboard.server.service.executors.GrpcCallbackExecutorService;

@Lazy
@Component
@TbCoreComponent
public class EdgeContextComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeContextComponent.class);
    private final Map<EdgeEventType, EdgeProcessor> processorMap = new EnumMap<EdgeEventType, EdgeProcessor>(EdgeEventType.class);
    @Autowired
    private AdminSettingsService adminSettingsService;
    @Autowired
    private AlarmCommentService alarmCommentService;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AssetProfileService assetProfileService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private DeviceCredentialsService deviceCredentialsService;
    @Autowired
    private DeviceProfileService deviceProfileService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private EdgeEventService edgeEventService;
    @Autowired
    private EdgeRequestsService edgeRequestsService;
    @Autowired(required=false)
    private EdgeRpcService edgeRpcService;
    @Autowired
    private EdgeService edgeService;
    @Autowired
    private EntityViewService entityViewService;
    @Autowired
    private NotificationRuleService notificationRuleService;
    @Autowired
    private NotificationTargetService notificationTargetService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private OtaPackageService otaPackageService;
    @Autowired
    private QueueService queueService;
    @Autowired
    private RateLimitService rateLimitService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private RuleChainService ruleChainService;
    @Autowired
    private TbClusterService clusterService;
    @Autowired
    private TenantProfileService tenantProfileService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UserService userService;
    @Autowired
    private WidgetTypeService widgetTypeService;
    @Autowired
    private WidgetsBundleService widgetsBundleService;
    @Autowired
    private Optional<EdgeStatsCounterService> statsCounterService;
    @Autowired
    private AlarmProcessor alarmProcessor;
    @Autowired
    private AlarmCommentProcessor alarmCommentProcessor;
    @Autowired
    private AssetEdgeProcessor assetProcessor;
    @Autowired
    private AssetProfileEdgeProcessor assetProfileProcessor;
    @Autowired
    private DashboardEdgeProcessor dashboardProcessor;
    @Autowired
    private DeviceEdgeProcessor deviceProcessor;
    @Autowired
    private DeviceProfileEdgeProcessor deviceProfileProcessor;
    @Autowired
    private EntityViewEdgeProcessor entityViewProcessor;
    @Autowired
    private NotificationRuleProcessor ruleProcessor;
    @Autowired
    private RelationEdgeProcessor relationProcessor;
    @Autowired
    private ResourceEdgeProcessor resourceProcessor;
    @Autowired
    private RuleChainEdgeProcessor ruleChainProcessor;
    @Autowired
    private RuleChainMetadataEdgeProcessor ruleChainMetadataProcessor;
    @Autowired
    private TelemetryEdgeProcessor telemetryProcessor;
    @Autowired
    private EdgeEventStorageSettings edgeEventStorageSettings;
    @Autowired
    private GrpcCallbackExecutorService grpcCallbackExecutorService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private CalculatedFieldProcessor calculatedFieldProcessor;

    @Autowired
    public EdgeContextComponent(List<EdgeProcessor> processors) {
        processors.forEach(processor -> {
            EdgeEventType eventType = processor.getEdgeEventType();
            if (eventType != null) {
                this.processorMap.put(eventType, (EdgeProcessor)processor);
            }
        });
    }

    public EdgeProcessor getProcessor(EdgeEventType edgeEventType) {
        EdgeProcessor processor = this.processorMap.get(edgeEventType);
        if (processor == null) {
            throw new UnsupportedOperationException("No processor found for EdgeEventType: " + String.valueOf(edgeEventType));
        }
        return processor;
    }

    @Generated
    public Map<EdgeEventType, EdgeProcessor> getProcessorMap() {
        return this.processorMap;
    }

    @Generated
    public AdminSettingsService getAdminSettingsService() {
        return this.adminSettingsService;
    }

    @Generated
    public AlarmCommentService getAlarmCommentService() {
        return this.alarmCommentService;
    }

    @Generated
    public AlarmService getAlarmService() {
        return this.alarmService;
    }

    @Generated
    public AssetProfileService getAssetProfileService() {
        return this.assetProfileService;
    }

    @Generated
    public AssetService getAssetService() {
        return this.assetService;
    }

    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Generated
    public CustomerService getCustomerService() {
        return this.customerService;
    }

    @Generated
    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    @Generated
    public DeviceCredentialsService getDeviceCredentialsService() {
        return this.deviceCredentialsService;
    }

    @Generated
    public DeviceProfileService getDeviceProfileService() {
        return this.deviceProfileService;
    }

    @Generated
    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public EdgeEventService getEdgeEventService() {
        return this.edgeEventService;
    }

    @Generated
    public EdgeRequestsService getEdgeRequestsService() {
        return this.edgeRequestsService;
    }

    @Generated
    public EdgeRpcService getEdgeRpcService() {
        return this.edgeRpcService;
    }

    @Generated
    public EdgeService getEdgeService() {
        return this.edgeService;
    }

    @Generated
    public EntityViewService getEntityViewService() {
        return this.entityViewService;
    }

    @Generated
    public NotificationRuleService getNotificationRuleService() {
        return this.notificationRuleService;
    }

    @Generated
    public NotificationTargetService getNotificationTargetService() {
        return this.notificationTargetService;
    }

    @Generated
    public NotificationTemplateService getNotificationTemplateService() {
        return this.notificationTemplateService;
    }

    @Generated
    public OAuth2ClientService getOAuth2ClientService() {
        return this.oAuth2ClientService;
    }

    @Generated
    public OtaPackageService getOtaPackageService() {
        return this.otaPackageService;
    }

    @Generated
    public QueueService getQueueService() {
        return this.queueService;
    }

    @Generated
    public RateLimitService getRateLimitService() {
        return this.rateLimitService;
    }

    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Generated
    public ResourceService getResourceService() {
        return this.resourceService;
    }

    @Generated
    public RuleChainService getRuleChainService() {
        return this.ruleChainService;
    }

    @Generated
    public TbClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public TenantProfileService getTenantProfileService() {
        return this.tenantProfileService;
    }

    @Generated
    public TenantService getTenantService() {
        return this.tenantService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public WidgetTypeService getWidgetTypeService() {
        return this.widgetTypeService;
    }

    @Generated
    public WidgetsBundleService getWidgetsBundleService() {
        return this.widgetsBundleService;
    }

    @Generated
    public Optional<EdgeStatsCounterService> getStatsCounterService() {
        return this.statsCounterService;
    }

    @Generated
    public AlarmProcessor getAlarmProcessor() {
        return this.alarmProcessor;
    }

    @Generated
    public AlarmCommentProcessor getAlarmCommentProcessor() {
        return this.alarmCommentProcessor;
    }

    @Generated
    public AssetEdgeProcessor getAssetProcessor() {
        return this.assetProcessor;
    }

    @Generated
    public AssetProfileEdgeProcessor getAssetProfileProcessor() {
        return this.assetProfileProcessor;
    }

    @Generated
    public DashboardEdgeProcessor getDashboardProcessor() {
        return this.dashboardProcessor;
    }

    @Generated
    public DeviceEdgeProcessor getDeviceProcessor() {
        return this.deviceProcessor;
    }

    @Generated
    public DeviceProfileEdgeProcessor getDeviceProfileProcessor() {
        return this.deviceProfileProcessor;
    }

    @Generated
    public EntityViewEdgeProcessor getEntityViewProcessor() {
        return this.entityViewProcessor;
    }

    @Generated
    public NotificationRuleProcessor getRuleProcessor() {
        return this.ruleProcessor;
    }

    @Generated
    public RelationEdgeProcessor getRelationProcessor() {
        return this.relationProcessor;
    }

    @Generated
    public ResourceEdgeProcessor getResourceProcessor() {
        return this.resourceProcessor;
    }

    @Generated
    public RuleChainEdgeProcessor getRuleChainProcessor() {
        return this.ruleChainProcessor;
    }

    @Generated
    public RuleChainMetadataEdgeProcessor getRuleChainMetadataProcessor() {
        return this.ruleChainMetadataProcessor;
    }

    @Generated
    public TelemetryEdgeProcessor getTelemetryProcessor() {
        return this.telemetryProcessor;
    }

    @Generated
    public EdgeEventStorageSettings getEdgeEventStorageSettings() {
        return this.edgeEventStorageSettings;
    }

    @Generated
    public GrpcCallbackExecutorService getGrpcCallbackExecutorService() {
        return this.grpcCallbackExecutorService;
    }

    @Generated
    public CalculatedFieldService getCalculatedFieldService() {
        return this.calculatedFieldService;
    }

    @Generated
    public CalculatedFieldProcessor getCalculatedFieldProcessor() {
        return this.calculatedFieldProcessor;
    }

    @Generated
    public void setAdminSettingsService(AdminSettingsService adminSettingsService) {
        this.adminSettingsService = adminSettingsService;
    }

    @Generated
    public void setAlarmCommentService(AlarmCommentService alarmCommentService) {
        this.alarmCommentService = alarmCommentService;
    }

    @Generated
    public void setAlarmService(AlarmService alarmService) {
        this.alarmService = alarmService;
    }

    @Generated
    public void setAssetProfileService(AssetProfileService assetProfileService) {
        this.assetProfileService = assetProfileService;
    }

    @Generated
    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @Generated
    public void setAttributesService(AttributesService attributesService) {
        this.attributesService = attributesService;
    }

    @Generated
    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Generated
    public void setDashboardService(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @Generated
    public void setDeviceCredentialsService(DeviceCredentialsService deviceCredentialsService) {
        this.deviceCredentialsService = deviceCredentialsService;
    }

    @Generated
    public void setDeviceProfileService(DeviceProfileService deviceProfileService) {
        this.deviceProfileService = deviceProfileService;
    }

    @Generated
    public void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setEdgeEventService(EdgeEventService edgeEventService) {
        this.edgeEventService = edgeEventService;
    }

    @Generated
    public void setEdgeRequestsService(EdgeRequestsService edgeRequestsService) {
        this.edgeRequestsService = edgeRequestsService;
    }

    @Generated
    public void setEdgeRpcService(EdgeRpcService edgeRpcService) {
        this.edgeRpcService = edgeRpcService;
    }

    @Generated
    public void setEdgeService(EdgeService edgeService) {
        this.edgeService = edgeService;
    }

    @Generated
    public void setEntityViewService(EntityViewService entityViewService) {
        this.entityViewService = entityViewService;
    }

    @Generated
    public void setNotificationRuleService(NotificationRuleService notificationRuleService) {
        this.notificationRuleService = notificationRuleService;
    }

    @Generated
    public void setNotificationTargetService(NotificationTargetService notificationTargetService) {
        this.notificationTargetService = notificationTargetService;
    }

    @Generated
    public void setNotificationTemplateService(NotificationTemplateService notificationTemplateService) {
        this.notificationTemplateService = notificationTemplateService;
    }

    @Generated
    public void setOAuth2ClientService(OAuth2ClientService oAuth2ClientService) {
        this.oAuth2ClientService = oAuth2ClientService;
    }

    @Generated
    public void setOtaPackageService(OtaPackageService otaPackageService) {
        this.otaPackageService = otaPackageService;
    }

    @Generated
    public void setQueueService(QueueService queueService) {
        this.queueService = queueService;
    }

    @Generated
    public void setRateLimitService(RateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    @Generated
    public void setRelationService(RelationService relationService) {
        this.relationService = relationService;
    }

    @Generated
    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Generated
    public void setRuleChainService(RuleChainService ruleChainService) {
        this.ruleChainService = ruleChainService;
    }

    @Generated
    public void setClusterService(TbClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setTenantProfileService(TenantProfileService tenantProfileService) {
        this.tenantProfileService = tenantProfileService;
    }

    @Generated
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Generated
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Generated
    public void setWidgetTypeService(WidgetTypeService widgetTypeService) {
        this.widgetTypeService = widgetTypeService;
    }

    @Generated
    public void setWidgetsBundleService(WidgetsBundleService widgetsBundleService) {
        this.widgetsBundleService = widgetsBundleService;
    }

    @Generated
    public void setStatsCounterService(Optional<EdgeStatsCounterService> statsCounterService) {
        this.statsCounterService = statsCounterService;
    }

    @Generated
    public void setAlarmProcessor(AlarmProcessor alarmProcessor) {
        this.alarmProcessor = alarmProcessor;
    }

    @Generated
    public void setAlarmCommentProcessor(AlarmCommentProcessor alarmCommentProcessor) {
        this.alarmCommentProcessor = alarmCommentProcessor;
    }

    @Generated
    public void setAssetProcessor(AssetEdgeProcessor assetProcessor) {
        this.assetProcessor = assetProcessor;
    }

    @Generated
    public void setAssetProfileProcessor(AssetProfileEdgeProcessor assetProfileProcessor) {
        this.assetProfileProcessor = assetProfileProcessor;
    }

    @Generated
    public void setDashboardProcessor(DashboardEdgeProcessor dashboardProcessor) {
        this.dashboardProcessor = dashboardProcessor;
    }

    @Generated
    public void setDeviceProcessor(DeviceEdgeProcessor deviceProcessor) {
        this.deviceProcessor = deviceProcessor;
    }

    @Generated
    public void setDeviceProfileProcessor(DeviceProfileEdgeProcessor deviceProfileProcessor) {
        this.deviceProfileProcessor = deviceProfileProcessor;
    }

    @Generated
    public void setEntityViewProcessor(EntityViewEdgeProcessor entityViewProcessor) {
        this.entityViewProcessor = entityViewProcessor;
    }

    @Generated
    public void setRuleProcessor(NotificationRuleProcessor ruleProcessor) {
        this.ruleProcessor = ruleProcessor;
    }

    @Generated
    public void setRelationProcessor(RelationEdgeProcessor relationProcessor) {
        this.relationProcessor = relationProcessor;
    }

    @Generated
    public void setResourceProcessor(ResourceEdgeProcessor resourceProcessor) {
        this.resourceProcessor = resourceProcessor;
    }

    @Generated
    public void setRuleChainProcessor(RuleChainEdgeProcessor ruleChainProcessor) {
        this.ruleChainProcessor = ruleChainProcessor;
    }

    @Generated
    public void setRuleChainMetadataProcessor(RuleChainMetadataEdgeProcessor ruleChainMetadataProcessor) {
        this.ruleChainMetadataProcessor = ruleChainMetadataProcessor;
    }

    @Generated
    public void setTelemetryProcessor(TelemetryEdgeProcessor telemetryProcessor) {
        this.telemetryProcessor = telemetryProcessor;
    }

    @Generated
    public void setEdgeEventStorageSettings(EdgeEventStorageSettings edgeEventStorageSettings) {
        this.edgeEventStorageSettings = edgeEventStorageSettings;
    }

    @Generated
    public void setGrpcCallbackExecutorService(GrpcCallbackExecutorService grpcCallbackExecutorService) {
        this.grpcCallbackExecutorService = grpcCallbackExecutorService;
    }

    @Generated
    public void setCalculatedFieldService(CalculatedFieldService calculatedFieldService) {
        this.calculatedFieldService = calculatedFieldService;
    }

    @Generated
    public void setCalculatedFieldProcessor(CalculatedFieldProcessor calculatedFieldProcessor) {
        this.calculatedFieldProcessor = calculatedFieldProcessor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeContextComponent)) {
            return false;
        }
        EdgeContextComponent other = (EdgeContextComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<EdgeEventType, EdgeProcessor> this$processorMap = this.getProcessorMap();
        Map<EdgeEventType, EdgeProcessor> other$processorMap = other.getProcessorMap();
        if (this$processorMap == null ? other$processorMap != null : !((Object)this$processorMap).equals(other$processorMap)) {
            return false;
        }
        AdminSettingsService this$adminSettingsService = this.getAdminSettingsService();
        AdminSettingsService other$adminSettingsService = other.getAdminSettingsService();
        if (this$adminSettingsService == null ? other$adminSettingsService != null : !this$adminSettingsService.equals(other$adminSettingsService)) {
            return false;
        }
        AlarmCommentService this$alarmCommentService = this.getAlarmCommentService();
        AlarmCommentService other$alarmCommentService = other.getAlarmCommentService();
        if (this$alarmCommentService == null ? other$alarmCommentService != null : !this$alarmCommentService.equals(other$alarmCommentService)) {
            return false;
        }
        AlarmService this$alarmService = this.getAlarmService();
        AlarmService other$alarmService = other.getAlarmService();
        if (this$alarmService == null ? other$alarmService != null : !this$alarmService.equals(other$alarmService)) {
            return false;
        }
        AssetProfileService this$assetProfileService = this.getAssetProfileService();
        AssetProfileService other$assetProfileService = other.getAssetProfileService();
        if (this$assetProfileService == null ? other$assetProfileService != null : !this$assetProfileService.equals(other$assetProfileService)) {
            return false;
        }
        AssetService this$assetService = this.getAssetService();
        AssetService other$assetService = other.getAssetService();
        if (this$assetService == null ? other$assetService != null : !this$assetService.equals(other$assetService)) {
            return false;
        }
        AttributesService this$attributesService = this.getAttributesService();
        AttributesService other$attributesService = other.getAttributesService();
        if (this$attributesService == null ? other$attributesService != null : !this$attributesService.equals(other$attributesService)) {
            return false;
        }
        CustomerService this$customerService = this.getCustomerService();
        CustomerService other$customerService = other.getCustomerService();
        if (this$customerService == null ? other$customerService != null : !this$customerService.equals(other$customerService)) {
            return false;
        }
        DashboardService this$dashboardService = this.getDashboardService();
        DashboardService other$dashboardService = other.getDashboardService();
        if (this$dashboardService == null ? other$dashboardService != null : !this$dashboardService.equals(other$dashboardService)) {
            return false;
        }
        DeviceCredentialsService this$deviceCredentialsService = this.getDeviceCredentialsService();
        DeviceCredentialsService other$deviceCredentialsService = other.getDeviceCredentialsService();
        if (this$deviceCredentialsService == null ? other$deviceCredentialsService != null : !this$deviceCredentialsService.equals(other$deviceCredentialsService)) {
            return false;
        }
        DeviceProfileService this$deviceProfileService = this.getDeviceProfileService();
        DeviceProfileService other$deviceProfileService = other.getDeviceProfileService();
        if (this$deviceProfileService == null ? other$deviceProfileService != null : !this$deviceProfileService.equals(other$deviceProfileService)) {
            return false;
        }
        DeviceService this$deviceService = this.getDeviceService();
        DeviceService other$deviceService = other.getDeviceService();
        if (this$deviceService == null ? other$deviceService != null : !this$deviceService.equals(other$deviceService)) {
            return false;
        }
        DomainService this$domainService = this.getDomainService();
        DomainService other$domainService = other.getDomainService();
        if (this$domainService == null ? other$domainService != null : !this$domainService.equals(other$domainService)) {
            return false;
        }
        EdgeEventService this$edgeEventService = this.getEdgeEventService();
        EdgeEventService other$edgeEventService = other.getEdgeEventService();
        if (this$edgeEventService == null ? other$edgeEventService != null : !this$edgeEventService.equals(other$edgeEventService)) {
            return false;
        }
        EdgeRequestsService this$edgeRequestsService = this.getEdgeRequestsService();
        EdgeRequestsService other$edgeRequestsService = other.getEdgeRequestsService();
        if (this$edgeRequestsService == null ? other$edgeRequestsService != null : !this$edgeRequestsService.equals(other$edgeRequestsService)) {
            return false;
        }
        EdgeRpcService this$edgeRpcService = this.getEdgeRpcService();
        EdgeRpcService other$edgeRpcService = other.getEdgeRpcService();
        if (this$edgeRpcService == null ? other$edgeRpcService != null : !this$edgeRpcService.equals(other$edgeRpcService)) {
            return false;
        }
        EdgeService this$edgeService = this.getEdgeService();
        EdgeService other$edgeService = other.getEdgeService();
        if (this$edgeService == null ? other$edgeService != null : !this$edgeService.equals(other$edgeService)) {
            return false;
        }
        EntityViewService this$entityViewService = this.getEntityViewService();
        EntityViewService other$entityViewService = other.getEntityViewService();
        if (this$entityViewService == null ? other$entityViewService != null : !this$entityViewService.equals(other$entityViewService)) {
            return false;
        }
        NotificationRuleService this$notificationRuleService = this.getNotificationRuleService();
        NotificationRuleService other$notificationRuleService = other.getNotificationRuleService();
        if (this$notificationRuleService == null ? other$notificationRuleService != null : !this$notificationRuleService.equals(other$notificationRuleService)) {
            return false;
        }
        NotificationTargetService this$notificationTargetService = this.getNotificationTargetService();
        NotificationTargetService other$notificationTargetService = other.getNotificationTargetService();
        if (this$notificationTargetService == null ? other$notificationTargetService != null : !this$notificationTargetService.equals(other$notificationTargetService)) {
            return false;
        }
        NotificationTemplateService this$notificationTemplateService = this.getNotificationTemplateService();
        NotificationTemplateService other$notificationTemplateService = other.getNotificationTemplateService();
        if (this$notificationTemplateService == null ? other$notificationTemplateService != null : !this$notificationTemplateService.equals(other$notificationTemplateService)) {
            return false;
        }
        OAuth2ClientService this$oAuth2ClientService = this.getOAuth2ClientService();
        OAuth2ClientService other$oAuth2ClientService = other.getOAuth2ClientService();
        if (this$oAuth2ClientService == null ? other$oAuth2ClientService != null : !this$oAuth2ClientService.equals(other$oAuth2ClientService)) {
            return false;
        }
        OtaPackageService this$otaPackageService = this.getOtaPackageService();
        OtaPackageService other$otaPackageService = other.getOtaPackageService();
        if (this$otaPackageService == null ? other$otaPackageService != null : !this$otaPackageService.equals(other$otaPackageService)) {
            return false;
        }
        QueueService this$queueService = this.getQueueService();
        QueueService other$queueService = other.getQueueService();
        if (this$queueService == null ? other$queueService != null : !this$queueService.equals(other$queueService)) {
            return false;
        }
        RateLimitService this$rateLimitService = this.getRateLimitService();
        RateLimitService other$rateLimitService = other.getRateLimitService();
        if (this$rateLimitService == null ? other$rateLimitService != null : !this$rateLimitService.equals(other$rateLimitService)) {
            return false;
        }
        RelationService this$relationService = this.getRelationService();
        RelationService other$relationService = other.getRelationService();
        if (this$relationService == null ? other$relationService != null : !this$relationService.equals(other$relationService)) {
            return false;
        }
        ResourceService this$resourceService = this.getResourceService();
        ResourceService other$resourceService = other.getResourceService();
        if (this$resourceService == null ? other$resourceService != null : !this$resourceService.equals(other$resourceService)) {
            return false;
        }
        RuleChainService this$ruleChainService = this.getRuleChainService();
        RuleChainService other$ruleChainService = other.getRuleChainService();
        if (this$ruleChainService == null ? other$ruleChainService != null : !this$ruleChainService.equals(other$ruleChainService)) {
            return false;
        }
        TbClusterService this$clusterService = this.getClusterService();
        TbClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        TenantProfileService this$tenantProfileService = this.getTenantProfileService();
        TenantProfileService other$tenantProfileService = other.getTenantProfileService();
        if (this$tenantProfileService == null ? other$tenantProfileService != null : !this$tenantProfileService.equals(other$tenantProfileService)) {
            return false;
        }
        TenantService this$tenantService = this.getTenantService();
        TenantService other$tenantService = other.getTenantService();
        if (this$tenantService == null ? other$tenantService != null : !this$tenantService.equals(other$tenantService)) {
            return false;
        }
        UserService this$userService = this.getUserService();
        UserService other$userService = other.getUserService();
        if (this$userService == null ? other$userService != null : !this$userService.equals(other$userService)) {
            return false;
        }
        WidgetTypeService this$widgetTypeService = this.getWidgetTypeService();
        WidgetTypeService other$widgetTypeService = other.getWidgetTypeService();
        if (this$widgetTypeService == null ? other$widgetTypeService != null : !this$widgetTypeService.equals(other$widgetTypeService)) {
            return false;
        }
        WidgetsBundleService this$widgetsBundleService = this.getWidgetsBundleService();
        WidgetsBundleService other$widgetsBundleService = other.getWidgetsBundleService();
        if (this$widgetsBundleService == null ? other$widgetsBundleService != null : !this$widgetsBundleService.equals(other$widgetsBundleService)) {
            return false;
        }
        Optional<EdgeStatsCounterService> this$statsCounterService = this.getStatsCounterService();
        Optional<EdgeStatsCounterService> other$statsCounterService = other.getStatsCounterService();
        if (this$statsCounterService == null ? other$statsCounterService != null : !((Object)this$statsCounterService).equals(other$statsCounterService)) {
            return false;
        }
        AlarmProcessor this$alarmProcessor = this.getAlarmProcessor();
        AlarmProcessor other$alarmProcessor = other.getAlarmProcessor();
        if (this$alarmProcessor == null ? other$alarmProcessor != null : !this$alarmProcessor.equals(other$alarmProcessor)) {
            return false;
        }
        AlarmCommentProcessor this$alarmCommentProcessor = this.getAlarmCommentProcessor();
        AlarmCommentProcessor other$alarmCommentProcessor = other.getAlarmCommentProcessor();
        if (this$alarmCommentProcessor == null ? other$alarmCommentProcessor != null : !this$alarmCommentProcessor.equals(other$alarmCommentProcessor)) {
            return false;
        }
        AssetEdgeProcessor this$assetProcessor = this.getAssetProcessor();
        AssetEdgeProcessor other$assetProcessor = other.getAssetProcessor();
        if (this$assetProcessor == null ? other$assetProcessor != null : !this$assetProcessor.equals(other$assetProcessor)) {
            return false;
        }
        AssetProfileEdgeProcessor this$assetProfileProcessor = this.getAssetProfileProcessor();
        AssetProfileEdgeProcessor other$assetProfileProcessor = other.getAssetProfileProcessor();
        if (this$assetProfileProcessor == null ? other$assetProfileProcessor != null : !this$assetProfileProcessor.equals(other$assetProfileProcessor)) {
            return false;
        }
        DashboardEdgeProcessor this$dashboardProcessor = this.getDashboardProcessor();
        DashboardEdgeProcessor other$dashboardProcessor = other.getDashboardProcessor();
        if (this$dashboardProcessor == null ? other$dashboardProcessor != null : !this$dashboardProcessor.equals(other$dashboardProcessor)) {
            return false;
        }
        DeviceEdgeProcessor this$deviceProcessor = this.getDeviceProcessor();
        DeviceEdgeProcessor other$deviceProcessor = other.getDeviceProcessor();
        if (this$deviceProcessor == null ? other$deviceProcessor != null : !this$deviceProcessor.equals(other$deviceProcessor)) {
            return false;
        }
        DeviceProfileEdgeProcessor this$deviceProfileProcessor = this.getDeviceProfileProcessor();
        DeviceProfileEdgeProcessor other$deviceProfileProcessor = other.getDeviceProfileProcessor();
        if (this$deviceProfileProcessor == null ? other$deviceProfileProcessor != null : !this$deviceProfileProcessor.equals(other$deviceProfileProcessor)) {
            return false;
        }
        EntityViewEdgeProcessor this$entityViewProcessor = this.getEntityViewProcessor();
        EntityViewEdgeProcessor other$entityViewProcessor = other.getEntityViewProcessor();
        if (this$entityViewProcessor == null ? other$entityViewProcessor != null : !this$entityViewProcessor.equals(other$entityViewProcessor)) {
            return false;
        }
        NotificationRuleProcessor this$ruleProcessor = this.getRuleProcessor();
        NotificationRuleProcessor other$ruleProcessor = other.getRuleProcessor();
        if (this$ruleProcessor == null ? other$ruleProcessor != null : !this$ruleProcessor.equals(other$ruleProcessor)) {
            return false;
        }
        RelationEdgeProcessor this$relationProcessor = this.getRelationProcessor();
        RelationEdgeProcessor other$relationProcessor = other.getRelationProcessor();
        if (this$relationProcessor == null ? other$relationProcessor != null : !this$relationProcessor.equals(other$relationProcessor)) {
            return false;
        }
        ResourceEdgeProcessor this$resourceProcessor = this.getResourceProcessor();
        ResourceEdgeProcessor other$resourceProcessor = other.getResourceProcessor();
        if (this$resourceProcessor == null ? other$resourceProcessor != null : !this$resourceProcessor.equals(other$resourceProcessor)) {
            return false;
        }
        RuleChainEdgeProcessor this$ruleChainProcessor = this.getRuleChainProcessor();
        RuleChainEdgeProcessor other$ruleChainProcessor = other.getRuleChainProcessor();
        if (this$ruleChainProcessor == null ? other$ruleChainProcessor != null : !this$ruleChainProcessor.equals(other$ruleChainProcessor)) {
            return false;
        }
        RuleChainMetadataEdgeProcessor this$ruleChainMetadataProcessor = this.getRuleChainMetadataProcessor();
        RuleChainMetadataEdgeProcessor other$ruleChainMetadataProcessor = other.getRuleChainMetadataProcessor();
        if (this$ruleChainMetadataProcessor == null ? other$ruleChainMetadataProcessor != null : !this$ruleChainMetadataProcessor.equals(other$ruleChainMetadataProcessor)) {
            return false;
        }
        TelemetryEdgeProcessor this$telemetryProcessor = this.getTelemetryProcessor();
        TelemetryEdgeProcessor other$telemetryProcessor = other.getTelemetryProcessor();
        if (this$telemetryProcessor == null ? other$telemetryProcessor != null : !this$telemetryProcessor.equals(other$telemetryProcessor)) {
            return false;
        }
        EdgeEventStorageSettings this$edgeEventStorageSettings = this.getEdgeEventStorageSettings();
        EdgeEventStorageSettings other$edgeEventStorageSettings = other.getEdgeEventStorageSettings();
        if (this$edgeEventStorageSettings == null ? other$edgeEventStorageSettings != null : !((Object)this$edgeEventStorageSettings).equals(other$edgeEventStorageSettings)) {
            return false;
        }
        GrpcCallbackExecutorService this$grpcCallbackExecutorService = this.getGrpcCallbackExecutorService();
        GrpcCallbackExecutorService other$grpcCallbackExecutorService = other.getGrpcCallbackExecutorService();
        if (this$grpcCallbackExecutorService == null ? other$grpcCallbackExecutorService != null : !((Object)((Object)this$grpcCallbackExecutorService)).equals((Object)other$grpcCallbackExecutorService)) {
            return false;
        }
        CalculatedFieldService this$calculatedFieldService = this.getCalculatedFieldService();
        CalculatedFieldService other$calculatedFieldService = other.getCalculatedFieldService();
        if (this$calculatedFieldService == null ? other$calculatedFieldService != null : !this$calculatedFieldService.equals(other$calculatedFieldService)) {
            return false;
        }
        CalculatedFieldProcessor this$calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        CalculatedFieldProcessor other$calculatedFieldProcessor = other.getCalculatedFieldProcessor();
        return !(this$calculatedFieldProcessor == null ? other$calculatedFieldProcessor != null : !this$calculatedFieldProcessor.equals(other$calculatedFieldProcessor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdgeContextComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EdgeEventType, EdgeProcessor> $processorMap = this.getProcessorMap();
        result = result * 59 + ($processorMap == null ? 43 : ((Object)$processorMap).hashCode());
        AdminSettingsService $adminSettingsService = this.getAdminSettingsService();
        result = result * 59 + ($adminSettingsService == null ? 43 : $adminSettingsService.hashCode());
        AlarmCommentService $alarmCommentService = this.getAlarmCommentService();
        result = result * 59 + ($alarmCommentService == null ? 43 : $alarmCommentService.hashCode());
        AlarmService $alarmService = this.getAlarmService();
        result = result * 59 + ($alarmService == null ? 43 : $alarmService.hashCode());
        AssetProfileService $assetProfileService = this.getAssetProfileService();
        result = result * 59 + ($assetProfileService == null ? 43 : $assetProfileService.hashCode());
        AssetService $assetService = this.getAssetService();
        result = result * 59 + ($assetService == null ? 43 : $assetService.hashCode());
        AttributesService $attributesService = this.getAttributesService();
        result = result * 59 + ($attributesService == null ? 43 : $attributesService.hashCode());
        CustomerService $customerService = this.getCustomerService();
        result = result * 59 + ($customerService == null ? 43 : $customerService.hashCode());
        DashboardService $dashboardService = this.getDashboardService();
        result = result * 59 + ($dashboardService == null ? 43 : $dashboardService.hashCode());
        DeviceCredentialsService $deviceCredentialsService = this.getDeviceCredentialsService();
        result = result * 59 + ($deviceCredentialsService == null ? 43 : $deviceCredentialsService.hashCode());
        DeviceProfileService $deviceProfileService = this.getDeviceProfileService();
        result = result * 59 + ($deviceProfileService == null ? 43 : $deviceProfileService.hashCode());
        DeviceService $deviceService = this.getDeviceService();
        result = result * 59 + ($deviceService == null ? 43 : $deviceService.hashCode());
        DomainService $domainService = this.getDomainService();
        result = result * 59 + ($domainService == null ? 43 : $domainService.hashCode());
        EdgeEventService $edgeEventService = this.getEdgeEventService();
        result = result * 59 + ($edgeEventService == null ? 43 : $edgeEventService.hashCode());
        EdgeRequestsService $edgeRequestsService = this.getEdgeRequestsService();
        result = result * 59 + ($edgeRequestsService == null ? 43 : $edgeRequestsService.hashCode());
        EdgeRpcService $edgeRpcService = this.getEdgeRpcService();
        result = result * 59 + ($edgeRpcService == null ? 43 : $edgeRpcService.hashCode());
        EdgeService $edgeService = this.getEdgeService();
        result = result * 59 + ($edgeService == null ? 43 : $edgeService.hashCode());
        EntityViewService $entityViewService = this.getEntityViewService();
        result = result * 59 + ($entityViewService == null ? 43 : $entityViewService.hashCode());
        NotificationRuleService $notificationRuleService = this.getNotificationRuleService();
        result = result * 59 + ($notificationRuleService == null ? 43 : $notificationRuleService.hashCode());
        NotificationTargetService $notificationTargetService = this.getNotificationTargetService();
        result = result * 59 + ($notificationTargetService == null ? 43 : $notificationTargetService.hashCode());
        NotificationTemplateService $notificationTemplateService = this.getNotificationTemplateService();
        result = result * 59 + ($notificationTemplateService == null ? 43 : $notificationTemplateService.hashCode());
        OAuth2ClientService $oAuth2ClientService = this.getOAuth2ClientService();
        result = result * 59 + ($oAuth2ClientService == null ? 43 : $oAuth2ClientService.hashCode());
        OtaPackageService $otaPackageService = this.getOtaPackageService();
        result = result * 59 + ($otaPackageService == null ? 43 : $otaPackageService.hashCode());
        QueueService $queueService = this.getQueueService();
        result = result * 59 + ($queueService == null ? 43 : $queueService.hashCode());
        RateLimitService $rateLimitService = this.getRateLimitService();
        result = result * 59 + ($rateLimitService == null ? 43 : $rateLimitService.hashCode());
        RelationService $relationService = this.getRelationService();
        result = result * 59 + ($relationService == null ? 43 : $relationService.hashCode());
        ResourceService $resourceService = this.getResourceService();
        result = result * 59 + ($resourceService == null ? 43 : $resourceService.hashCode());
        RuleChainService $ruleChainService = this.getRuleChainService();
        result = result * 59 + ($ruleChainService == null ? 43 : $ruleChainService.hashCode());
        TbClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        TenantProfileService $tenantProfileService = this.getTenantProfileService();
        result = result * 59 + ($tenantProfileService == null ? 43 : $tenantProfileService.hashCode());
        TenantService $tenantService = this.getTenantService();
        result = result * 59 + ($tenantService == null ? 43 : $tenantService.hashCode());
        UserService $userService = this.getUserService();
        result = result * 59 + ($userService == null ? 43 : $userService.hashCode());
        WidgetTypeService $widgetTypeService = this.getWidgetTypeService();
        result = result * 59 + ($widgetTypeService == null ? 43 : $widgetTypeService.hashCode());
        WidgetsBundleService $widgetsBundleService = this.getWidgetsBundleService();
        result = result * 59 + ($widgetsBundleService == null ? 43 : $widgetsBundleService.hashCode());
        Optional<EdgeStatsCounterService> $statsCounterService = this.getStatsCounterService();
        result = result * 59 + ($statsCounterService == null ? 43 : ((Object)$statsCounterService).hashCode());
        AlarmProcessor $alarmProcessor = this.getAlarmProcessor();
        result = result * 59 + ($alarmProcessor == null ? 43 : $alarmProcessor.hashCode());
        AlarmCommentProcessor $alarmCommentProcessor = this.getAlarmCommentProcessor();
        result = result * 59 + ($alarmCommentProcessor == null ? 43 : $alarmCommentProcessor.hashCode());
        AssetEdgeProcessor $assetProcessor = this.getAssetProcessor();
        result = result * 59 + ($assetProcessor == null ? 43 : $assetProcessor.hashCode());
        AssetProfileEdgeProcessor $assetProfileProcessor = this.getAssetProfileProcessor();
        result = result * 59 + ($assetProfileProcessor == null ? 43 : $assetProfileProcessor.hashCode());
        DashboardEdgeProcessor $dashboardProcessor = this.getDashboardProcessor();
        result = result * 59 + ($dashboardProcessor == null ? 43 : $dashboardProcessor.hashCode());
        DeviceEdgeProcessor $deviceProcessor = this.getDeviceProcessor();
        result = result * 59 + ($deviceProcessor == null ? 43 : $deviceProcessor.hashCode());
        DeviceProfileEdgeProcessor $deviceProfileProcessor = this.getDeviceProfileProcessor();
        result = result * 59 + ($deviceProfileProcessor == null ? 43 : $deviceProfileProcessor.hashCode());
        EntityViewEdgeProcessor $entityViewProcessor = this.getEntityViewProcessor();
        result = result * 59 + ($entityViewProcessor == null ? 43 : $entityViewProcessor.hashCode());
        NotificationRuleProcessor $ruleProcessor = this.getRuleProcessor();
        result = result * 59 + ($ruleProcessor == null ? 43 : $ruleProcessor.hashCode());
        RelationEdgeProcessor $relationProcessor = this.getRelationProcessor();
        result = result * 59 + ($relationProcessor == null ? 43 : $relationProcessor.hashCode());
        ResourceEdgeProcessor $resourceProcessor = this.getResourceProcessor();
        result = result * 59 + ($resourceProcessor == null ? 43 : $resourceProcessor.hashCode());
        RuleChainEdgeProcessor $ruleChainProcessor = this.getRuleChainProcessor();
        result = result * 59 + ($ruleChainProcessor == null ? 43 : $ruleChainProcessor.hashCode());
        RuleChainMetadataEdgeProcessor $ruleChainMetadataProcessor = this.getRuleChainMetadataProcessor();
        result = result * 59 + ($ruleChainMetadataProcessor == null ? 43 : $ruleChainMetadataProcessor.hashCode());
        TelemetryEdgeProcessor $telemetryProcessor = this.getTelemetryProcessor();
        result = result * 59 + ($telemetryProcessor == null ? 43 : $telemetryProcessor.hashCode());
        EdgeEventStorageSettings $edgeEventStorageSettings = this.getEdgeEventStorageSettings();
        result = result * 59 + ($edgeEventStorageSettings == null ? 43 : ((Object)$edgeEventStorageSettings).hashCode());
        GrpcCallbackExecutorService $grpcCallbackExecutorService = this.getGrpcCallbackExecutorService();
        result = result * 59 + ($grpcCallbackExecutorService == null ? 43 : ((Object)((Object)$grpcCallbackExecutorService)).hashCode());
        CalculatedFieldService $calculatedFieldService = this.getCalculatedFieldService();
        result = result * 59 + ($calculatedFieldService == null ? 43 : $calculatedFieldService.hashCode());
        CalculatedFieldProcessor $calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        result = result * 59 + ($calculatedFieldProcessor == null ? 43 : $calculatedFieldProcessor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdgeContextComponent(processorMap=" + String.valueOf(this.getProcessorMap()) + ", adminSettingsService=" + String.valueOf(this.getAdminSettingsService()) + ", alarmCommentService=" + String.valueOf(this.getAlarmCommentService()) + ", alarmService=" + String.valueOf(this.getAlarmService()) + ", assetProfileService=" + String.valueOf(this.getAssetProfileService()) + ", assetService=" + String.valueOf(this.getAssetService()) + ", attributesService=" + String.valueOf(this.getAttributesService()) + ", customerService=" + String.valueOf(this.getCustomerService()) + ", dashboardService=" + String.valueOf(this.getDashboardService()) + ", deviceCredentialsService=" + String.valueOf(this.getDeviceCredentialsService()) + ", deviceProfileService=" + String.valueOf(this.getDeviceProfileService()) + ", deviceService=" + String.valueOf(this.getDeviceService()) + ", domainService=" + String.valueOf(this.getDomainService()) + ", edgeEventService=" + String.valueOf(this.getEdgeEventService()) + ", edgeRequestsService=" + String.valueOf(this.getEdgeRequestsService()) + ", edgeRpcService=" + String.valueOf(this.getEdgeRpcService()) + ", edgeService=" + String.valueOf(this.getEdgeService()) + ", entityViewService=" + String.valueOf(this.getEntityViewService()) + ", notificationRuleService=" + String.valueOf(this.getNotificationRuleService()) + ", notificationTargetService=" + String.valueOf(this.getNotificationTargetService()) + ", notificationTemplateService=" + String.valueOf(this.getNotificationTemplateService()) + ", oAuth2ClientService=" + String.valueOf(this.getOAuth2ClientService()) + ", otaPackageService=" + String.valueOf(this.getOtaPackageService()) + ", queueService=" + String.valueOf(this.getQueueService()) + ", rateLimitService=" + String.valueOf(this.getRateLimitService()) + ", relationService=" + String.valueOf(this.getRelationService()) + ", resourceService=" + String.valueOf(this.getResourceService()) + ", ruleChainService=" + String.valueOf(this.getRuleChainService()) + ", clusterService=" + String.valueOf(this.getClusterService()) + ", tenantProfileService=" + String.valueOf(this.getTenantProfileService()) + ", tenantService=" + String.valueOf(this.getTenantService()) + ", userService=" + String.valueOf(this.getUserService()) + ", widgetTypeService=" + String.valueOf(this.getWidgetTypeService()) + ", widgetsBundleService=" + String.valueOf(this.getWidgetsBundleService()) + ", statsCounterService=" + String.valueOf(this.getStatsCounterService()) + ", alarmProcessor=" + String.valueOf(this.getAlarmProcessor()) + ", alarmCommentProcessor=" + String.valueOf(this.getAlarmCommentProcessor()) + ", assetProcessor=" + String.valueOf(this.getAssetProcessor()) + ", assetProfileProcessor=" + String.valueOf(this.getAssetProfileProcessor()) + ", dashboardProcessor=" + String.valueOf(this.getDashboardProcessor()) + ", deviceProcessor=" + String.valueOf(this.getDeviceProcessor()) + ", deviceProfileProcessor=" + String.valueOf(this.getDeviceProfileProcessor()) + ", entityViewProcessor=" + String.valueOf(this.getEntityViewProcessor()) + ", ruleProcessor=" + String.valueOf(this.getRuleProcessor()) + ", relationProcessor=" + String.valueOf(this.getRelationProcessor()) + ", resourceProcessor=" + String.valueOf(this.getResourceProcessor()) + ", ruleChainProcessor=" + String.valueOf(this.getRuleChainProcessor()) + ", ruleChainMetadataProcessor=" + String.valueOf(this.getRuleChainMetadataProcessor()) + ", telemetryProcessor=" + String.valueOf(this.getTelemetryProcessor()) + ", edgeEventStorageSettings=" + String.valueOf(this.getEdgeEventStorageSettings()) + ", grpcCallbackExecutorService=" + String.valueOf((Object)this.getGrpcCallbackExecutorService()) + ", calculatedFieldService=" + String.valueOf(this.getCalculatedFieldService()) + ", calculatedFieldProcessor=" + String.valueOf(this.getCalculatedFieldProcessor()) + ")";
    }
}

