/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasAdditionalInfo;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportColumnType;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.edge.TbEdgeService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.sync.ie.importing.csv.AbstractBulkImportService;

@Service
@TbCoreComponent
public class EdgeBulkImportService
extends AbstractBulkImportService<Edge> {
    private final EdgeService edgeService;
    private final TbEdgeService tbEdgeService;
    private final RuleChainService ruleChainService;

    @Override
    protected void setEntityFields(Edge entity, Map<BulkImportColumnType, String> fields) {
        ObjectNode additionalInfo = this.getOrCreateAdditionalInfoObj((HasAdditionalInfo)entity);
        fields.forEach((columnType, value) -> {
            switch (columnType) {
                case NAME: {
                    entity.setName(value);
                    break;
                }
                case TYPE: {
                    entity.setType(value);
                    break;
                }
                case LABEL: {
                    entity.setLabel(value);
                    break;
                }
                case DESCRIPTION: {
                    additionalInfo.set("description", (JsonNode)new TextNode(value));
                    break;
                }
                case ROUTING_KEY: {
                    entity.setRoutingKey(value);
                    break;
                }
                case SECRET: {
                    entity.setSecret(value);
                }
            }
        });
        entity.setAdditionalInfo((JsonNode)additionalInfo);
    }

    @Override
    protected Edge saveEntity(SecurityUser user, Edge entity, Map<BulkImportColumnType, String> fields) {
        RuleChain edgeTemplateRootRuleChain = this.ruleChainService.getEdgeTemplateRootRuleChain(user.getTenantId());
        return this.tbEdgeService.save(entity, edgeTemplateRootRuleChain, user);
    }

    @Override
    protected Edge findOrCreateEntity(TenantId tenantId, String name) {
        return Optional.ofNullable(this.edgeService.findEdgeByTenantIdAndName(tenantId, name)).orElseGet(Edge::new);
    }

    @Override
    protected void setOwners(Edge entity, SecurityUser user) {
        entity.setTenantId(user.getTenantId());
        entity.setCustomerId(user.getCustomerId());
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.EDGE;
    }

    @ConstructorProperties(value={"edgeService", "tbEdgeService", "ruleChainService"})
    @Generated
    public EdgeBulkImportService(EdgeService edgeService, TbEdgeService tbEdgeService, RuleChainService ruleChainService) {
        this.edgeService = edgeService;
        this.tbEdgeService = tbEdgeService;
        this.ruleChainService = ruleChainService;
    }
}

