/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.script.ScriptException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldScriptEngine;

public class CalculatedFieldTbelScriptEngine
implements CalculatedFieldScriptEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldTbelScriptEngine.class);
    private final TbelInvokeService tbelInvokeService;
    private final UUID scriptId;
    private final TenantId tenantId;

    public CalculatedFieldTbelScriptEngine(TenantId tenantId, TbelInvokeService tbelInvokeService, String script, String ... argNames) {
        this.tenantId = tenantId;
        this.tbelInvokeService = tbelInvokeService;
        try {
            this.scriptId = (UUID)this.tbelInvokeService.eval(tenantId, ScriptType.CALCULATED_FIELD_SCRIPT, script, argNames).get();
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof ExecutionException) {
                t = e.getCause();
            }
            throw new IllegalArgumentException("Can't compile script: " + t.getMessage(), t);
        }
    }

    @Override
    public ListenableFuture<Object> executeScriptAsync(Object[] args) {
        log.trace("Executing script async, args {}", args);
        return Futures.transformAsync((ListenableFuture)this.tbelInvokeService.invokeScript(this.tenantId, null, this.scriptId, args), o -> {
            try {
                return Futures.immediateFuture((Object)o);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ScriptException) {
                    return Futures.immediateFailedFuture((Throwable)e.getCause());
                }
                if (e.getCause() instanceof RuntimeException) {
                    return Futures.immediateFailedFuture((Throwable)new ScriptException(e.getCause().getMessage()));
                }
                return Futures.immediateFailedFuture((Throwable)new ScriptException(e));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<JsonNode> executeJsonAsync(Object[] args) {
        return Futures.transform(this.executeScriptAsync(args), JacksonUtil::valueToTree, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void destroy() {
        this.tbelInvokeService.release(this.scriptId);
    }
}

